/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.CommentType;

import lombok.Data;

/**
 * @title CommentInfoDto
 * @desc 备注信息
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
@Data
public class CommentInfoDto implements Serializable {

    private static final long serialVersionUID = 7044214649851292546L;

    private Long commentId;

    private Integer seconds = 0;

    private Long soundId = 0l;

    private String soundUrl;

    private String urls;

    private String storageIds = StringUtils.EMPTY;

    private String content = StringUtils.EMPTY;

    private Date createTime;

    private Integer downLoadStatus;

    private Integer isMobile;

    private Integer callStatus;

    private Integer isSystem;

    private Integer commentType;
    private String commentTypeStr;
    private Integer notifyParents;
    private String notifyColleague;
    private Integer growthComments;
    private Integer creatorCascadeId;
    private CreatorDto creator;

    // 跟进记录来源：来自发活动、来自预约留单...
    private String origin = "";

    public void setOrigin(int originSignType) {
        String msg = MessageSource.getDesc(originSignType);
        this.origin = (null != msg ? msg : "");
    }

    public void setCommentType(Integer commentType) {
        this.commentType = commentType;
        this.commentTypeStr = CommentType.getLabel(commentType);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getCreatorCascadeId() {
        return this.creatorCascadeId;
    }

    public void setCreatorCascadeId(Integer creatorCascadeId) {
        this.creatorCascadeId = creatorCascadeId;
    }
}
