/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl.customFields;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeFactory;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.FieldTypeContentFactory;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.MultiChoiceFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.MultiChoiceFieldTypeWrapper;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.PositionFieldType;
import com.baijia.tianxiao.sal.student.enums.ConsultFieldEnum;
import com.baijia.tianxiao.sal.student.enums.CustomFieldSections;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.student.enums.UseStatus;
import com.baijia.tianxiao.sal.student.util.SystemFieldOptionFactory;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldValuesServiceImpl
implements CustomFieldValueService {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldValuesServiceImpl.class);
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    public static final String VALUE_KEY = "VALUE_KEY";

    @Override
    public void setCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent, Long studentIdOrConsultId) {
        orgUserBaseInfo.setSections(CustomFieldSections.listAllSections());
        List customFieldConfigs = this.customFieldDao.getCustomFieldListWithCondition(orgId, Boolean.valueOf(false));
        if (GenericsUtils.isNullOrEmpty((Object)customFieldConfigs)) {
            this.customFieldService.initSystemField(orgId);
            customFieldConfigs = this.customFieldDao.getCustomFieldListWithCondition(orgId, Boolean.valueOf(false));
        }
        ArrayList systemFields = Lists.newArrayList();
        ArrayList otherFields = Lists.newArrayList();
        for (CustomField customField : customFieldConfigs) {
            if (customField.getSystemFieldNum() != -1) {
                systemFields.add(customField);
                continue;
            }
            otherFields.add(customField);
        }
        this.setSystemFields(orgUserBaseInfo, systemFields);
        if (otherFields != null && otherFields.size() > 0) {
            this.setOtherFields(orgUserBaseInfo, orgId, isStudent, studentIdOrConsultId, otherFields);
        }
    }

    private void setOtherFields(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent, Long studentIdOrConsultId, List<CustomField> otherFields) {
        ArrayList<Long> fieldIds = new ArrayList<Long>();
        for (CustomField customField : otherFields) {
            fieldIds.add(customField.getId());
        }
        log.info("fieldIds param:{}", fieldIds);
        log.info("orgId {}, isStudent {}, studentIdOrConsultId {}, fieldIds {}", new Object[]{orgId, isStudent, studentIdOrConsultId, fieldIds});
        List values = this.customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentIdOrConsultId, fieldIds);
        HashMap<Long, CustomFieldValue> customFieldValueMap = new HashMap<Long, CustomFieldValue>();
        if (GenericsUtils.notNullAndEmpty((Object)values)) {
            for (CustomFieldValue value : values) {
                customFieldValueMap.put(value.getFieldId(), value);
            }
        }
        for (CustomField customField : otherFields) {
            CustomFieldValue fieldValue = (CustomFieldValue)customFieldValueMap.get(customField.getId());
            log.info("CustomFieldValue getInfo fieldValue param:{}", (Object)fieldValue);
            CustomFieldDto dto = new CustomFieldDto();
            if (fieldValue != null) {
                HashMap map = Maps.newHashMap();
                map.put(VALUE_KEY, fieldValue.getValue());
                dto = this.createCustomFieldDto(customField, map, false, null);
            } else {
                CustomFieldTypeInterface defaultValueObject = null;
                if (studentIdOrConsultId == -1L) {
                    List options = this.txCustomOptionDao.getTXCustomOptionListWithCondition(customField.getId(), Boolean.valueOf(false), Integer.valueOf(1));
                    defaultValueObject = FieldTypeContentFactory.getContent(customField, options);
                }
                dto = this.createCustomFieldDto(customField, null, false, defaultValueObject);
            }
            orgUserBaseInfo.getFields().add(dto);
        }
    }

    private void setSystemFields(OrgUserBaseInfo orgUserBaseInfo, List<CustomField> systemFields) {
        if (GenericsUtils.isNullOrEmpty(systemFields)) {
            log.info("can not find any system fields");
            return;
        }
        Map nameFieldMap = CollectionUtils.extractMap(systemFields, (CollectionUtils.Extracter)new CollectionUtils.Extracter<List<String>, CustomField>(){

            public List<String> extract(CustomField paramE) {
                String name = paramE.getName();
                return Arrays.asList(name.split(","));
            }
        });
        try {
            HashMap propertyValues = Maps.newHashMap();
            BeanInfo beanInfo = Introspector.getBeanInfo(OrgUserBaseInfo.class);
            PropertyDescriptor[] proDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : proDescriptors) {
                String name = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                if (method == null) continue;
                Object invoke = method.invoke((Object)orgUserBaseInfo, new Object[0]);
                propertyValues.put(name, invoke);
            }
            for (Map.Entry entry : nameFieldMap.entrySet()) {
                List keys = (List)entry.getKey();
                CustomField field = (CustomField)entry.getValue();
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (String key : keys) {
                    values.put(key, propertyValues.get(key));
                }
                CustomFieldValueResponse cfd = this.createCustomFieldDto(field, values, true, null);
                orgUserBaseInfo.getFields().add(cfd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("error while setSystemFields cause by : {} ", (Throwable)e);
        }
    }

    private CustomFieldValueResponse createCustomFieldDto(CustomField customField, Map<String, Object> valueMap, boolean isSystem, Object defaultValue) {
        CustomFieldValueResponse cfd = new CustomFieldValueResponse();
        cfd.setIsRequired(customField.getIsRequired());
        if (isSystem) {
            cfd.setKey(customField.getName());
        } else {
            cfd.setKey(String.valueOf(customField.getId()));
        }
        cfd.setLabel(customField.getLabel());
        cfd.setSorted(customField.getSorted());
        Integer fieldType = customField.getType();
        CustomFieldType fieldTypeEnum = CustomFieldType.getCustomFieldType(fieldType);
        Object jsonValue = defaultValue;
        if (isSystem) {
            SystemFields systemField = SystemFields.getSystemField(customField.getName());
            jsonValue = systemField.instance(valueMap);
            cfd.setOptions(SystemFieldOptionFactory.getOptions(systemField));
        } else if (!isSystem && valueMap != null) {
            CustomFieldTypeInterface findCustomFieldSolver = CustomFieldTypeFactory.findCustomFieldSolver(fieldTypeEnum);
            String value = String.valueOf(valueMap.get(VALUE_KEY));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                jsonValue = findCustomFieldSolver.jsonToObj(value);
            }
        }
        cfd.setValues(jsonValue);
        if (CustomFieldType.getChoiceType().contains(fieldTypeEnum.getType())) {
            List<FieldOption> options = this.retrievalOptions(customField, cfd);
            cfd.setOptions(options);
        }
        cfd.setSectionId(customField.getSectionId());
        cfd.setType(fieldType);
        cfd.setValidateRule(null);
        return cfd;
    }

    private List<FieldOption> retrievalOptions(CustomField customField, CustomFieldDto cfd) {
        List<Object> retOpts = Lists.newArrayList();
        if (customField.getSystemFieldNum() == -1) {
            List customChoiceFieldList = null;
            customChoiceFieldList = this.txCustomOptionDao.getTXCustomOptionListWithCondition(customField.getId(), Boolean.valueOf(false), null);
            if (GenericsUtils.isNullOrEmpty((Object)customChoiceFieldList)) {
                return Collections.emptyList();
            }
            for (TXCustomOption ccf : customChoiceFieldList) {
                retOpts.add(FieldOption.buildDto(ccf));
            }
        } else {
            retOpts = cfd.getOptions();
        }
        return retOpts;
    }

    public static void main(String[] args) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("address", "\u4eac\u5e02\u6d77\u6dc0\u533a\u8f6f\u4ef6\u56ed\u5317\u8857");
        contentMap.put("latitude", "40.054774");
        contentMap.put("longitude", "116.288981");
        Gson gson = new Gson();
        SystemFields systemField = SystemFields.getSystemField("longitude,latitude,address");
        CustomFieldTypeInterface fromJson = (CustomFieldTypeInterface)gson.fromJson(gson.toJson(contentMap), PositionFieldType.class);
        Map<String, Object> objKeyValue = systemField.toObjKeyValue(fromJson);
        System.out.println(objKeyValue);
        OrgUserBaseInfo orgUserBaseInfo = new OrgUserBaseInfo();
        BeanUtils.populate((Object)orgUserBaseInfo, objKeyValue);
        System.out.println(orgUserBaseInfo);
    }

    @Override
    public List<Long> saveOrUpdateCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long studentIdOrConsultId, Long orgId) {
        List<CustomFieldDto> fields = orgUserBaseInfo.getFields();
        ArrayList saveValues = Lists.newArrayList();
        for (CustomFieldDto cfd : fields) {
            log.info("[CustomField] CustomFieldDto={}", (Object)cfd);
            List<String> consultKeys = ConsultFieldEnum.getLabels();
            if (consultKeys.contains(cfd.getKey())) continue;
            CustomFieldValueRequest request = (CustomFieldValueRequest)cfd;
            String name = cfd.getKey();
            SystemFields systemField = SystemFields.getSystemField(name);
            Integer customFieldType = cfd.getType();
            Map<String, Object> contentMap = request.getValues();
            if (systemField != null) {
                log.info("[CustomField] systemFiled={}", contentMap);
                if (contentMap == null || contentMap.isEmpty()) continue;
                CustomFieldTypeInterface findCustomFieldSolver = CustomFieldTypeFactory.findCustomFieldSolver(CustomFieldType.getCustomFieldType(customFieldType));
                Gson gson = new Gson();
                CustomFieldTypeInterface fromJson = (CustomFieldTypeInterface)gson.fromJson(gson.toJson(contentMap), findCustomFieldSolver.getClass());
                Map<String, Object> objKeyValue = systemField.toObjKeyValue(fromJson);
                log.info("[CustomField] systemFiled={}", objKeyValue);
                try {
                    BeanUtils.populate((Object)orgUserBaseInfo, objKeyValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("can not re-set value to CustomFieldValueRequest cause by : {} ", (Throwable)e);
                }
                continue;
            }
            if (contentMap == null && cfd.getIsRequired().intValue() == RequireStatus.IS_REQUIRE.getStatus()) {
                log.warn("The customField value is required!");
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.REQUIRE_VALUE);
            }
            Long fieldId = Long.parseLong(cfd.getKey());
            CustomField customField = (CustomField)this.customFieldDao.getById((Serializable)fieldId, new String[]{"id", "isUsed"});
            if (customField != null) {
                if (customField.getIsUsed().intValue() == UseStatus.NOT_USED.getStatus()) {
                    customField.setUpdateTime(new Date());
                    customField.setIsUsed(Integer.valueOf(UseStatus.IS_USED.getStatus()));
                    this.customFieldDao.update((Object)customField, new String[]{"isUsed", "updateTime"});
                }
            } else {
                log.error("[CustomFiled] this customFiled is not exist, id param:{}", (Object)fieldId);
            }
            if (!GenericsUtils.notNullAndEmpty(contentMap)) continue;
            this.updateIsUsedTXCustomOPtion(contentMap, CustomFieldType.getCustomFieldType(customFieldType));
            Gson gson = new Gson();
            CustomFieldValue customFieldValuePo = cfd.buildCustomFieldValue(orgUserBaseInfo.getIsStudent(), studentIdOrConsultId, orgId);
            customFieldValuePo.setValue(gson.toJson(contentMap));
            CustomFieldValue fieldValueFromSql = this.customFieldValueDao.getCustomFieldValue(fieldId, orgUserBaseInfo.getIsStudent().booleanValue(), studentIdOrConsultId);
            log.info("customFieldValuePo param:{}, fieldValueFromSql param:{}", (Object)customFieldValuePo, (Object)fieldValueFromSql);
            if (studentIdOrConsultId == null || fieldValueFromSql == null) {
                saveValues.add(customFieldValuePo);
                continue;
            }
            fieldValueFromSql.setValue(gson.toJson(contentMap));
            fieldValueFromSql.setUpdateTime(new Date());
            this.customFieldValueDao.update((Object)fieldValueFromSql, new String[]{"value", "updateTime"});
        }
        ArrayList<Long> fieldValueIds = new ArrayList<Long>();
        this.customFieldValueDao.saveAll((List)saveValues, new String[0]);
        if (GenericsUtils.notNullAndEmpty((Object)saveValues)) {
            for (CustomFieldValue fieldValue : saveValues) {
                Long valueId = fieldValue.getId();
                fieldValueIds.add(valueId);
            }
        }
        return fieldValueIds;
    }

    public void updateIsUsedTXCustomOPtion(Map<String, Object> contentMap, CustomFieldType fieldType) {
        Integer id = null;
        switch (fieldType) {
            case SINGLE_CHOICE: {
                id = (Integer)contentMap.get("id");
                this.updateTXCustomOption(id.longValue());
                break;
            }
            case MULTI_CHOICE: {
                CustomFieldTypeInterface findCustomFieldSolver = CustomFieldTypeFactory.findCustomFieldSolver(CustomFieldType.MULTI_CHOICE);
                Gson gson = new Gson();
                String value = String.valueOf(gson.toJson(contentMap));
                MultiChoiceFieldTypeWrapper wrapper = (MultiChoiceFieldTypeWrapper)findCustomFieldSolver.jsonToObj(value);
                log.info("\u83b7\u53d6\u7684value \u4e3a param:{}, MultiChoiceFieldTypeWrapper param:{}", (Object)value, (Object)wrapper);
                if (!GenericsUtils.notNullAndEmpty((Object)wrapper)) break;
                List<MultiChoiceFieldType> multiChoiceOptions = wrapper.getOptions();
                for (MultiChoiceFieldType multiChoiceOption : multiChoiceOptions) {
                    id = multiChoiceOption.getId().intValue();
                    this.updateTXCustomOption(id.longValue());
                }
                break;
            }
        }
    }

    public void updateTXCustomOption(Long id) {
        TXCustomOption option = (TXCustomOption)this.txCustomOptionDao.getById((Serializable)id, new String[0]);
        if (option != null) {
            if (option.getIsUsed().intValue() == UseStatus.NOT_USED.getStatus()) {
                option.setIsUsed(Integer.valueOf(UseStatus.IS_USED.getStatus()));
                option.setUpdateTime(new Date());
                this.txCustomOptionDao.update((Object)option, new String[]{"isUsed", "updateTime"});
            }
        } else {
            log.error("[CustomFiled] this option is not exist, id:{}", (Object)id);
        }
    }

    @Override
    public Map<Long, CustomFieldValue> mapFieldValues(Long orgId, boolean isStudent, Long studentIdOrConsultId) {
        HashMap<Long, CustomFieldValue> customFieldValueMap = new HashMap<Long, CustomFieldValue>();
        List customFields = this.customFieldDao.getCustomFieldList(orgId, Integer.valueOf(AddType.NOT_SYSTEM.getCode()));
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)customFields)) {
            ArrayList<Long> fieldIds = new ArrayList<Long>();
            for (CustomField field : customFields) {
                fieldIds.add(field.getId());
                customFieldValueMap.put(field.getId(), null);
            }
            List values = this.customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentIdOrConsultId, fieldIds);
            for (CustomFieldValue value : values) {
                customFieldValueMap.put(value.getFieldId(), value);
            }
        }
        return customFieldValueMap;
    }

    @Override
    public void updateStudentId(Long orgId, Long consultId, Long studentId) {
        this.customFieldValueDao.updateStudentId(orgId, consultId, studentId);
    }
}

