/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl.customFields;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldRequest;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.student.enums.UseStatus;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomFieldServiceImpl
implements CustomFieldService {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldServiceImpl.class);
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;

    @Override
    public List<CustomField> initSystemField(Long orgId) {
        boolean isInit = this.customFieldDao.hasInitSystemField(orgId);
        List<CustomField> generatorCustomFields = null;
        log.info("orgId param:{}, isInit param:{}", (Object)orgId, (Object)isInit);
        if (!isInit) {
            log.info("\u5f53\u524d\u673a\u6784 :{} \u7684\u7cfb\u7edf\u5b57\u6bb5\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c, isInit param:{}", (Object)orgId, (Object)isInit);
            generatorCustomFields = SystemFields.generatorCustomSystemFields(orgId);
            this.customFieldDao.batchInsert(generatorCustomFields);
        }
        return generatorCustomFields;
    }

    @Override
    @Transactional
    public CustomFieldResponse addFieldResuest(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId) {
        this.initSystemField(orgId);
        this.saveOrUpdateFieldBefore(fieldRequest, orgId, optionDtoList);
        CustomField customField = FieldRequest.getCustomField(fieldRequest);
        customField.setOrgId(orgId);
        this.customFieldDao.save((Object)customField, new String[0]);
        Long id = customField.getId();
        customField.setName(id + "");
        customField.setUpdateTime(new Date());
        this.customFieldDao.update((Object)customField, new String[]{"name", "updateTime"});
        ArrayList<OptionDto> optionList = new ArrayList<OptionDto>();
        List<Integer> choiceTypes = CustomFieldType.getChoiceType();
        if (choiceTypes.contains(fieldRequest.getType())) {
            List<TXCustomOption> txCustomOptions = this.saveOrUpdateChoiceFields(optionDtoList, id);
            for (TXCustomOption txCustomOption : txCustomOptions) {
                OptionDto dto = this.customOptionPoToDto(txCustomOption);
                optionList.add(dto);
            }
        }
        CustomFieldResponse response = CustomFieldResponse.getInstanceByCustomField(customField, optionList);
        log.info("[CustomField] response:{}", (Object)response);
        return response;
    }

    @Override
    @Transactional
    public void modCustomField(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId) {
        this.saveOrUpdateFieldBefore(fieldRequest, orgId, optionDtoList);
        CustomField customFieldPo = FieldRequest.getCustomField(fieldRequest);
        customFieldPo.setUpdateTime(new Date());
        this.customFieldDao.update((Object)customFieldPo, new String[0]);
        Long parentId = customFieldPo.getId();
        if (GenericsUtils.notNullAndEmpty(optionDtoList)) {
            this.saveOrUpdateChoiceFields(optionDtoList, parentId);
        }
    }

    @Override
    public List<CustomFieldResponse> getCustomFieldList(Long orgId) {
        this.initSystemField(orgId);
        List customFields = this.customFieldDao.getCustomFieldList(orgId, null);
        if (customFields == null || customFields.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<CustomFieldResponse> responseList = new ArrayList<CustomFieldResponse>();
        for (CustomField customFiled : customFields) {
            Long parentId;
            List customOptionList;
            ArrayList<OptionDto> optionList = new ArrayList<OptionDto>();
            List<Integer> choiceTypes = CustomFieldType.getChoiceType();
            if (choiceTypes.contains(customFiled.getType()) && (customOptionList = this.txCustomOptionDao.getTXCustomOptionList(parentId = customFiled.getId())) != null && customOptionList.size() > 0) {
                ArrayList<OptionDto> pauseOptions = new ArrayList<OptionDto>();
                for (TXCustomOption customOption : customOptionList) {
                    OptionDto optionDto = this.customOptionPoToDto(customOption);
                    if (customOption.getIsPaused().intValue() == PauseStatus.PAUSE.getStatus()) {
                        pauseOptions.add(optionDto);
                        continue;
                    }
                    optionList.add(optionDto);
                }
                optionList.addAll(pauseOptions);
            }
            CustomFieldResponse response = CustomFieldResponse.getInstanceByCustomField(customFiled, optionList);
            responseList.add(response);
        }
        return responseList;
    }

    @Override
    @Transactional
    public void updateCustomFieldByIsPaused(Long id, Integer isPaused, Long orgId) {
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, id);
        if (customField != null) {
            if (customField.getSystemFieldNum() > -1) {
                log.warn("The customField is system field!");
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_FIELD);
            }
            if (customField.getIsPaused() != isPaused) {
                customField.setIsPaused(isPaused);
                customField.setUpdateTime(new Date());
                this.customFieldDao.update((Object)customField, new String[]{"isPaused", "updateTime"});
            }
        } else {
            log.warn("The customField is not exist!");
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
        }
    }

    @Override
    public void deleteCustomField(Long id, Long orgId) {
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, id);
        if (customField != null) {
            if (customField.getSystemFieldNum() > -1) {
                log.warn("The customField is system field!");
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_FIELD);
            }
            Integer isUsed = customField.getIsUsed();
            if (isUsed.intValue() == UseStatus.IS_USED.getStatus()) {
                log.warn("The customField is used, the id is param:{}", (Object)customField.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CUSTOM_FIELD_NOT_DELETE);
            }
            Integer type = customField.getType();
            List<Integer> choiceTypes = CustomFieldType.getChoiceType();
            if (choiceTypes.contains(type)) {
                this.txCustomOptionDao.deleteOptionsByParentId(id);
            }
        } else {
            log.warn("The customfield is not exist");
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
        }
        this.customFieldDao.delById((Serializable)id);
    }

    private Boolean checkoutFieldLabelDouble(List<CustomField> customFields, FieldRequest fieldRequest) {
        Boolean isDouble = false;
        String label = fieldRequest.getLabel();
        Long id = fieldRequest.getId();
        log.info("[CustomField] id:{}", (Object)id);
        ArrayList<String> labels = new ArrayList<String>();
        for (CustomField customField : customFields) {
            String label1 = customField.getLabel();
            if (id != null && id.equals(customField.getId()) && label.equals(label1)) {
                return false;
            }
            labels.add(label1);
        }
        if (labels.contains(label)) {
            isDouble = true;
        }
        return isDouble;
    }

    private String checkoutChoiceRepeat(List<OptionDto> optionDtoList) {
        HashMap<String, Integer> choiceCountMap = new HashMap<String, Integer>();
        for (OptionDto optionDto : optionDtoList) {
            if (optionDto.getIsDel() == DeleteStatus.DELETED.getValue()) continue;
            String label = optionDto.getLabel();
            if (StringUtils.isNotBlank((CharSequence)label)) {
                if (label.length() > 10) {
                    throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_CHOICE_LABEL_LENGTH);
                }
            } else {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CHOICE_LABEL_NULL);
            }
            if (choiceCountMap.get(label) == null) {
                choiceCountMap.put(label, 1);
                continue;
            }
            choiceCountMap.put(label, (Integer)choiceCountMap.get(label) + 1);
        }
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry entry : choiceCountMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            sb.append((String)entry.getKey()).append(",");
        }
        if (GenericsUtils.notNullAndEmpty((Object)sb.toString().trim())) {
            sb.deleteCharAt(sb.length() - 1);
            sb.insert(0, "\u3010");
            sb.insert(sb.length(), "\u3011");
            sb.append("\u9009\u9879\u5df2\u7ecf\u5b58\u5728");
        }
        return sb.toString();
    }

    private OptionDto customOptionPoToDto(TXCustomOption po) {
        OptionDto dto = new OptionDto();
        BeanUtils.copyProperties((Object)po, (Object)dto);
        return dto;
    }

    private void saveOrUpdateFieldBefore(FieldRequest fieldRequest, Long orgId, List<OptionDto> optionDtoList) {
        Boolean isDouble;
        if (fieldRequest.getId() != null) {
            CustomField customField = this.customFieldDao.getCustomFieldById(orgId, fieldRequest.getId());
            if (customField == null) {
                log.warn("The customfield is not exist, fieldId param:{}", (Object)fieldRequest.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
            }
            if (customField.getSystemFieldNum() > -1) {
                log.warn("The customField is system field!");
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.SYSTEM_FIELD);
            }
            if (customField.getType() != fieldRequest.getType()) {
                log.warn("The customfield is exist, type cannot change, fieldId param:{}", (Object)fieldRequest.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CUSTOM_FIELD_TYPE_CHANGE);
            }
        } else {
            List customFields = this.customFieldDao.getCustomFieldList(orgId, Integer.valueOf(AddType.NOT_SYSTEM.getCode()));
            if (customFields != null && customFields.size() >= 20) {
                log.warn("The number of customfield is number more than 20, fieldId param:{}", (Object)fieldRequest.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_CUSTOM_FIELD_NUMBER);
            }
        }
        if (StringUtils.isBlank((CharSequence)fieldRequest.getLabel())) {
            log.warn("The label is null");
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.LABEL_NULL);
        }
        if (fieldRequest.getLabel().length() > 15) {
            log.warn("The label's length is more 15, fieldId param:{}", (Object)fieldRequest.getId());
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_LABEL_LENGTH);
        }
        List customFieldAll = this.customFieldDao.getCustomFieldList(orgId, null);
        if (customFieldAll != null && (isDouble = this.checkoutFieldLabelDouble(customFieldAll, fieldRequest)).booleanValue()) {
            log.warn("The label is repeat, fieldId param:{}", (Object)fieldRequest.getId());
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.LABEL_REPEAT);
        }
        List<Integer> choiceTypes = CustomFieldType.getChoiceType();
        if (choiceTypes.contains(fieldRequest.getType())) {
            if (optionDtoList == null || optionDtoList.size() == 0) {
                log.warn("The number of option is 0, fieldId param:{}", (Object)fieldRequest.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MIN_CHOICE_NUMBER);
            }
            int normalOptionCount = 0;
            for (OptionDto optionDto : optionDtoList) {
                if (optionDto.getIsDel() != DeleteStatus.NORMAL.getValue()) continue;
                ++normalOptionCount;
            }
            if (normalOptionCount > 8) {
                log.warn("The number of option is more 8, fieldId param:{}", (Object)fieldRequest.getId());
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_CHOICE_NUMBER);
            }
            String repeatChoices = this.checkoutChoiceRepeat(optionDtoList);
            if (GenericsUtils.notNullAndEmpty((Object)repeatChoices)) {
                log.warn("The option label is repeat, fieldId param:{}", (Object)fieldRequest.getId());
                BussinessException repeateChoiceException = new BussinessException((UniverseErrorCode)StudentErrorCode.CHOICE_REPEAT, repeatChoices);
                throw repeateChoiceException;
            }
        }
    }

    private List<TXCustomOption> saveOrUpdateChoiceFields(List<OptionDto> optionDtoList, Long parentId) {
        ArrayList<Long> delIds = new ArrayList<Long>();
        ArrayList<TXCustomOption> newCustomOption = new ArrayList<TXCustomOption>();
        for (OptionDto optionDto : optionDtoList) {
            TXCustomOption customOption = OptionDto.buildTXCustomOption(optionDto);
            Long id = optionDto.getId();
            Integer isDel = optionDto.getIsDel();
            if (id != null) {
                if (isDel.intValue() == DeleteStatus.DELETED.getValue()) {
                    delIds.add(id);
                    continue;
                }
                customOption.setUpdateTime(new Date());
                this.txCustomOptionDao.update((Object)customOption, new String[0]);
                continue;
            }
            customOption.setParentId(parentId);
            newCustomOption.add(customOption);
        }
        if (GenericsUtils.notNullAndEmpty(delIds)) {
            this.batchDeleteChoiceFields(delIds);
        }
        if (GenericsUtils.notNullAndEmpty(newCustomOption)) {
            this.txCustomOptionDao.saveAll(newCustomOption, new String[0]);
        }
        return newCustomOption;
    }

    private void batchDeleteChoiceFields(List<Long> delIds) {
        List customOptionList = this.txCustomOptionDao.getByIds(delIds, new String[0]);
        if (customOptionList != null && customOptionList.size() > 0) {
            StringBuffer sb = new StringBuffer("");
            for (TXCustomOption customChoiceField : customOptionList) {
                if (customChoiceField.getIsUsed() != 1) continue;
                sb.append(customChoiceField.getLabel() + ",");
            }
            if (GenericsUtils.notNullAndEmpty((Object)sb.toString().trim())) {
                sb.deleteCharAt(sb.length() - 1);
                sb.insert(0, "\u3010");
                sb.insert(sb.length(), "\u3011");
                sb.append("\u9009\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u60a8\u53ef\u9009\u62e9\u505c\u7528");
                BussinessException deleteChoiceException = new BussinessException((UniverseErrorCode)StudentErrorCode.CHOICE_NOT_DELETE, sb.toString());
                throw deleteChoiceException;
            }
        }
        this.txCustomOptionDao.batchDeleteOptions(delIds);
    }

    @Override
    public void modCustomFieldsSorted(List<FieldRequest> fieldRequestList) {
        if (GenericsUtils.isNullOrEmpty(fieldRequestList)) {
            return;
        }
        for (FieldRequest request : fieldRequestList) {
            CustomField customField = FieldRequest.getCustomField(request);
            customField.setUpdateTime(new Date());
            this.customFieldDao.update((Object)customField, new String[]{"sorted", "sectionId", "updateTime"});
        }
    }
}

