/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentCourseServiceImpl
implements OrgStudentCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentCourseServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List<StudentCourseInfoReponseDto> list = this.getCourseInfoes(orgStudent, account.getNumber().longValue());
        ArrayList result = Lists.newArrayList();
        for (StudentCourseInfoReponseDto dto : list) {
            if (dto.getLeftClassTimes() == 0 && dto.getTotalClassTimes() == 0) {
                result.add(dto);
                continue;
            }
            if (dto.getLeftClassTimes() <= 0 || dto.getTotalClassTimes() <= 0) continue;
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List<StudentCourseInfoReponseDto> list = this.getCourseInfoes(orgStudent, account.getNumber().longValue());
        ArrayList result = Lists.newArrayList();
        for (StudentCourseInfoReponseDto dto : list) {
            if (dto.getLeftClassTimes() != 0 || dto.getTotalClassTimes() <= 0) continue;
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentCommenRequestDto.getStudentId(), new String[0]);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue() || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
        }
        return this.getStudentSignupInfos(orgStudent, account.getNumber().longValue());
    }

    @Override
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> result = this.getCourseInfoes(po, orgNumber);
        return result != null && !result.isEmpty() ? result.size() : 0;
    }

    private List<StudentCourseInfoReponseDto> getCourseInfoes(OrgStudent po, Long orgNumber) {
        StudentCourseInfoReponseDto dto;
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (Object orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        Map lessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, null, po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map finishLessonTimeMap = this.orgClassLessonDao.getLessonTimemap((Collection)courseIds, new Date(), po.getOrgId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        for (OrgSignupCourse purchase : sinupCourses) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseNumber((long)purchase.getOrgCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
            if (lessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        for (OrgSignupCourse purchase : mPurchase) {
            dto = new StudentCourseInfoReponseDto();
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            if (lessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setTotalClassTimes((Integer)lessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setFinishClassTimes((Integer)finishLessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        log.debug("course list={}", (Object)courseDtos);
        return courseDtos;
    }

    private List<OrgStudentPurchaseReponseDto> getStudentSignupInfos(OrgStudent po, Long orgNumber) {
        ArrayList courseDtos = Lists.newArrayList();
        List cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, Integer.valueOf(PayStatus.SUCESS.getCode()), new String[]{"totalPrices", "signupPurchaseId"});
        List mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), Long.valueOf(0L), Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(PayStatus.SUCESS.getCode()), new String[0]);
        HashSet courseIds = Sets.newHashSet();
        HashSet purchaseIds = Sets.newHashSet();
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map nameMap = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        if (CollectionUtils.isNotEmpty((Collection)purchaseIds)) {
            List sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
            for (OrgSignupCourse purchase : sinupCourses) {
                OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
                dto.setCourseNumber((long)purchase.getOrgCourseNumber());
                dto.setCourseName((String)nameMap.get(purchase.getOrgCourseId()));
                dto.setPayMoney(purchase.getPayPrice().doubleValue() / 100.0);
                courseDtos.add(dto);
            }
        }
        for (CoursePurchase purchase : mPurchase) {
            OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
            dto.setCourseNumber((long)purchase.getCourseNumber());
            dto.setCourseName((String)nameMap.get(purchase.getCourseId()));
            dto.setPayMoney((double)purchase.getPayMoney());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }
}

