package com.baijia.tianxiao.sal.student.pc.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.TXCampusAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wangsixia
 * @version 1.0
 * @title StudentUserServiceImpl
 * @desc 学员档案
 * @date 2016年3月17日
 */
@Service
@Slf4j
public class StudentUserServiceImpl implements StudentUserService {

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired(required = false)
    private CrmStudentQuery query;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private TXCampusAccountService txCampusAccountService;

    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Autowired
    private OrgCourseDao orgCourseDao;
    
    @Autowired
    private CrmStudentQuery crmStudentQuery;

    @Override
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(CrmErrorCode.ORG_NOT_EXIST);
        }
        OrgStudent orgStudent = this.orgStudentDao.getById(studentId);
        if (null == orgStudent || orgStudent.getDelStatus() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        StudentInfoResponseDto baseInfoDto = new StudentInfoResponseDto();
        this.studentPo2Dto(orgStudent, baseInfoDto);
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile(baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile(baseInfoDto.getParentMobile()));
        }

        log.info("getBaseInfo---------baseInfoDto={}", baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        this.doSaveBefore(orgId, studentInfo);

        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
        Long userId = userInfoMap.get("id");

        OrgStudent orgStudent = new OrgStudent();
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        orgStudent.setAddCascadeId(cascadeId == null ? 0 : cascadeId);
        this.orgStudentDao.save(orgStudent, false);
        log.info("addStudentInfo---------orgStudent={}", orgStudent);
        
        //更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat)
        throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", orgId, studentInfo, updateRepeat);
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent =
                this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal(orgStudent);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save(orgStudent, false);
        }
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        if (StringUtils.isNotBlank(studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            List<TxStudentTag> tagList = new ArrayList<>();
            for (String tagStr : tags) {
                if (StringUtils.isNotBlank("tagStr")) {
                    TxStudentTag tag = new TxStudentTag();
                    tag.setOrgId(orgStudent.getOrgId());
                    tag.setUserId(orgStudent.getUserId());
                    tag.setContent(tagStr);
                    tagList.add(tag);
                }
            }
            this.txStudentTagDao.saveAll(tagList, "consultUserId", "userId", "orgId", "content");
        }
        
        
        //更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo || null == studentInfo.getId()
            || studentInfo.getId() <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgStudent orgStudent = this.orgStudentDao.getById(studentInfo.getId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
        }

        this.doSaveBefore(orgId, studentInfo);

        this.checkAndCreateComment(studentInfo, orgStudent);

        this.cascadeUpdateTxConsulter(orgId, orgStudent, studentInfo);

        if (studentInfo.getMobile().contains("****")) {
            studentInfo.setMobile(orgStudent.getMobile());
        }
        if (studentInfo.getParentMobile().contains("****")) {
            studentInfo.setParentMobile(orgStudent.getParentMobile());
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, null);
        this.orgStudentDao.update(orgStudent, false);
        log.info("editStudentInfo---------orgStudent={}", orgStudent);
        
        //更新solr
        updateSolr(orgStudent);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void BatchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        List<OrgStudent> list = this.orgStudentDao.getStudentByIds(orgId, studentIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for (OrgStudent orgStudent : list) {
                if (orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                    List<TxConsultUser> consultUserList = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
                    log.info("delStudent--------consultUserList={}", consultUserList);

                    if (null != consultUserList && !consultUserList.isEmpty()) {
                        this.delSysBacklog(orgId, orgStudent, consultUserList.get(0));

                        for (TxConsultUser consulterUser : consultUserList) {
                            consulterUser.setStudentId(0L);
                            this.txConsultUserDao.update(consulterUser, "studentId");
                        }
                    } else {
                        this.delSysBacklog(orgId, orgStudent, null);
                    }

                    orgStudent.setDelStatus(DeleteStatus.DELETED.getValue());
                    TxStudentComment comment = new TxStudentComment();
                    comment.setContent("机构删除学员");
                    comment.setUserId(orgStudent.getUserId());
                    comment.setOrgId(orgStudent.getOrgId());
                    comment.setIsSystem(AddType.SYSTEM.getCode());
                    this.txStudentCommentDao.save(comment);
                    this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
                    this.orgStudentDao.update(orgStudent, "delStatus");
                    
                    //更新solr
                    updateSolr(orgStudent);
                }
            }
        }
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoResponseDto dto)
        throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(dto, po);
        log.info("StudentPo2Dto---------po={},dto={}", ToStringBuilder.reflectionToString(po), dto);
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }

        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }

        if (dto.getGender() == null || dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(po.getGender() == 1 ? "女" : "男");
        }
        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));

        if (null != po.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }
    }

    private void studentDto2Po(StudentListResponseDto dto, OrgStudent po, Long orgId, Long userId)
        throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(po, dto);
        log.info("studentDto2Po---------dto={},po:{}", dto, ToStringBuilder.reflectionToString(po));

        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }

        if (null == po.getId() || 0 == po.getId()) {
            // 新增
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
            po.setUserId(userId);
        }

        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    private void doSaveBefore(Long orgId, StudentListResponseDto studentInfo) {
        OrgStudent student = null;
        if (studentInfo.getId() != null && studentInfo.getId() > 0) {
            student = this.orgStudentDao.getById(studentInfo.getId());
            if (student != null && student.getOrgId() == orgId.longValue()
                && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                String mobile = student.getMobile();
                String name = student.getName();
                log.debug("mobile={},stMobile={},name={},stuName={}", mobile, studentInfo.getMobile(), name,
                    studentInfo.getName());
                if (mobile.equals(studentInfo.getMobile()) && studentInfo.getName().equals(name)) {
                    return;
                } else {
                    procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
                }
            } else {
                throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
            }
        } else {
            procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
        }
    }

    /**
     * 处理学员手机号、姓名相同的情况
     *
     * @param orgId
     * @param mobile
     * @param name
     */
    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException(CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    /**
     * 学员档案分页查询、排序、搜索
     */
    @Override
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId, Integer cascadeId,
        CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentListRequestDto={},orgId={},pagedto={},solrStudnets = {}", studentListRequestDto, orgId,
            pageDto, solrStudents == null ? 0 : solrStudents.size());
        if (solrStudents.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        final List<Long> userIds = new ArrayList<>(pageDto.getPageSize());
        Map<Long, StudentDto> studentDtoMap = CollectorUtil.collectMap(solrStudents, new Function<StudentDto, Long>() {
            @Override
            public Long apply(StudentDto studentDto) {
                userIds.add(studentDto.getUserId());
                return studentDto.getStudentId();
            }
        });
        Map<Long, String> searchTeacherNames = searchTeacherNames(new HashSet<>(userIds), orgId, cascadeId);

        log.info("headTeacherNames {} ", searchTeacherNames);

        List<OrgStudent> students = this.orgStudentDao.getByIds(studentDtoMap.keySet());

        // 是否显示手机号
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());

        List<TxStudentTag> studentTags = txStudentTagDao.getTags(userIds, orgId, StudentType.ORG_STUDENTS.getCode());
        Map<Long, List<TxStudentTag>> tagMap = new HashMap<>();
        if (studentTags != null && studentTags.size() > 0) {
            for (TxStudentTag tag : studentTags) {
                List<TxStudentTag> tagList = tagMap.get(tag.getUserId());
                if (tagList == null) {
                    tagList = new ArrayList<>();
                    tagMap.put(tag.getUserId(), tagList);
                }
                tagList.add(tag);
            }
        }
        
        List<StudentListResponseDto> result = Lists.newArrayList();
        for (OrgStudent student : students) {
            List<TxStudentTag> tags = tagMap.get(student.getUserId());
            StudentListResponseDto dto = StudentListResponseDto.convertToDto(student, tags);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            StudentDto studentDto = studentDtoMap.get(student.getId());
            String className = studentDto.getClassName();
            dto.setHasLesson(GenericsUtils.isNullOrEmpty(className) ? "否" : "是");
            dto.setCascadeIdStr(searchTeacherNames.get(student.getUserId()));
            dto.setLessonNum(studentDto.getFinishClassHour() + "/"
                + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
            result.add(dto);
        }
        return result;
    }

    /**
     * @param keySet
     * @param orgId
     * @param cascadeId
     * @return
     */
    private Map<Long, String> searchTeacherNames(Set<Long> userIds, Long orgId, Integer cascadeId) {

        boolean isStaffAccount = false;
        if (cascadeId != null) {
            boolean hasPermission = this.txAccountPermissionService.hasPermission(cascadeId.longValue(),
                ApplicationType.PC, TXPermissionConst.CHAKAN_SUOYOU_XUEYUAN);
            if (!hasPermission) {
                isStaffAccount = true;
            }
        }
        
        log.info("isStaffAccount : {} , cascadeId : {} , orgId : {} ", isStaffAccount, cascadeId, orgId);
        
        Map<Long, String> byTxCasCadeIds = Maps.newHashMap();
        //如果当前用户为子账号，说明只能看属于自己的班级
        if(isStaffAccount){
                TxCascadeCredentialDto byTxCasCade = this.txCascadeCredentialService.getByTxCasCade(orgId, cascadeId);
                if(byTxCasCade != null){
                    byTxCasCadeIds.put(cascadeId.longValue(), byTxCasCade.getName());
                }
        }else{
            byTxCasCadeIds.putAll(this.txCascadeCredentialService.getByTxCasCadeIds(orgId));
        }

        Map<Long, String> headTeacherNameMap = Maps.newHashMap();
        Map<Long, List<Long>> orgStudentCourseIds = this.orgStudentCourseDao.getOrgCourseIdMap(orgId, userIds);
        Set<Long> courseIdSet = Sets.newHashSet();
        for (List<Long> courses : orgStudentCourseIds.values()) {
            courseIdSet.addAll(courses);
        }

        List<OrgCourse> allCourse = this.orgCourseDao.getByIds(courseIdSet, "id", "cascadeId");
        
        Map<Long, String> courseCascadeNameMap = Maps.newHashMap();
        for (OrgCourse orgCourse : allCourse) {
            Long courseId = orgCourse.getId();
            Integer courseCascadeId = orgCourse.getCascadeId();
            String headTeacherName = byTxCasCadeIds.get(courseCascadeId.longValue());
            if(GenericsUtils.notNullAndEmpty(headTeacherName)){
                courseCascadeNameMap.put(courseId, headTeacherName);
            }
        }
        
        for (Long userId : userIds) {
            List<Long> courseIds = orgStudentCourseIds.get(userId);
            if(GenericsUtils.isNullOrEmpty(courseIds)){
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (Long courseId : courseIds) {
                String headTeacherName = courseCascadeNameMap.get(courseId);
                if(GenericsUtils.notNullAndEmpty(headTeacherName)){
                    sb.append(headTeacherName).append("、");
                }
            }
            String headTeacherNames = GenericsUtils.deleteLastCharToString(sb);
            headTeacherNameMap.put(userId, headTeacherNames);
        }
        return headTeacherNameMap;
    }

    /**
     * 添加系统待办事项(正式学员)
     *
     * <<<<<<< HEAD
     * 
     * @param orgId 机构id
     * @param orgId 机构id =======
     * @param orgId 机构id >>>>>>> yingxiao_1_6
     * @param consultUserId 线索id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("addSysBacklog---------orgId={}, student={}, consultUserId={}", orgId, student, consultUserId);
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
            && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(studentId, orgId, false, "id");
            if (CollectionUtils.isNotEmpty(list)) {
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "已存在未过期的学员档案系统待办事项");
            }
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            txBacklog.setContent("跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            if (null != consultUserId && consultUserId > 0) {
                txBacklog.setConsultUserId(consultUserId);
            }
            this.txBacklogDao.save(txBacklog, false);
            log.info("addSysBacklog--------txBacklog={}", txBacklog);
        }
    }

    /**
     * 更新系统待办事项:编辑正式学员
     * <p/>
     * <<<<<<< HEAD
     *
     * <<<<<<< HEAD
     * 
     * @param orgId 机构id ======= <<<<<<< HEAD <<<<<<< HEAD
     * @param orgId 机构id =======
     * @param orgId 机构id >>>>>>> a9ef5790d09369978d27d492ee8c236e0a9057de =======
     * @param orgId 机构id >>>>>>> yingxiao_1_6 =======
     * @param orgId 机构id <<<<<<< HEAD >>>>>>> dev ======= >>>>>>> refs/remotes/origin/caoliang >>>>>>> dev <<<<<<< HEAD
     *            ======= >>>>>>> push_lxp >>>>>>> yingxiao_1_6
     * @param studentId 正式学员id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSysBacklog(Long orgId, Long studentId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("updateSysBacklog---------orgId={}, student={}", orgId, student);

        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
            && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, false);
            if (CollectionUtils.isNotEmpty(list)) {
                TxBacklog txBacklog = list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    // 正式学员下次跟进时间改变
                    txBacklog.setContent(
                        "跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update(txBacklog, false);
                }
            } else {
                // 系统待办事项已过期需要新建，若同时还是咨询学员，则在此处添加consulterId
                Long consulterId = null;
                List<TxConsultUser> consultUserList =
                    this.txConsultUserDao.lookByStudentId(orgId, student.getId(), "id");
                if (CollectionUtils.isNotEmpty(consultUserList)) {
                    consulterId = consultUserList.get(0).getId();
                }
                this.addSysBacklog(orgId, student.getId(), consulterId);
            }
        }
    }

    /**
     * 删除系统待办事项: 若同时还是咨询学员，则重置studentId为0; 若仅是正式学员，则直接删除
     *
     * @param orgId 机构id
     * @param consulterUser 咨询学员
     * @return
     */
    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        log.info("delSysBacklog-------orgId={},student={},consulterUser={}", orgId, student, consulterUser);
        List<TxBacklog> list = null;
        if (null != consulterUser) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog && txBacklog.getStudentId().longValue() == student.getId().longValue()) {
                        txBacklog.setStudentId(0l);
                        if (!txBacklog.getEndTime().before(new Date())) {
                            // 未过期系统待办事项才作同步
                            txBacklog.setContent("跟进客户: "
                                + (StringUtils.isNotBlank(consulterUser.getName()) ? consulterUser.getName() : "匿名学生"));
                            txBacklog.setEndTime(consulterUser.getNextRemindTime());
                            txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                        }
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog) {
                        txBacklog.setStudentId(0l);
                        txBacklog.setDelStatus(BizConf.TRUE.intValue());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        }
    }

    /**
     * 机构修改了手机号码和姓名都会生成一条跟进记录
     *
     * @param dto
     * @param po
     */
    private void checkAndCreateComment(StudentListResponseDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();

        String destName = dto.getName();
        String destMobile = dto.getMobile();

        List<TxStudentComment> comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate("yyyy-MM-dd HH:mm", 0, Calendar.DAY_OF_MONTH);
        if (!destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将姓名【").append(sourceName).append("】").append("修改为【").append(destName)
                .append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!destMobile.equals(sourceMobile)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将手机号【").append(sourceMobile).append("】").append("修改为【")
                .append(destMobile).append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll(comments);
        }
    }

    /**
     * 生成跟进记录
     *
     * @param orgId
     * @param content
     * @param userId
     * @return
     */
    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(orgId);
        comment.setOrigin(0);
        comment.setUserId(userId);
        return comment;
    }

    /**
     * 学员名字与招生线索同步
     *
     * @param orgId
     * @param orgStudent
     * @param studentInfo
     * @return
     */
    private void cascadeUpdateTxConsulter(long orgId, OrgStudent orgStudent, StudentListResponseDto studentInfo) {
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if (updateName || updateMobile) {
            List<TxConsultUser> consultUsers = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
            if (consultUsers != null && !consultUsers.isEmpty()) {
                for (TxConsultUser consultUser : consultUsers) {
                    consultUser.setName(updateName ? studentInfo.getName() : null);
                    consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                    consultUser.setUpdateTime(new Date());
                    txConsultUserDao.update(consultUser, false);
                }
            }
        }
    }

    
    void updateSolr(OrgStudent orgStudent) {
    	if(orgStudent == null){
    		return;
    	}
        try {
            crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", orgStudent);
        } catch (Exception e) {
            log.error("solr - student - update - exception", e);
        }
    }
}
