/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.impl.customFields;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeFactory;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.FieldTypeContentFactory;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.MultiChoiceFieldType;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.MultiChoiceFieldTypeWrapper;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.PositionFieldType;
import com.baijia.tianxiao.sal.student.enums.ConsultFieldEnum;
import com.baijia.tianxiao.sal.student.enums.CustomFieldSections;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.student.enums.UseStatus;
import com.baijia.tianxiao.sal.student.util.SystemFieldOptionFactory;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月29日
 * @desc
 */
@Service
@Slf4j
public class CustomFieldValuesServiceImpl implements CustomFieldValueService {
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;

    @Override
    public void setCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent,
        Long studentIdOrConsultId) {
        this.setCustomFieldValues(orgUserBaseInfo, orgId, isStudent, studentIdOrConsultId, false);
    }

    /**
     * 根据是否只设置系统字段的属性值
     */
    @Override
    public void setCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent,
        Long studentIdOrConsultId, boolean systemOnly) {
        // 初始化section区信息（1）
        orgUserBaseInfo.setSections(CustomFieldSections.listAllSections());

        // 设置基本字段值，并返回到orgUserBaseInfo对象中
        List<CustomField> customFieldConfigs = this.customFieldDao.getCustomFieldListWithCondition(orgId, false);
        if (GenericsUtils.isNullOrEmpty(customFieldConfigs)) {
            customFieldService.initSystemField(orgId);
            customFieldConfigs = customFieldDao.getCustomFieldListWithCondition(orgId, false);
        }

        List<CustomField> systemFields = Lists.newArrayList();
        List<CustomField> otherFields = Lists.newArrayList();
        for (CustomField customField : customFieldConfigs) {
            if (customField.getSystemFieldNum() != -1) {
                systemFields.add(customField);
            } else {
                otherFields.add(customField);
            }
        }
        setSystemFields(orgUserBaseInfo, systemFields);
        log.info("need set other fields :{}", !systemOnly);
        if (!systemOnly && GenericsUtils.notNullAndEmpty(otherFields)) {
            setOtherFields(orgUserBaseInfo, orgId, isStudent, studentIdOrConsultId, otherFields);
        }

    }

    public static final String VALUE_KEY = "VALUE_KEY";

    /**
     * 设置非系统字段值
     * 
     * @param otherFields
     */
    private void setOtherFields(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent,
        Long studentIdOrConsultId, List<CustomField> otherFields) {
        List<Long> fieldIds = new ArrayList<>();
        for (CustomField customField : otherFields) {
            fieldIds.add(customField.getId());
        }
        log.info("fieldIds param:{}", fieldIds);
        log.info("orgId {}, isStudent {}, studentIdOrConsultId {}, fieldIds {}", orgId, isStudent, studentIdOrConsultId,
            fieldIds);
        List<CustomFieldValue> values =
            this.customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentIdOrConsultId, fieldIds);
        Map<Long, CustomFieldValue> customFieldValueMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(values)) {
            for (CustomFieldValue value : values) {
                customFieldValueMap.put(value.getFieldId(), value);
            }
        }

        for (CustomField customField : otherFields) {
            // 这里选项将id以及label一起存储起来
            CustomFieldValue fieldValue = customFieldValueMap.get(customField.getId());
            log.info("CustomFieldValue getInfo fieldValue param:{}", fieldValue);
            CustomFieldDto dto = new CustomFieldDto();
            if (fieldValue != null) {
                Map<String, Object> map = Maps.<String, Object> newHashMap();
                map.put(VALUE_KEY, fieldValue.getValue());
                dto = this.createCustomFieldDto(customField, map, false, null);
            } else {
                // 需要将默认值返回给，
                Object defaultValueObject = null;
                // 只有在新建的时候才会给默认值
                if (studentIdOrConsultId == -1) {
                    List<TXCustomOption> options =
                        txCustomOptionDao.getTXCustomOptionListWithCondition(customField.getId(), false, 1);
                    defaultValueObject = FieldTypeContentFactory.getContent(customField, options);
                }
                dto = this.createCustomFieldDto(customField, null, false, defaultValueObject);
            }
            orgUserBaseInfo.getFields().add(dto);
        }
    }

    /**
     * 设置系统字段值
     * 
     * @param systemFields
     */
    private void setSystemFields(OrgUserBaseInfo orgUserBaseInfo, List<CustomField> systemFields) {
        if (GenericsUtils.isNullOrEmpty(systemFields)) {
            log.info("can not find any system fields");
            return;
        }
        Map<List<String>, CustomField> nameFieldMap =
            CollectionUtils.extractMap(systemFields, new Extracter<List<String>, CustomField>() {
                @Override
                public List<String> extract(CustomField paramE) {
                    String name = paramE.getName();
                    return Arrays.asList(name.split(","));
                }
            });
        try {
            Map<String, Object> propertyValues = Maps.newHashMap();
            BeanInfo beanInfo = Introspector.getBeanInfo(OrgUserBaseInfo.class);
            PropertyDescriptor[] proDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : proDescriptors) {
                String name = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                if (method != null) {
                    Object invoke = method.invoke(orgUserBaseInfo, new Object[] {});
                    propertyValues.put(name, invoke);
                }
            }

            for (Map.Entry<List<String>, CustomField> entry : nameFieldMap.entrySet()) {
                List<String> keys = entry.getKey();
                CustomField field = entry.getValue();
                Map<String, Object> values = new HashMap<>();
                for (String key : keys) {
                    values.put(key, propertyValues.get(key));
                }
                CustomFieldValueResponse cfd = this.createCustomFieldDto(field, values, true, null);
                orgUserBaseInfo.getFields().add(cfd);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("error while setSystemFields cause by : {} ", e);
        }
    }

    private CustomFieldValueResponse createCustomFieldDto(CustomField customField, Map<String, Object> valueMap,
        boolean isSystem, Object defaultValue) {
        CustomFieldValueResponse cfd = new CustomFieldValueResponse();
        cfd.setIsRequired(customField.getIsRequired());
        if (isSystem) {
            cfd.setKey(customField.getName());
        } else {
            cfd.setKey(String.valueOf(customField.getId()));
        }
        cfd.setLabel(customField.getLabel());
        cfd.setSorted(customField.getSorted());
        Integer fieldType = customField.getType();
        CustomFieldType fieldTypeEnum = CustomFieldType.getCustomFieldType(fieldType);
        // 系统字段defaultValue为null, 非系统字段defaultValue为相应字段的默认值对象，只有在新建的时候才会给默认值
        Object jsonValue = defaultValue;
        if (isSystem) {
            SystemFields systemField = SystemFields.getSystemField(customField.getName());
            jsonValue = systemField.instance(valueMap);
            cfd.setOptions(SystemFieldOptionFactory.getOptions(systemField));
        } else if (!isSystem && valueMap != null) {
            CustomFieldTypeInterface<Object> findCustomFieldSolver =
                CustomFieldTypeFactory.findCustomFieldSolver(fieldTypeEnum);
            String value = String.valueOf(valueMap.get(VALUE_KEY));
            if (StringUtils.isNotBlank(value)) {
                jsonValue = findCustomFieldSolver.jsonToObj(value);
            }
        }

        cfd.setValues(jsonValue);

        // 此时，这种情况的出现只有自定义字段
        if (CustomFieldType.getChoiceType().contains(fieldTypeEnum.getType())) {
            List<FieldOption> options = retrievalOptions(customField, cfd);
            cfd.setOptions(options);
        }
        cfd.setSectionId(customField.getSectionId());
        cfd.setType(fieldType);
        cfd.setValidateRule(null);
        return cfd;
    }

    /**
     * 获取到某个选项的子选项 PS : 未停用的字段
     * 
     * @param customField
     * @return
     */
    private List<FieldOption> retrievalOptions(CustomField customField, CustomFieldDto cfd) {
        List<FieldOption> retOpts = Lists.newArrayList();
        if (customField.getSystemFieldNum() == -1) {
            List<TXCustomOption> customChoiceFieldList = null;
            customChoiceFieldList =
                txCustomOptionDao.getTXCustomOptionListWithCondition(customField.getId(), false, null);
            if (GenericsUtils.isNullOrEmpty(customChoiceFieldList)) {
                return Collections.emptyList();
            }
            for (TXCustomOption ccf : customChoiceFieldList) {
                retOpts.add(FieldOption.buildDto(ccf));
            }
        } else {
            retOpts = cfd.getOptions();
        }
        return retOpts;
    }

    public static void main(String[] args) throws InvocationTargetException, IllegalAccessException {
        Map<String, Object> contentMap = new HashMap<>();
        contentMap.put("address", "京市海淀区软件园北街");
        contentMap.put("latitude", "40.054774");
        contentMap.put("longitude", "116.288981");

        Gson gson = new Gson();

        SystemFields systemField = SystemFields.getSystemField("longitude,latitude,address");

        CustomFieldTypeInterface<?> fromJson = gson.fromJson(gson.toJson(contentMap), PositionFieldType.class);
        Map<String, Object> objKeyValue = systemField.toObjKeyValue(fromJson);

        System.out.println(objKeyValue);

        OrgUserBaseInfo orgUserBaseInfo = new OrgUserBaseInfo();

        org.apache.commons.beanutils.BeanUtils.populate(orgUserBaseInfo, objKeyValue);

        System.out.println(orgUserBaseInfo);

    }

    @Override
    public List<Long> saveOrUpdateCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long studentIdOrConsultId,
        Long orgId) {
        List<CustomFieldDto> fields = orgUserBaseInfo.getFields();
        List<CustomFieldValue> saveValues = Lists.newArrayList();
        for (CustomFieldDto cfd : fields) {
            log.info("[CustomField] CustomFieldDto={}", cfd);
            // 可能是4个线索字段
            List<String> consultKeys = ConsultFieldEnum.getLabels();
            if (consultKeys.contains(cfd.getKey())) {
                continue;
            }
            CustomFieldValueRequest request = (CustomFieldValueRequest) cfd;
            String name = cfd.getKey();
            SystemFields systemField = SystemFields.getSystemField(name);
            Integer customFieldType = cfd.getType();
            Map<String, Object> contentMap = request.getValues();
            log.info("[CustomField] systemFiled={}", contentMap);
            if (systemField != null) {
                if (contentMap == null || contentMap.isEmpty()) {
                    continue;
                }
                CustomFieldTypeInterface<Object> findCustomFieldSolver =
                    CustomFieldTypeFactory.findCustomFieldSolver(CustomFieldType.getCustomFieldType(customFieldType));
                Gson gson = new Gson();

                CustomFieldTypeInterface<?> fromJson =
                    gson.fromJson(gson.toJson(contentMap), findCustomFieldSolver.getClass());
                Map<String, Object> objKeyValue = systemField.toObjKeyValue(fromJson);

                log.info("[CustomField] systemFiled={}", objKeyValue);
                try {
                    if (objKeyValue != null) {
                        org.apache.commons.beanutils.BeanUtils.populate(orgUserBaseInfo, objKeyValue);
                    }
                } catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("can not re-set value to CustomFieldValueRequest cause by : {} ", e);
                }
            } else {
                // 前置性判断 判断该值是否是必填
                if (contentMap == null && cfd.getIsRequired() == RequireStatus.IS_REQUIRE.getStatus()) {
                    log.warn("The customField value is required!");
                    throw new BussinessException(StudentErrorCode.REQUIRE_VALUE);
                }

                // 判断该自定义字段是否使用过
                Long fieldId = Long.parseLong(cfd.getKey());
                CustomField customField = customFieldDao.getById(fieldId, "id", "isUsed");
                if (customField != null) {
                    if (customField.getIsUsed() == UseStatus.NOT_USED.getStatus()) {
                        customField.setUpdateTime(new Date());
                        customField.setIsUsed(UseStatus.IS_USED.getStatus());
                        customFieldDao.update(customField, "isUsed", "updateTime");
                    }
                } else {
                    log.error("[CustomFiled] this customFiled is not exist, id param:{}", fieldId);
                }
                // 自定义字段的属性值
                CustomFieldValue fieldValueFromSql = customFieldValueDao.getCustomFieldValue(fieldId,
                    orgUserBaseInfo.getIsStudent(), studentIdOrConsultId);
                log.info("[CustomFiled] fieldValueFromSql param:{}", fieldValueFromSql);
                if (GenericsUtils.notNullAndEmpty(contentMap)) {
                    // 当保存选项时候需要判断该选项是否是第一次使用
                    updateIsUsedTXCustomOPtion(contentMap, CustomFieldType.getCustomFieldType(customFieldType));
                    Gson gson = new Gson();
                    CustomFieldValue customFieldValuePo =
                        cfd.buildCustomFieldValue(orgUserBaseInfo.getIsStudent(), studentIdOrConsultId, orgId);
                    customFieldValuePo.setValue(gson.toJson(contentMap));
                    if (studentIdOrConsultId == null || fieldValueFromSql == null) {
                        // 说明这个人有设过该值
                        saveValues.add(customFieldValuePo);
                    } else {
                        fieldValueFromSql.setValue(gson.toJson(contentMap));
                        fieldValueFromSql.setUpdateTime(new Date());
                        customFieldValueDao.update(fieldValueFromSql, "value", "updateTime");
                    }
                } else {
                    // 当用户更新学员或者线索的时候，用户有可能清空对象，需要将值设为{}
                    if (studentIdOrConsultId != null && studentIdOrConsultId > 0 && fieldValueFromSql != null) {
                        fieldValueFromSql.setValue("{}");
                        fieldValueFromSql.setUpdateTime(new Date());
                        customFieldValueDao.update(fieldValueFromSql, "value", "updateTime");
                        log.info("[CustomField] update fieldValueFromSql:{}", fieldValueFromSql);
                    }

                }

            }
        }
        // 保存所有的自定义字段的属性值
        List<Long> fieldValueIds = new ArrayList<>();
        this.customFieldValueDao.saveAll(saveValues);
        if (GenericsUtils.notNullAndEmpty(saveValues)) {
            for (CustomFieldValue fieldValue : saveValues) {
                Long valueId = fieldValue.getId();
                fieldValueIds.add(valueId);
            }
        }

        return fieldValueIds;

    }

    public void updateIsUsedTXCustomOPtion(Map<String, Object> contentMap, CustomFieldType fieldType) {
        Integer id = null;
        switch (fieldType) {
            case SINGLE_CHOICE:
                id = (Integer) contentMap.get("id");
                updateTXCustomOption(id.longValue());
                break;
            case MULTI_CHOICE:
                CustomFieldTypeInterface<Object> findCustomFieldSolver =
                    CustomFieldTypeFactory.findCustomFieldSolver(CustomFieldType.MULTI_CHOICE);
                Gson gson = new Gson();
                String value = String.valueOf(gson.toJson(contentMap));
                MultiChoiceFieldTypeWrapper wrapper =
                    (MultiChoiceFieldTypeWrapper) findCustomFieldSolver.jsonToObj(value);
                log.info("获取的value 为 param:{}, MultiChoiceFieldTypeWrapper param:{}", value, wrapper);
                if (GenericsUtils.notNullAndEmpty(wrapper)) {
                    List<MultiChoiceFieldType> multiChoiceOptions = wrapper.getOptions();
                    for (MultiChoiceFieldType multiChoiceOption : multiChoiceOptions) {
                        id = multiChoiceOption.getId().intValue();
                        updateTXCustomOption(id.longValue());
                    }
                }
                break;
            default:
                break;
        }

    }

    public void updateTXCustomOption(Long id) {
        TXCustomOption option = txCustomOptionDao.getById(id);
        if (option != null) {
            if (option.getIsUsed() == UseStatus.NOT_USED.getStatus()) {
                option.setIsUsed(UseStatus.IS_USED.getStatus());
                option.setUpdateTime(new Date());
                txCustomOptionDao.update(option, "isUsed", "updateTime");
            }
        } else {
            log.error("[CustomFiled] this option is not exist, id:{}", id);
        }
    }

    @Override
    public Map<Long, CustomFieldValue> mapFieldValues(Long orgId, boolean isStudent, Long studentIdOrConsultId) {
        Map<Long, CustomFieldValue> customFieldValueMap = new HashMap<>();

        List<CustomField> customFields = customFieldDao.getCustomFieldList(orgId, AddType.NOT_SYSTEM.getCode());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(customFields)) {
            List<Long> fieldIds = new ArrayList<Long>();
            for (CustomField field : customFields) {
                fieldIds.add(field.getId());
                customFieldValueMap.put(field.getId(), null);
            }

            List<CustomFieldValue> values =
                this.customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentIdOrConsultId, fieldIds);

            for (CustomFieldValue value : values) {
                customFieldValueMap.put(value.getFieldId(), value);
            }
        }

        return customFieldValueMap;
    }

    @Override
    public void updateStudentId(Long orgId, Long consultId, Long studentId) {
        customFieldValueDao.updateStudentId(orgId, consultId, studentId);
    }

}
