/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.enums;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年8月4日
 * @desc 线索四个系统字段
 */
public enum ConsultFieldEnum {
    CONSULT_STATUS("consultStatus", "跟进状态", CustomFieldSections.BASE_INFO.getId()),
    CONSULT_SOURCE("consultSource", "线索来源", CustomFieldSections.BASE_INFO.getId()),
    INTENSION_LEVEL("intensionLevel", "意向级别", CustomFieldSections.BASE_INFO.getId()),
    CASCADE_ID("cascadeId", "线索所属人", CustomFieldSections.BASE_INFO.getId());
    
    private ConsultFieldEnum(String key, String label, Integer sectionId) {
        this.key = key;
        this.label = label;
        this.sectionId = sectionId;
    }
    private String key;
    private String label;
    public Integer sectionId;
    
    public String getKey(){
        return key;
    }
    
    public String getLabel(){
        return label;
    }
    
    public Integer getSectionId(){
        return sectionId;
    }
    
    private static Map<String, ConsultFieldEnum> map = Maps.newHashMap();
    
    static {
        for (ConsultFieldEnum p : values()) {
            map.put(p.getKey(), p);
        }
    }
    
    public static ConsultFieldEnum getConsultFieldEnum(String key){
        ConsultFieldEnum consultFieldEnum = map.get(key);
        return consultFieldEnum;
    }
    
    public static List<String> getLabels(){
        List<String> labels = new ArrayList<>();
        for(ConsultFieldEnum p : values()){
            labels.add(p.getKey());
        }
        return labels;
    }
    
}
