/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.request;

import java.io.Serializable;

import lombok.Data;

/**
 * @title StudentListRequestDto
 * @desc TODO
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
@Data
public class StudentListRequestDto implements Serializable {

    private static final long serialVersionUID = 547521844640451760L;

    private Long courseNumber;

    private Integer courseType;

    private String searchKey;

    private Integer studentStatus;

    private String initial;

    private Integer opType;// 最近操作类型: 1：最近7天需要跟进，2：最近7天报班，3：最近7天创建的

    private Integer isSchedule;// 是否已排课 1:已排课，2：未排课

    private Integer leftMinClassHour;// 剩余最小课时

    private Integer leftMaxClassHour;// 剩余最大课时

    private Integer followDate;// 跟进日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer createDate;// 创建日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer enrollDate;// 报班日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer pageNum = 1;

    private Integer pageSize = 20;

    private Integer sex;// 性别

    private String queryStr;

    private String queryValue;

    private Integer cascadeId;

    // 排序规则,默认升序0:升序,1:降序
    private int orderType = 0;

    // 排序字段
    private String orderName;

    private boolean needAvatar = true; // 展示数据是否需要头像
    private boolean needClassInfo = true;// 展示是否需要学员课消数据(针对APP端学员列表展示),老接口需要

    public void setSex(Integer sex) {
        if (sex == null) {
            return;
        }
        this.sex = (sex - 1); // Infos:APP参数传递的时候,将性别 man -->1(实际数据库存储的为0) ,women --->2(实际数据库为1),该转变过程不规范，调用接口请注意
    }
}
