package com.baijia.tianxiao.sal.student.dto.customFields;

import com.baijia.tianxiao.dal.roster.po.TXCustomOption;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jul 21, 2016 2:29:14 PM
 * @desc :
 */
@Data
public class FieldOption {

    public static final FieldOption NOT_NEED_OPTION = new FieldOption(-1L, "");
    private Long id;
    private String value;

    public static FieldOption buildDto(TXCustomOption customOption) {
        FieldOption instance = instance();
        instance.setId(customOption.getId());
        instance.setValue(customOption.getLabel());
        return instance;
    }
    
    public static FieldOption buildDto(Long id , String label) {
        FieldOption instance = instance();
        instance.setId(id);
        instance.setValue(label);
        return instance;
    }

    public FieldOption() {

    }

    public FieldOption(Long id, String value) {
        this.id = id;
        this.value = value;
    }

    public static FieldOption instance() {
        return new FieldOption();
    }

}
