package com.baijia.tianxiao.sal.student.dto.customFields;

import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;

import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jul 21, 2016 11:45:49 AM
 * @desc :
 */
@Data
public class CustomFieldDto {
    private String key; // 唯一键
    private String label; // 姓名 //中文名
    private Integer type;// 字段类型 详见CustomFieldTypes
    private Integer isRequired; // 是否必填 0:不是 1:是
    private ValidatorExpression validateRule; // [{}]校验规则
    private Integer sectionId; // 所属的section,
    private Integer sorted; // 所属的section,
    private List<FieldOption> options; //
    
    /**
     * 只针对非系统字段进行值对象的构建
     *
     * @param userId
     * @param isStudent
     *
     * @return
     */
    public CustomFieldValue buildCustomFieldValue(boolean isStudent, Long userId, long orgId) {
        CustomFieldValue cfv = new CustomFieldValue();
        Long fieldId = Long.parseLong(this.key);
        cfv.setFieldId(fieldId);
        cfv.setFieldType(type);
        Date currentTime = new Date();
        cfv.setCreateTime(currentTime);
        cfv.setUpdateTime(currentTime);
        cfv.setOrgId(orgId);
        if (isStudent) {
            cfv.setStudentId(userId);
        } else {
            cfv.setConsultUserId(userId);
        }
        return cfv;
    }

    public void setCustomFieldValue(CustomFieldValue customFieldValue){
        customFieldValue.setUpdateTime(new Date());
    }
    
    public CustomFieldDto(String key, String label, Integer sectionId, Integer isRequire, Integer type){
        this.key = key;
        this.label = label;
        this.sectionId = sectionId;
        this.isRequired = isRequire;
        this.type = type;
    }
    
    public CustomFieldDto(){
        
    }
    
}
