/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.api;

import java.util.List;

import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;

/**
 * @title StudentTagService
 * @desc 学生标签相关
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */

public interface OrgStudentTagService {

    /**
     * 添加学生标签
     * 
     * @param tagDtos
     * @param type
     * @param studentId
     * @param orgId
     */
    public List<TagInfoDto> addStudentTag(List<TagInfoDto> tagDtos, Integer type, Long studentId, Long orgId);

    /**
     * 删除学生标签
     * 
     * @param studentCommenRequestDto
     * @param orgId
     */
    public void delStudentTag(StudentCommenRequestDto studentCommenRequestDto, Long orgId);
    

    /**
     * 获取标签
     * 
     * @param type
     * @param studentId
     * @param orgId
     * @return
     */
    public OrgTagListResopnseDto getTags(Integer type, Long studentId, Long orgId);
    
    /**
     * 合并标签
     * @param sourceConsultUser
     * @param destConsultUser
     * @param orgId
     */
    void mergeTags(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId);
    
    /**
     * 批量处理标签(CRM-PC): 新增、编辑、删除
     * @param type 学员类型: OrgShowInfoType(线索、学员档案)
     * @param orgId 机构id
     * @param studentId 学员id: 线索对应(yunying.tx_consult_user)的id; 学员档案对应(yunying.org_students)的id
     * @param tagsDto 标签对象
     */
    void batchHandleTags(Integer type, Long orgId, Long studentId, List<TagInfoDto> list);
    
    /**
     * 查询 指定机构热门标签列表
     * @author zhenyujian
     * 
     * @param orgId 机构id
     * @param listSize 查询数量
     * @param minTagTimes 标签最低使用次数(如: minTagTimes=5 表示 至少使用过5次才被算作热门标签)
     */
    List<TagInfoDto> getHotTags(Long orgId, Integer listSize, Integer minTagTimes);

    void delTagsByConsulterId(Long consulterId, Long orgId);
}
