/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.statistics.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dto.TxSignupRecordStatistics;
import com.baijia.tianxiao.sal.statistics.TxSignupRecordStatisticsService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxSignupRecordStatisticsServiceImpl
implements TxSignupRecordStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(TxSignupRecordStatisticsServiceImpl.class);
    @Autowired
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Override
    public TxSignupRecordStatistics getStatisticsSum(Collection<Long> orgIds, Integer opTo, Date startTime, Date endTime) {
        log.info("getSignupRecordStatisticsSum params : orgIds = {}, opTo = {}, startTime = {}, endTime = {}", new Object[]{orgIds, opTo, DateUtil.getAllDayStr((Date)startTime), DateUtil.getAllDayStr((Date)endTime)});
        TxSignupRecordStatistics result = new TxSignupRecordStatistics();
        List recordList = this.txSignupRecordDayDao.getTxSignupStatistics(orgIds, opTo, startTime, endTime, new String[]{"orgId", "opPrice", "opCount", "opTo"});
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return result;
        }
        recordList.forEach(o -> {
            Double money = o.getOpPrice() * 100.0;
            if (o.getOpTo() == 1) {
                result.getCollectionStatistics().add(money.longValue(), o.getOpCount().intValue());
            } else if (o.getOpTo() == 2) {
                result.getRefundStatistics().add(money.longValue(), o.getOpCount().intValue());
            }
        });
        log.info("getSignupRecordStatisticsSum result = {}", (Object)result);
        return result;
    }

    @Override
    public Map<Long, TxSignupRecordStatistics> getStatisticsDetail(Collection<Long> orgIds, Integer opTo, Date startTime, Date endTime) {
        log.info("getSignupRecordStatisticsDetail params : orgIds = {}, opTo = {}, startTime = {}, endTime = {}", new Object[]{orgIds, opTo, DateUtil.getAllDayStr((Date)startTime), DateUtil.getAllDayStr((Date)endTime)});
        HashMap result = Maps.newHashMap();
        List recordList = this.txSignupRecordDayDao.getTxSignupStatistics(orgIds, opTo, startTime, endTime, new String[]{"orgId", "opPrice", "opCount", "opTo"});
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return result;
        }
        recordList.forEach(o -> {
            if (result.get(o.getOrgId()) == null) {
                TxSignupRecordStatistics orgRecord = new TxSignupRecordStatistics();
                orgRecord.setOrgId(o.getOrgId());
                result.put(o.getOrgId(), orgRecord);
            }
            Double money = o.getOpPrice() * 100.0;
            if (o.getOpTo() == 1) {
                ((TxSignupRecordStatistics)result.get(o.getOrgId())).getCollectionStatistics().add(money.longValue(), o.getOpCount().intValue());
            } else if (o.getOpTo() == 2) {
                ((TxSignupRecordStatistics)result.get(o.getOrgId())).getRefundStatistics().add(money.longValue(), o.getOpCount().intValue());
            }
        });
        log.info("getSignupRecordStatisticsDetail result = {}", (Object)result);
        return result;
    }
}

