package com.baijia.tianxiao.sal.statistics.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;

import org.springframework.stereotype.Service;

import java.util.Date;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/12.
 */
@Slf4j
@Service
public class TxConsultStatMonthServiceImpl implements TxConsultStatMonthService {

    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;

    @Override
    public void saveStat(long orgId, long consultUserId, long userId, int status, Integer sourceType, Integer number) {
        TxConsultUserStatMonth dto = new TxConsultUserStatMonth();
        dto.setOrgId(orgId);
        dto.setConsultUserId(consultUserId);
        dto.setUserId(userId);
        dto.setStatus(status);
        //这张表我们就不统计咨询来源，TxConsultSourceStatisticMonth专门来统计咨询来源2016-08-29
//        dto.setSourceType(null);
//        dto.setNumber(null);
        Date now = new Date();
        dto.setCreateTime(now);
        dto.setUpdateTime(now);
        log.info("consult status month save {}", dto);
        txConsultUserStatMonthDao.save(dto, false);
        log.info("TxConsultUserStatMonth dto:{}", dto);
    }
}
