/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.statistics.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TxConsultStatMonthServiceImpl
implements TxConsultStatMonthService {
    private static final Logger log = LoggerFactory.getLogger(TxConsultStatMonthServiceImpl.class);
    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxConsultUserDao txConsultUserDao;

    @Override
    public void saveStat(long orgId, long consultUserId, long userId, int status, Integer sourceType, Integer number) {
        TxConsultUserStatMonth dto = new TxConsultUserStatMonth();
        dto.setOrgId(Long.valueOf(orgId));
        dto.setConsultUserId(Long.valueOf(consultUserId));
        dto.setUserId(Long.valueOf(userId));
        dto.setStatus(Integer.valueOf(status));
        Date now = new Date();
        dto.setCreateTime(now);
        dto.setUpdateTime(now);
        log.info("consult status month save {}", (Object)dto);
        this.txConsultUserStatMonthDao.save((Object)dto, Boolean.valueOf(false), new String[0]);
        log.info("TxConsultUserStatMonth dto:{}", (Object)dto);
    }

    @Override
    public List<Long> getEnrollConsultIdsByStatus(Long orgId, int status, Date startDate, Date endDate, PageDto pageDto) {
        List txConsultUserStatMonths = this.txConsultUserStatMonthDao.getPageTxConsultUserStatMonthByStatus(orgId, status, startDate, endDate, pageDto);
        if (GenericsUtils.isNullOrEmpty((Object)txConsultUserStatMonths)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> consultIdAlls = this.getConsultIdsByTxConsultUserStatMonths(txConsultUserStatMonths, orgId);
        List consultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultIdAlls, Integer.valueOf(DeleteStatus.NORMAL.getValue()), Integer.valueOf(status));
        if (GenericsUtils.isNullOrEmpty((Object)consultUsers)) {
            return Collections.EMPTY_LIST;
        }
        this.setStudentId(consultUsers, orgId);
        HashSet<Long> studentIds = new HashSet<Long>();
        ArrayList<Long> consultIds = new ArrayList<Long>();
        ArrayList<Long> deleteIsStudentConsultIds = new ArrayList<Long>();
        for (TxConsultUser user : consultUsers) {
            Long consultId = user.getId();
            Long studentId = user.getStudentId();
            if (studentId != null && studentId > 0L) {
                studentIds.add(studentId);
                deleteIsStudentConsultIds.add(consultId);
            }
            consultIds.add(consultId);
        }
        if (status != EncrollmentTypeEnum.BAOMING.getValue()) {
            log.info("deleteConsultIds param:{}", deleteIsStudentConsultIds);
            consultIds.removeAll(deleteIsStudentConsultIds);
        }
        return consultIds;
    }

    private List<Long> getConsultIdsByTxConsultUserStatMonths(List<TxConsultUserStatMonth> txConsultUserStatMonths, Long orgId) {
        ArrayList<Long> consultIds = new ArrayList<Long>();
        for (TxConsultUserStatMonth txConsultUserStatMonth : txConsultUserStatMonths) {
            Long consultId = txConsultUserStatMonth.getConsultUserId();
            consultIds.add(consultId);
        }
        return consultIds;
    }

    private void setStudentId(List<TxConsultUser> users, Long orgId) {
        List orgStudents;
        HashMap<Long, TxConsultUser> map = new HashMap<Long, TxConsultUser>();
        for (TxConsultUser user : users) {
            if (user.getStudentId() != null && user.getStudentId() > 0L || user.getUserId() == null || user.getUserId() <= 0L) continue;
            map.put(user.getUserId(), user);
        }
        log.info("[Dashboard] consultMap:{}", map);
        if (GenericsUtils.notNullAndEmpty(map.keySet()) && GenericsUtils.notNullAndEmpty((Object)(orgStudents = this.orgStudentDao.getStudentsByUserIdsAndOrgIds((Collection)Lists.newArrayList((Object[])new Long[]{orgId}), map.keySet())))) {
            for (OrgStudent stu : orgStudents) {
                TxConsultUser user = (TxConsultUser)map.get(stu.getUserId());
                if (user == null) continue;
                user.setStudentId(stu.getId());
            }
        }
    }
}

