package com.baijia.tianxiao.sal.statistics.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/12.
 */
@Slf4j
@Service
public class TxConsultStatMonthServiceImpl implements TxConsultStatMonthService {

    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxConsultUserDao txConsultUserDao;

    @Override
    public void saveStat(long orgId, long consultUserId, long userId, int status, Integer sourceType, Integer number) {
        TxConsultUserStatMonth dto = new TxConsultUserStatMonth();
        dto.setOrgId(orgId);
        dto.setConsultUserId(consultUserId);
        dto.setUserId(userId);
        dto.setStatus(status);
        // 这张表我们就不统计咨询来源，TxConsultSourceStatisticMonth专门来统计咨询来源2016-08-29
        // dto.setSourceType(null);
        // dto.setNumber(null);
        Date now = new Date();
        dto.setCreateTime(now);
        dto.setUpdateTime(now);
        log.info("consult status month save {}", dto);
        txConsultUserStatMonthDao.save(dto, false);
        log.info("TxConsultUserStatMonth dto:{}", dto);
    }

    @Override
    public List<Long> getEnrollConsultIdsByStatus(Long orgId, int status, Date startDate, Date endDate,
                                                  PageDto pageDto) {
        List<TxConsultUserStatMonth> txConsultUserStatMonths =
                this.txConsultUserStatMonthDao.getPageTxConsultUserStatMonthByStatus(orgId,

                        status, startDate, endDate, pageDto);

        if (GenericsUtils.isNullOrEmpty(txConsultUserStatMonths)) {
            return Collections.emptyList();

        }

        List<Long> consultIdAlls = getConsultIdsByTxConsultUserStatMonths(txConsultUserStatMonths, orgId);

        List<TxConsultUser> consultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultIdAlls,
                Integer.valueOf(DeleteStatus.NORMAL.getValue()), Integer.valueOf(status));

        if (GenericsUtils.isNullOrEmpty(consultUsers)) {

            return Collections.emptyList();

        }
        setStudentId(consultUsers, orgId);
        Set<Long> studentIds = new HashSet<Long>();
        List<Long> consultIds = new ArrayList<Long>();
        List<Long> deleteIsStudentConsultIds = new ArrayList<Long>();
        for (TxConsultUser user : consultUsers) {
            Long consultId = user.getId();
            Long studentId = user.getStudentId();
            if ((studentId != null) && (studentId.longValue() > 0L)) {
                studentIds.add(studentId);
                deleteIsStudentConsultIds.add(consultId);
            }
            consultIds.add(consultId);
        }

        if (status != EncrollmentTypeEnum.BAOMING.getValue()) {
            log.info("deleteConsultIds param:{}", deleteIsStudentConsultIds);
            consultIds.removeAll(deleteIsStudentConsultIds);
        }

        return consultIds;
    }

    private List<Long> getConsultIdsByTxConsultUserStatMonths(List<TxConsultUserStatMonth> txConsultUserStatMonths,
                                                              Long orgId) {
        List<Long> consultIds = new ArrayList<>();
        for (TxConsultUserStatMonth txConsultUserStatMonth : txConsultUserStatMonths) {
            Long consultId = txConsultUserStatMonth.getConsultUserId();
            consultIds.add(consultId);
        }
        return consultIds;
    }

    private void setStudentId(List<TxConsultUser> users, Long orgId) {
        Map<Long, TxConsultUser> map = new HashMap<>();

        for (TxConsultUser user : users) {
            if (user.getStudentId() != null && user.getStudentId() > 0) {
                continue;
            }
            if (user.getUserId() != null && user.getUserId() > 0) {
                map.put(user.getUserId(), user);
            }
        }
        log.info("[Dashboard] consultMap:{}", map);

        if (GenericsUtils.notNullAndEmpty(map.keySet())) {
            List<OrgStudent> orgStudents =
                    orgStudentDao.getStudentsByUserIdsAndOrgIds(Lists.newArrayList(orgId), map.keySet());

            if (GenericsUtils.notNullAndEmpty(orgStudents)) {
                for (OrgStudent stu : orgStudents) {
                    TxConsultUser user = map.get(stu.getUserId());
                    if (user != null) {
                        user.setStudentId(stu.getId());
                    }
                }
            }
        }
    }
}