/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.statistics.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sal.statistics.TxMonitorTodayMinService;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxMonitorTodayMinServiceImpl
implements TxMonitorTodayMinService {
    private static final Logger log = LoggerFactory.getLogger(TxMonitorTodayMinServiceImpl.class);
    @Autowired
    private TxMonitorTodayMinDao txMonitorTodayMinDao;

    @Override
    public List<TxMonitorOrgDay> groupByOrgDay(Long orgNumber) {
        List orgDays = this.txMonitorTodayMinDao.group2OrgDay(orgNumber, new String[0]);
        Map map = Maps.newHashMap();
        for (TxMonitorOrgDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber());
            TxMonitorOrgDay value = (TxMonitorOrgDay)map.get(key);
            if (value == null) {
                one.setUv(Integer.valueOf(1));
                map.put(key, one);
                continue;
            }
            value.setPv(Integer.valueOf(value.getPv() + one.getPv()));
            value.setUv(Integer.valueOf(value.getUv() + 1));
            map.put(key, value);
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(map.values());
        return list;
    }

    @Override
    public List<TxMonitorTypeDay> groupByTypeDay(Long orgNumber) {
        List orgDays = this.txMonitorTodayMinDao.group2TypeDay(orgNumber, new String[0]);
        Map map = Maps.newHashMap();
        for (TxMonitorTypeDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber()) + one.getPageType();
            TxMonitorTypeDay value = (TxMonitorTypeDay)map.get(key);
            if (value == null) {
                one.setUv(Integer.valueOf(1));
                map.put(key, one);
                continue;
            }
            value.setPv(Integer.valueOf(value.getPv() + one.getPv()));
            value.setUv(Integer.valueOf(value.getUv() + 1));
            map.put(key, value);
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(map.values());
        return list;
    }

    @Override
    public List<TxMonitorCourseDay> groupByCourseDay(Long orgNumber, List<Integer> pageTypes) {
        List orgDays = this.txMonitorTodayMinDao.group2CourseDay(orgNumber, pageTypes, new String[0]);
        Map map = Maps.newHashMap();
        for (TxMonitorCourseDay one : orgDays) {
            String key = String.valueOf(one.getOrgNumber()) + one.getPageType() + one.getCourseNumber();
            TxMonitorCourseDay value = (TxMonitorCourseDay)map.get(key);
            if (value == null) {
                one.setUv(Integer.valueOf(1));
                map.put(key, one);
                continue;
            }
            value.setPv(Integer.valueOf(value.getPv() + one.getPv()));
            value.setUv(Integer.valueOf(value.getUv() + 1));
            map.put(key, value);
        }
        ArrayList list = Lists.newArrayList();
        list.addAll(map.values());
        return list;
    }

    @Override
    public void deleteTodayBase() {
        List ids = this.txMonitorTodayMinDao.queryForIds(new String[0]);
        if (ids != null && !ids.isEmpty()) {
            log.info("deleteTodayBase ids size is {}", (Object)ids.size());
            this.txMonitorTodayMinDao.delByIds((Collection)ids);
        }
    }
}

