/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.sms.service.impl;

import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.sal.sms.service.SmsService;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Resource
    private TtsSmsDao ttsSmsDao;

    @Override
    public boolean saveAndSendSms(Long operatorId, Long smsKey, Integer userRole, Long userId, String mobile, String content) {
        if (!ParamValidateUtils.validateMobile((String)mobile) || StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        TtsSms sms = new TtsSms();
        sms.setContent(content);
        sms.setMessageType((Number)SmsMessageType.TIANXIAO_NOTIFY.getCode());
        sms.setMobile(mobile);
        sms.setOperatorId(operatorId);
        sms.setSendSmsKey(Long.valueOf(smsKey != null ? smsKey : 0L));
        sms.setUserRole((Number)userRole);
        boolean sendResult = false;
        try {
            sendResult = SmsSendUtil.sendSms((String)mobile, (String)content, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, (boolean)true);
            sms.setSendResult((Number)(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue()));
            this.ttsSmsDao.save((Object)sms, new String[0]);
        }
        catch (Exception e) {
            log.warn("save sms record catch error:", (Throwable)e);
        }
        log.info("send sms to :{} is succ:{}", (Object)mobile, (Object)sendResult);
        return sendResult;
    }
}

