package com.baijia.tianxiao.sal.room.dto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.google.common.collect.Lists;

import lombok.Data;

@Data
public class RoomDto {

	//教室id
	private Long id;
	
	//教室名称
	private String name;
	
	public static RoomDto convertToDto(OrgClassRoom orgClassRoom) {
		RoomDto dto = new RoomDto();
		dto.setId(orgClassRoom.getId());
		dto.setName(orgClassRoom.getRoomName());
		return dto;
	}
	
	public static List<RoomDto> convertToDto(Map<Long, String> names) {
		List<RoomDto> roomDto = Lists.newArrayList();
		Set<Long> keys = names.keySet();
		Iterator<Long> it = keys.iterator();
		while(it.hasNext()) {
			Long id = it.next();
			String name = names.get(id);
			RoomDto dto = new RoomDto();
			dto.setId(id);
			dto.setName(name);
			roomDto.add(dto);
		}
		return roomDto;
	}
}
