
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.room.service;

import java.util.Collection;
import java.util.List;

import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title ClassRoomService
 * @desc TODO
 * @author cxm
 * @date 2015年12月24日
 * @version 1.0
 */
public interface ClassRoomService {

    /**
     * 查询机构的教室
     * 
     * @param orgId
     * @param branchId
     * @return
     */
    List<ClassRoomDto> listOrgClassRooms(Long orgId, Long branchId, Long courseId, PageDto page);

    /**
     * 将教室添加到指定
     * 
     * @param orgId
     * @param courseId
     * @param roomIds
     */
    void addClassRoomCourse(Long orgId, Long courseId, Collection<Long> roomIds);

    /**
     * 从课程的教室列表中
     * 
     * @param orgId
     * @param courseId
     * @param roomIds
     */
    void delClassRoomFromCourse(Long orgId, Long courseId, Collection<Long> roomIds);

    /**
     * 查询机构指定课程对应的教室
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    List<ClassRoomDto> listOrgCourseRooms(Long orgId, Long courseId);

    /**
     * 课程默认教室设置
     * 
     * @param orgId
     * @param courseId
     * @param roomId
     * @param enable
     */
    void courseRoomSeting(Long orgId, Long courseId, Long roomId, boolean enable);

    /**
     * 删除教室
     * 
     * @param orgId
     * @param roomId
     */
    void delClassRoom(Long orgId, Long roomId);

    /**
     * @param params
     * @return
     */
    ClassRoomDto saveOrUpdateClassRoom(Long orgId, ClassRoomDto params);

    /**
     * 查看教室详情
     * 
     * @param orgId
     * @param roomId
     * @return
     */
    ClassRoomDto info(Long orgId, Long roomId);

}
