/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.room.dto;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ClassRoomDto {
    private Long roomId;
    private Long orgId;
    private Long branchId;
    private String roomNumber;
    private String roomName;
    private String initial;
    private boolean isChosen = false;
    private Integer roomSize;
    private boolean delStatus;
    private Date createTime;
    private int isDefault;
    private Date updateTime;

    public static OrgClassRoom converPo(ClassRoomDto dto) {
        Preconditions.checkNotNull((Object)dto);
        OrgClassRoom po = new OrgClassRoom();
        po.setBranchId(dto.getBranchId());
        po.setCreateTime(dto.getCreateTime());
        po.setDelStatus(dto.isDelStatus());
        po.setOrgId(dto.getOrgId());
        po.setId(dto.getRoomId());
        po.setRoomName(dto.getRoomName());
        po.setRoomNumber(dto.getRoomNumber());
        po.setRoomSize(dto.getRoomSize());
        return po;
    }

    public static ClassRoomDto covert2Dto(OrgClassRoom po) {
        Preconditions.checkNotNull((Object)po);
        ClassRoomDto dto = new ClassRoomDto();
        dto.setBranchId(po.getBranchId());
        dto.setCreateTime(po.getCreateTime());
        dto.setDelStatus(po.isDelStatus());
        dto.setOrgId(po.getOrgId());
        dto.setRoomId(po.getId());
        dto.setRoomName(po.getRoomName());
        dto.setRoomNumber(po.getRoomNumber());
        dto.setRoomSize(po.getRoomSize());
        dto.setUpdateTime(po.getUpdateTime());
        return dto;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.roomName}), (Object)"\u6559\u5ba4\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.roomSize != null && this.roomSize > 0 && this.roomSize <= 400 ? 1 : 0) != 0, (Object)"\u6559\u5ba4\u5bb9\u91cf\u5fc5\u987b\u57281-400\u4e4b\u95f4");
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getInitial() {
        return this.initial;
    }

    public boolean isChosen() {
        return this.isChosen;
    }

    public Integer getRoomSize() {
        return this.roomSize;
    }

    public boolean isDelStatus() {
        return this.delStatus;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public int getIsDefault() {
        return this.isDefault;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setBranchId(Long branchId) {
        this.branchId = branchId;
    }

    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    public void setChosen(boolean isChosen) {
        this.isChosen = isChosen;
    }

    public void setRoomSize(Integer roomSize) {
        this.roomSize = roomSize;
    }

    public void setDelStatus(boolean delStatus) {
        this.delStatus = delStatus;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setIsDefault(int isDefault) {
        this.isDefault = isDefault;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassRoomDto)) {
            return false;
        }
        ClassRoomDto other = (ClassRoomDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$roomId = this.getRoomId();
        Long other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !((Object)this$roomId).equals(other$roomId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$branchId = this.getBranchId();
        Long other$branchId = other.getBranchId();
        if (this$branchId == null ? other$branchId != null : !((Object)this$branchId).equals(other$branchId)) {
            return false;
        }
        String this$roomNumber = this.getRoomNumber();
        String other$roomNumber = other.getRoomNumber();
        if (this$roomNumber == null ? other$roomNumber != null : !this$roomNumber.equals(other$roomNumber)) {
            return false;
        }
        String this$roomName = this.getRoomName();
        String other$roomName = other.getRoomName();
        if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
            return false;
        }
        String this$initial = this.getInitial();
        String other$initial = other.getInitial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) {
            return false;
        }
        if (this.isChosen() != other.isChosen()) {
            return false;
        }
        Integer this$roomSize = this.getRoomSize();
        Integer other$roomSize = other.getRoomSize();
        if (this$roomSize == null ? other$roomSize != null : !((Object)this$roomSize).equals(other$roomSize)) {
            return false;
        }
        if (this.isDelStatus() != other.isDelStatus()) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        if (this.getIsDefault() != other.getIsDefault()) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassRoomDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : ((Object)$roomId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $branchId = this.getBranchId();
        result = result * 59 + ($branchId == null ? 43 : ((Object)$branchId).hashCode());
        String $roomNumber = this.getRoomNumber();
        result = result * 59 + ($roomNumber == null ? 43 : $roomNumber.hashCode());
        String $roomName = this.getRoomName();
        result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
        String $initial = this.getInitial();
        result = result * 59 + ($initial == null ? 43 : $initial.hashCode());
        result = result * 59 + (this.isChosen() ? 79 : 97);
        Integer $roomSize = this.getRoomSize();
        result = result * 59 + ($roomSize == null ? 43 : ((Object)$roomSize).hashCode());
        result = result * 59 + (this.isDelStatus() ? 79 : 97);
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        result = result * 59 + this.getIsDefault();
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "ClassRoomDto(roomId=" + this.getRoomId() + ", orgId=" + this.getOrgId() + ", branchId=" + this.getBranchId() + ", roomNumber=" + this.getRoomNumber() + ", roomName=" + this.getRoomName() + ", initial=" + this.getInitial() + ", isChosen=" + this.isChosen() + ", roomSize=" + this.getRoomSize() + ", delStatus=" + this.isDelStatus() + ", createTime=" + this.getCreateTime() + ", isDefault=" + this.getIsDefault() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

