/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.room.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClassRoomServiceImpl
implements ClassRoomService {
    private static final Logger log = LoggerFactory.getLogger(ClassRoomServiceImpl.class);
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public ClassRoomDto saveOrUpdateClassRoom(Long orgId, ClassRoomDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        params.setOrgId(orgId);
        params.validate();
        OrgClassRoom classRoom = ClassRoomDto.converPo(params);
        if (params.getRoomId() != null && params.getRoomId() > 0L) {
            this.orgClassRoomDao.update((Object)classRoom, new String[0]);
        } else {
            if (classRoom.getBranchId() == null) {
                classRoom.setBranchId(Long.valueOf(0L));
            }
            this.orgClassRoomDao.save((Object)classRoom, new String[0]);
            params.setRoomId(classRoom.getId());
        }
        return params;
    }

    @Override
    public void delClassRoom(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        List lessons = this.orgClassLessonDao.getLeftRoomIdLessons(orgId, roomId, null, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u6559\u5ba4\u5df2\u5b89\u6392\u8bfe\u8282,\u8bf7\u5148\u53d8\u66f4\u8bfe\u8282\u6559\u5ba4");
        }
        this.orgCourseRoomDao.delCourseRoom(orgId, null, (Collection)Lists.newArrayList((Object[])new Long[]{roomId}));
        this.orgClassRoomDao.delById((Serializable)roomId);
    }

    @Override
    public List<ClassRoomDto> listOrgClassRooms(Long orgId, Long branchId, Long courseId, PageDto page) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        List classRooms = this.orgClassRoomDao.getClassRoom(orgId, branchId, Boolean.valueOf(false), page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)classRooms)) {
            ArrayList result = Lists.newArrayList();
            Set courseRoomIds = Sets.newHashSet();
            if (courseId != null) {
                courseRoomIds.addAll(this.orgCourseRoomDao.getCourseRoomIds(orgId, courseId));
            }
            for (OrgClassRoom classRoom : classRooms) {
                if (courseRoomIds.contains(classRoom.getId())) continue;
                result.add(ClassRoomDto.covert2Dto(classRoom));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void addClassRoomCourse(Long orgId, Long courseId, Collection<Long> roomIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("room ids is empty.");
            return;
        }
        log.info("add roomids:{} into course :{},orgId:{}", new Object[]{roomIds, courseId, orgId});
        List courseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
        boolean hasDefault = false;
        if (CollectionUtils.isNotEmpty((Collection)courseRooms)) {
            for (OrgCourseRoom courseRoom : courseRooms) {
                roomIds.remove(courseRoom.getRoomId());
                hasDefault |= courseRoom.isDefault();
            }
        }
        boolean bl = hasDefault = !hasDefault;
        if (CollectionUtils.isNotEmpty(roomIds)) {
            ArrayList saveCourseRooms = Lists.newArrayList();
            List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"orgId", "id", "delStatus"});
            OrgCourseRoom courseRoom = null;
            for (OrgClassRoom room : classRooms) {
                if (!orgId.equals(room.getOrgId()) || room.isDelStatus()) {
                    log.warn("room id :{} is not in current orgId:{}", (Object)room.getId(), (Object)room.getOrgId());
                    continue;
                }
                courseRoom = new OrgCourseRoom();
                courseRoom.setCourseId(courseId);
                courseRoom.setIsDefault(hasDefault);
                courseRoom.setOrgId(orgId);
                courseRoom.setRoomId(room.getId());
                hasDefault = false;
                saveCourseRooms.add(courseRoom);
            }
            log.debug("save course room :{}", (Object)saveCourseRooms);
            this.orgCourseRoomDao.saveAll((List)saveCourseRooms, new String[]{"courseId", "isDefault", "orgId", "roomId"});
        }
    }

    @Override
    public void delClassRoomFromCourse(Long orgId, Long courseId, Collection<Long> roomIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("room ids is empty.");
            return;
        }
        this.orgCourseRoomDao.delCourseRoom(orgId, courseId, roomIds);
        List lessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            int result = this.orgClassLessonDao.updateLessonClassRoom(orgId, (Collection)lessonIds, null);
            log.info("delete class room from lessonIds:{},result:{}", (Object)lessonIds, (Object)result);
        }
    }

    @Override
    public List<ClassRoomDto> listOrgCourseRooms(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List courseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)courseRooms)) {
            return Collections.emptyList();
        }
        Set roomIds = Sets.newHashSet();
        Long defaultRoomId = null;
        for (OrgCourseRoom courseRoom : courseRooms) {
            roomIds.add(courseRoom.getRoomId());
            if (!courseRoom.isDefault()) continue;
            defaultRoomId = courseRoom.getRoomId();
        }
        List classRooms = this.orgClassRoomDao.getByIds((Collection)roomIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)classRooms)) {
            ArrayList result = Lists.newArrayList();
            for (OrgClassRoom classRoom : classRooms) {
                ClassRoomDto dto = ClassRoomDto.covert2Dto(classRoom);
                if (classRoom.getId().equals(defaultRoomId)) {
                    dto.setIsDefault(1);
                }
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void courseRoomSeting(Long orgId, Long courseId, Long roomId, boolean enable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        log.info("set orgId:{} course:{} default room:{} : {}", new Object[]{orgId, courseId, roomId, enable});
        this.orgCourseRoomDao.courseDefaultRoomSet(orgId, courseId, roomId, enable);
    }

    @Override
    public ClassRoomDto info(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)roomId, new String[0]);
        Preconditions.checkArgument((classRoom != null && classRoom.getOrgId().equals(orgId) ? 1 : 0) != 0, (Object)"\u6559\u5ba4ID\u4e0d\u6b63\u786e");
        return ClassRoomDto.covert2Dto(classRoom);
    }
}

