/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.connect.route.api.model.TianxiaoConnectSession;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.push.api.PushApi;
import com.baijia.tianxiao.sal.push.dto.CommonMsgUser;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.LinkDeviceInfo;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.dto.PushDeviceBindVo;
import com.baijia.tianxiao.sal.push.dto.PushDeviceInfo;
import com.baijia.tianxiao.sal.push.enums.PlatformType;
import com.baijia.tianxiao.sal.push.service.MessageSendExecutor;
import com.baijia.tianxiao.sal.push.service.OrgService;
import com.baijia.tianxiao.sal.push.service.PushRedisService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sal.push.utils.MsgUserFactory;
import com.baijia.tianxiao.sal.push.utils.ParamUtil;
import com.baijia.tianxiao.util.ListUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageSendExecutorImpl
implements MessageSendExecutor {
    private static final Logger log = LoggerFactory.getLogger(MessageSendExecutorImpl.class);
    private ExecutorService threadPool = Executors.newCachedThreadPool();
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private UserCacheService cacheService;
    @Autowired
    private PushRedisService redisService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    private static final int MESSAGE_MAX_LENGTH = 1500;

    @Override
    public void sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message, Integer receiverId) {
        String uid;
        OrgSubAccount subAccount;
        TXCascadeAccount cascadeAccount;
        if (message.getContent() != null && message.getContent().length() > 1500) {
            log.warn("[Message] Content is too long.sender = {},receiver={},message={}", new Object[]{sender.getUserId(), receiver.getUserId(), message});
            return;
        }
        OrgCacheDto dto = this.cacheService.getOrg(receiver.getNumber());
        log.info("[Message] sender = {},receiver={},message={}", new Object[]{sender.getUserId(), receiver.getUserId(), message});
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)sender.getUserId(), new String[0]);
        int i = 1;
        while (consultUser == null && i <= 10) {
            try {
                Thread.sleep(i * 5 * 1000);
                consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)sender.getUserId(), new String[0]);
                log.warn("[Message] Retry count={},consultUserId={}", (Object)(++i), (Object)sender.getUserId());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String avatar = this.redisService.getAvatar(sender.getUserId());
        if (StringUtils.isBlank((String)avatar)) {
            this.consulterAPIService.batchSetConsultAvatarUrl(Arrays.asList(consultUser));
            this.redisService.setAvatar(sender.getUserId(), consultUser.getPortrait());
        }
        Integer cascadeId = null;
        Integer role = this.cacheService.getUserRole(consultUser);
        cascadeId = consultUser.getKefuId().intValue();
        if (role.intValue() == MsgUserRole.STUDENT.getValue()) {
            int headTeacher;
            long userId = 0L;
            ConsultUserCacheDto cacheDto = this.cacheService.getConsultUser(consultUser.getId());
            if (cacheDto != null) {
                userId = cacheDto.getUserId();
            }
            if ((headTeacher = this.getFirstHeadTeacher(dto.getOrgId(), userId, cascadeId).intValue()) > 0) {
                cascadeId = headTeacher;
            }
        } else if (role.intValue() == MsgUserRole.CLUE.getValue() && consultUser.getCascadeId() >= 0L) {
            cascadeId = consultUser.getCascadeId().intValue();
        }
        if (cascadeId > 0 && ((cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0])) == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1)) {
            log.warn("[Message] KefuId is invalid.CascadeId=" + cascadeId);
            cascadeId = -1;
        }
        if (cascadeId == 0 && (subAccount = this.orgService.getOrgAccountInfo(dto.getOrgId().intValue())) != null && (subAccount.getIsdel() == 1 || subAccount.getStatus() == 1)) {
            log.warn("[Message] KefuId is invalid.OrgId =" + dto.getOrgId());
            cascadeId = -1;
        }
        if (cascadeId < 0 && receiverId != null && receiverId >= 0) {
            cascadeId = receiverId;
            log.info("[Message] Given receiver,receiverId=" + receiverId);
        }
        List<TianxiaoConnectSession> userLinkDeviceInfoList = null;
        List<PushDeviceBindVo> userPushDeviceInfoList = null;
        if (cascadeId < 0) {
            log.info("[Message] No kefu.cascadeId=" + cascadeId);
            uid = ParamUtil.getUUID(receiver.getUserId(), null);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, "TX_PUSH");
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, "TX_PUSH");
            if (pushDeviceInfo == null || pushDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line push device");
            } else {
                userPushDeviceInfoList = pushDeviceInfo.getData();
            }
            if (linkDeviceInfo == null || linkDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line socket device");
            } else {
                userLinkDeviceInfoList = linkDeviceInfo.getData();
            }
            Map<Integer, List<TianxiaoConnectSession>> linkSessionUserMap = this.getLinkSessionMap(userLinkDeviceInfoList);
            Map<Integer, List<PushDeviceBindVo>> pushBindUserMap = this.getPushBindUserMap(userPushDeviceInfoList);
            ArrayList<Integer> onlineCascadeIds = new ArrayList<Integer>(linkSessionUserMap.keySet());
            onlineCascadeIds.addAll(pushBindUserMap.keySet());
            Integer nextId = this.cacheService.getKefuId(consultUser.getId());
            if (nextId == null || nextId < 0) {
                nextId = this.getNextKefuId(dto.getOrgId(), onlineCascadeIds);
                this.cacheService.setKefuId(consultUser.getId(), nextId);
            }
            if (nextId == 0) {
                message.setReceiverId(receiver.getNumber().longValue());
            } else {
                message.setReceiverId((long)nextId.intValue());
            }
            message.setReceiverRole(this.orgService.getOrgAccountType(dto.getOrgId(), nextId.intValue()).getValue());
            userLinkDeviceInfoList = linkSessionUserMap.get(nextId);
            userPushDeviceInfoList = pushBindUserMap.get(nextId);
            consultUser.setKefuId(Long.valueOf(nextId.longValue()));
            this.consultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
            this.redisService.addConsultUserCount(dto.getOrgId());
        } else {
            log.info("[Message] kefu cascadeId=" + cascadeId);
            uid = ParamUtil.getUUID(dto.getOrgId(), cascadeId);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, "TX_PUSH");
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, "TX_PUSH");
            if (pushDeviceInfo == null || pushDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line push device");
            } else {
                userPushDeviceInfoList = pushDeviceInfo.getData();
            }
            if (linkDeviceInfo == null || linkDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line socket device");
            } else {
                userLinkDeviceInfoList = linkDeviceInfo.getData();
            }
            message.setReceiverRole(this.orgService.getOrgAccountType(dto.getOrgId(), cascadeId.intValue()).getValue());
            if (cascadeId == 0) {
                message.setReceiverId(receiver.getNumber().longValue());
            } else {
                message.setReceiverId((long)cascadeId.intValue());
            }
            consultUser.setKefuId(Long.valueOf(cascadeId.longValue()));
            this.consultUserDao.update((Object)consultUser, Boolean.valueOf(false), new String[0]);
        }
        message.setSenderRole(this.cacheService.getUserRole(consultUser).intValue());
        message.setSenderId(consultUser.getId().longValue());
        message.setSenderNumber(Long.valueOf(sender.getNumber() == null ? 0L : sender.getNumber()));
        message.setOrgId(dto.getOrgId());
        log.info("\u63d2\u5165\u7684orgId param:{}", (Object)message.getOrgId());
        message.setCreateTime(new Date());
        Gson gson = new Gson();
        message.setContent(gson.toJson((Object)MsgContentFactory.getContent(message)));
        this.messageDao.insertMessage(message);
        this.threadPool.execute(new ConsultMessageTask(sender, message, userLinkDeviceInfoList, userPushDeviceInfoList));
    }

    private int getNextKefuId(Long orgId, List<Integer> onlineCascadeIds) {
        ArrayList<Integer> uniqueCascadeIds = new ArrayList<Integer>();
        for (Integer id : onlineCascadeIds) {
            if (uniqueCascadeIds.contains(id)) continue;
            uniqueCascadeIds.add(id);
        }
        List<Integer> orgCascadeIds = this.redisService.getCascadeIds(orgId);
        Integer count = this.redisService.getConsultUserCount(orgId);
        if (count == null || count == 0) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        Integer nextId = null;
        log.info("[Message] cascadeIds={},onlineCascadeIds={}", orgCascadeIds, onlineCascadeIds);
        for (int i = 0; i < orgCascadeIds.size(); ++i) {
            Integer index = (count + i) % orgCascadeIds.size();
            Integer tmpId = orgCascadeIds.get(index);
            log.info("[Message] index={},cascadeId={}", (Object)index, (Object)tmpId);
            if (!orgCascadeIds.contains(tmpId)) continue;
            nextId = tmpId;
            break;
        }
        if (nextId == null) {
            log.warn("[Message] No online device");
            if (orgCascadeIds.size() > 1) {
                Integer index = 1 + count % (orgCascadeIds.size() - 1);
                nextId = orgCascadeIds.get(index);
            } else {
                log.warn("[Message] No cascadeId");
                nextId = 0;
            }
        }
        log.info("[Message] Allocate to kefu =" + nextId);
        return nextId;
    }

    @Override
    public void sendStaffMsg(long orgId, Integer cascadeId, ConsultMessage message) {
        log.info("[StaffMsg] cascadeId={}\uff0cConsultMessage={}", (Object)cascadeId, (Object)message);
        CommonMsgUser sender = new CommonMsgUser();
        MsgUserRole senderRole = this.orgService.getOrgAccountType(orgId, cascadeId == null ? 0L : (long)cascadeId.intValue());
        log.info("[StaffMsg] senderType = " + senderRole);
        if (senderRole == MsgUserRole.BRANCH_HEADER || senderRole == MsgUserRole.HEADER) {
            Integer number = this.cacheService.getOrgNumber(orgId);
            message.setSenderId((long)number.intValue());
        } else {
            message.setSenderId((long)cascadeId.intValue());
        }
        message.setSenderRole(senderRole.getValue());
        long receiverId = message.getReceiverId();
        if (MsgUserRole.isHeader((int)message.getReceiverRole())) {
            receiverId = 0L;
        }
        MsgUserRole receiverRole = this.orgService.getOrgAccountType(orgId, receiverId);
        message.setReceiverRole(receiverRole.getValue());
        sender.setUserId(message.getSenderId());
        sender.setMsgUserRole(senderRole);
        message.setContent(message.getContent());
        if (!MsgUserRole.isOrg((int)message.getReceiverRole())) {
            throw new ParameterException();
        }
        message.setOrgId(Long.valueOf(orgId));
        log.info("\u63d2\u5165\u7684orgId param:{}", (Object)message.getOrgId());
        message.setCreateTime(new Date());
        this.messageDao.insertMessage(message);
        this.threadPool.execute(new StaffMessageTask(orgId, sender, message));
    }

    @Override
    public void sendNotice(Long orgId, Integer cascadeId, NoticeMsgContent message) {
        this.threadPool.execute(new NoticeTask(orgId, cascadeId, message));
    }

    private Map<Integer, List<TianxiaoConnectSession>> getLinkSessionMap(List<TianxiaoConnectSession> sessions) {
        HashMap<Integer, List<TianxiaoConnectSession>> sessionMap = new HashMap<Integer, List<TianxiaoConnectSession>>();
        if (sessions == null || sessions.size() < 1) {
            return Collections.emptyMap();
        }
        for (TianxiaoConnectSession session : sessions) {
            String uuid = session.getUserId();
            String[] strs = uuid.split("_");
            Integer cascadeId = 0;
            if (strs.length >= 2) {
                String cascadeIdStr = uuid.split("_")[1];
                cascadeId = Integer.parseInt(cascadeIdStr);
            }
            if (sessionMap.get(cascadeId) == null) {
                ArrayList<TianxiaoConnectSession> sessionList = new ArrayList<TianxiaoConnectSession>();
                sessionList.add(session);
                sessionMap.put(cascadeId, sessionList);
                continue;
            }
            ((List)sessionMap.get(cascadeId)).add(session);
        }
        return sessionMap;
    }

    private Map<Integer, List<PushDeviceBindVo>> getPushBindUserMap(List<PushDeviceBindVo> bindList) {
        HashMap<Integer, List<PushDeviceBindVo>> userDeviceBindMap = new HashMap<Integer, List<PushDeviceBindVo>>();
        if (bindList == null || bindList.size() < 1) {
            return Collections.emptyMap();
        }
        for (PushDeviceBindVo bindVo : bindList) {
            String uuid = bindVo.getUserId();
            String[] strs = uuid.split("_");
            Integer cascadeId = 0;
            if (strs.length >= 2) {
                String cascadeIdStr = uuid.split("_")[1];
                cascadeId = Integer.parseInt(cascadeIdStr);
            }
            if (userDeviceBindMap.get(cascadeId) == null) {
                ArrayList<PushDeviceBindVo> userBindList = new ArrayList<PushDeviceBindVo>();
                userBindList.add(bindVo);
                userDeviceBindMap.put(cascadeId, userBindList);
                continue;
            }
            ((List)userDeviceBindMap.get(cascadeId)).add(bindVo);
        }
        return userDeviceBindMap;
    }

    private PushTokenConfig buildConfig(TianxiaoConnectSession session) {
        PushTokenConfig config = new PushTokenConfig();
        config.setDeviceId(session.getDeviceId());
        config.setBiz_type("TX_PUSH");
        config.setDeviceType(PlatformType.getCode(session.getDeviceType()));
        return config;
    }

    private PushTokenConfig buildConfig(PushDeviceBindVo session) {
        PushTokenConfig config = new PushTokenConfig();
        config.setDeviceId(session.getDeviceId());
        config.setBiz_type("TX_PUSH");
        config.setDeviceType(PlatformType.getCode(session.getDeviceType()));
        return config;
    }

    private Integer getFirstHeadTeacher(Long orgId, Long userId, int kefuId) {
        List orgCourseIds = this.studentCourseDao.getOrgCourseIds(orgId, userId, null);
        List courseIds = ListUtil.toKeyList((Collection)orgCourseIds, (String)"courseId", OrgStudentCourse.class);
        List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"cascadeId"});
        int headTeacher = -1;
        if (courses != null || courses.size() > 1) {
            OrgCourse course;
            Iterator iterator = courses.iterator();
            while (iterator.hasNext() && ((course = (OrgCourse)iterator.next()).getCascadeId() == null || course.getCascadeId() < 0 || kefuId != (headTeacher = course.getCascadeId().intValue()))) {
            }
        }
        log.info("[Message] courses={},orgId={},userId={},kefuId={}", new Object[]{courses, orgId, userId, kefuId});
        return headTeacher;
    }

    private class NoticeTask
    implements Runnable {
        private Long orgId;
        private Integer cascadeId;
        private NoticeMsgContent content;

        public NoticeTask(Long orgId, Integer cascadeId, NoticeMsgContent content) {
            this.orgId = orgId;
            this.cascadeId = cascadeId;
            this.content = content;
        }

        @Override
        public void run() {
            log.info("[Notice] sendNotice,orgId={},cascadeId={},content = {}", new Object[]{this.orgId, this.cascadeId, ToStringBuilder.reflectionToString((Object)this.content)});
            Integer number = MessageSendExecutorImpl.this.cacheService.getOrgNumber(this.orgId);
            OrgCacheDto dto = MessageSendExecutorImpl.this.cacheService.getOrg(number.longValue());
            List sessions = null;
            List pushBindList = null;
            String uid = this.orgId + "_";
            if (this.cascadeId >= 0) {
                uid = ParamUtil.getUUID(this.orgId, this.cascadeId);
            }
            CommonMsgUser sender = MsgUserFactory.createSysUser();
            ConsultMessage message = this.getMessage(sender);
            PushConfig pushConfig = PushConfig.getNoticeConfig(this.content);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, "TX_PUSH");
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, "TX_PUSH");
            if (linkDeviceInfo != null && !CollectionUtils.sizeIsEmpty(linkDeviceInfo.getData()) || pushDeviceInfo != null && !CollectionUtils.sizeIsEmpty(pushDeviceInfo.getData())) {
                sessions = linkDeviceInfo.getData();
                pushBindList = pushDeviceInfo.getData();
                Map linkDeviceMap = MessageSendExecutorImpl.this.getLinkSessionMap(sessions);
                Map pushDeviceMap = MessageSendExecutorImpl.this.getPushBindUserMap(pushBindList);
                log.info("[Notice] link device cascadeIds=" + linkDeviceMap.keySet());
                log.info("[Notice] push device cascadeIds=" + pushDeviceMap.keySet());
                HashSet idset = new HashSet();
                idset.addAll(linkDeviceMap.keySet());
                idset.addAll(pushDeviceMap.keySet());
                for (Integer id : idset) {
                    PushTokenConfig tokenConfig;
                    if (id == 0) {
                        message.setReceiverId((long)number.intValue());
                    } else {
                        message.setReceiverId((long)id.intValue());
                    }
                    message.setReceiverRole(MessageSendExecutorImpl.this.orgService.getOrgAccountType(dto.getOrgId(), id.intValue()).getValue());
                    sessions = (List)linkDeviceMap.get(id);
                    if (sessions != null) {
                        for (TianxiaoConnectSession session : sessions) {
                            log.info("[Message] Notice;DeviceId={},userId={}", (Object)session.getDeviceId(), (Object)session.getUserId());
                            tokenConfig = MessageSendExecutorImpl.this.buildConfig(session);
                            tokenConfig.setUser_id(session.getUserId());
                            PushApi.sendMsg(message, sender, tokenConfig);
                        }
                    }
                    if ((pushBindList = (List)pushDeviceMap.get(id)) != null) {
                        for (PushDeviceBindVo bindVo : pushBindList) {
                            log.info("[Message] Notice;DeviceId={},userId={}", (Object)bindVo.getDeviceId(), (Object)bindVo.getUserId());
                            tokenConfig = MessageSendExecutorImpl.this.buildConfig(bindVo);
                            tokenConfig.setUser_id(bindVo.getUserId());
                            PushApi.pushMsg(pushConfig, tokenConfig);
                        }
                    }
                    message.setOrgId(this.orgId);
                    log.info("\u63d2\u5165\u7684orgId param:{}", (Object)message.getOrgId());
                    MessageSendExecutorImpl.this.messageDao.insertMessage(message);
                }
            } else {
                log.warn("[Notice] No on line device");
                log.info("[Notice] OrgId param:{},cascadeId={}", (Object)this.orgId, (Object)this.cascadeId);
                if (this.cascadeId >= 0) {
                    if (this.cascadeId == 0) {
                        message.setReceiverId((long)number.intValue());
                    } else {
                        message.setReceiverId((long)this.cascadeId.intValue());
                    }
                    message.setOrgId(this.orgId);
                    message.setReceiverRole(MessageSendExecutorImpl.this.orgService.getOrgAccountType(dto.getOrgId(), this.cascadeId.intValue()).getValue());
                    MessageSendExecutorImpl.this.messageDao.insertMessage(message);
                }
            }
        }

        private ConsultMessage getMessage(MsgUser sender) {
            ConsultMessage message = new ConsultMessage();
            message.setMsgType(MsgType.NOTICE.getValue());
            message.setConsultType(MessageSource.NOTICE.getValue());
            message.setCreateTime(new Date());
            Gson gson = new Gson();
            message.setContent(gson.toJson((Object)this.content));
            message.setSenderRole(MsgUserRole.SYSTEM.getValue());
            message.setSenderId(sender.getUserId().longValue());
            message.setSenderNumber(sender.getNumber());
            return message;
        }
    }

    private class StaffMessageTask
    implements Runnable {
        private long orgId;
        private ConsultMessage message;
        private MsgUser sender;

        public StaffMessageTask(long orgId, MsgUser sender, ConsultMessage message) {
            this.orgId = orgId;
            this.message = message;
            this.sender = sender;
        }

        @Override
        public void run() {
            PushTokenConfig tokenConfig;
            String uid = null;
            uid = MsgUserRole.isHeader((int)this.message.getReceiverRole()) ? ParamUtil.getUUID(this.orgId, 0) : ParamUtil.getUUID(this.orgId, (int)this.message.getReceiverId());
            String tip = PushConfig.tipMap.get(this.message.getConsultType());
            if (StringUtils.isBlank((String)tip)) {
                tip = "\u60a8\u6709\u4e00\u6761\u65b0\u6d88\u606f";
            }
            PushConfig pushConfig = PushConfig.getMsgConfig(tip, this.message.getSenderId(), this.message.getSenderRole());
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, "TX_PUSH");
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, "TX_PUSH");
            if (linkDeviceInfo != null && linkDeviceInfo.getCode() == 1 && linkDeviceInfo.getData() != null) {
                List<TianxiaoConnectSession> sessions = linkDeviceInfo.getData();
                for (TianxiaoConnectSession session : sessions) {
                    log.info("[Message] Staff message DeviceId={},userId={}", (Object)session.getDeviceId(), (Object)session.getUserId());
                    tokenConfig = MessageSendExecutorImpl.this.buildConfig(session);
                    tokenConfig.setUser_id(uid);
                    PushApi.sendMsg(this.message, this.sender, tokenConfig);
                }
            }
            if (pushDeviceInfo != null && pushDeviceInfo.getCode() == 1 && pushDeviceInfo.getData() != null) {
                List<PushDeviceBindVo> bindList = pushDeviceInfo.getData();
                for (PushDeviceBindVo bindVo : bindList) {
                    log.info("[Message] Staff message DeviceId={},userId={}", (Object)bindVo.getDeviceId(), (Object)bindVo.getUserId());
                    tokenConfig = MessageSendExecutorImpl.this.buildConfig(bindVo);
                    tokenConfig.setUser_id(uid);
                    PushApi.pushMsg(pushConfig, tokenConfig);
                }
            }
        }
    }

    private class ConsultMessageTask
    implements Runnable {
        private MsgUser sender;
        private ConsultMessage message;
        List<TianxiaoConnectSession> sessions;
        List<PushDeviceBindVo> pushDeviceBindList;

        public ConsultMessageTask(MsgUser sender, ConsultMessage message, List<TianxiaoConnectSession> sessions, List<PushDeviceBindVo> pushDeviceBindList) {
            this.sender = sender;
            this.message = message;
            this.sessions = sessions;
            this.pushDeviceBindList = pushDeviceBindList;
        }

        @Override
        public void run() {
            try {
                PushTokenConfig tokenConfig;
                String tip = PushConfig.tipMap.get(this.message.getConsultType());
                if (StringUtils.isBlank((String)tip)) {
                    tip = "\u60a8\u6709\u4e00\u6761\u65b0\u6d88\u606f";
                }
                PushConfig pushConfig = PushConfig.getMsgConfig(tip, this.message.getSenderId(), this.message.getSenderRole());
                if (this.sessions != null) {
                    for (TianxiaoConnectSession session : this.sessions) {
                        log.info("[Message] Send message,DeviceId={},userId={}", (Object)session.getDeviceId(), (Object)session.getUserId());
                        tokenConfig = MessageSendExecutorImpl.this.buildConfig(session);
                        tokenConfig.setUser_id(session.getUserId());
                        PushApi.sendMsg(this.message, this.sender, tokenConfig);
                    }
                }
                if (this.pushDeviceBindList != null) {
                    for (PushDeviceBindVo bind : this.pushDeviceBindList) {
                        log.info("[Message] Send message,DeviceId={},userId={}", (Object)bind.getDeviceId(), (Object)bind.getUserId());
                        tokenConfig = MessageSendExecutorImpl.this.buildConfig(bind);
                        tokenConfig.setUser_id(bind.getUserId());
                        PushApi.pushMsg(pushConfig, tokenConfig);
                    }
                }
            }
            catch (Exception e) {
                log.info("[Message] message = {}", (Object)this.message);
                log.error("[Message] Insert Exception.", (Throwable)e);
            }
        }
    }
}

