/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;

import com.google.common.collect.Sets;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年6月3日
 * @desc
 */
@Slf4j
@Service
public class ConsultAvatarUrlServiceImpl implements ConsultAvatarUrlService {

    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;

    @Override
    public ConsultAvatarUrlAndNameDto getConsultAvatarUrl(Long consultId) {
        ConsultAvatarUrlAndNameDto consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
        TxConsultUser txConsultUser = txConsultUserDao.getOrgConsultUser(consultId);
        log.info("consultAvatarUrlAndNameDto consultId:{},txConsultUser={}", consultId,txConsultUser);
        if(txConsultUser==null){
            throw new ParameterException();
        }
        consulterAPIService.batchSetConsultAvatarUrl(Arrays.asList(txConsultUser));
        consultAvatarUrlAndNameDto.setAvatarUrl(txConsultUser.getPortrait());
        consultAvatarUrlAndNameDto.setName(txConsultUser.getName());
        consultAvatarUrlAndNameDto.setMobile(txConsultUser.getMobile());
        return consultAvatarUrlAndNameDto;
    }
}
