/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.push.api.PushApi;
import com.baijia.tianxiao.sal.push.dto.BindInfo;
import com.baijia.tianxiao.sal.push.dto.BindRequest;
import com.baijia.tianxiao.sal.push.dto.ChannelRequest;
import com.baijia.tianxiao.sal.push.dto.PushBindChannel;
import com.baijia.tianxiao.sal.push.enums.ChannelType;
import com.baijia.tianxiao.sal.push.enums.PlatformType;
import com.baijia.tianxiao.sal.push.service.PushAuthorityService;
import com.baijia.tianxiao.sal.push.utils.ParamUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushAuthorityServiceImpl
implements PushAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(PushAuthorityServiceImpl.class);

    @Override
    public String getToken(String deviceId, int deviceType, int deviceDomain, Long orgId, Integer cascadeId) {
        PushTokenConfig config = new PushTokenConfig();
        String tokenStr = null;
        config.setDeviceType(Integer.valueOf(deviceType));
        config.setDeviceId(deviceId);
        config.setDevice_domain(Integer.valueOf(deviceDomain));
        config.setBiz_type("TX_PUSH");
        if (cascadeId == null) {
            cascadeId = 0;
        }
        config.setUser_id(ParamUtil.getUUID(orgId, cascadeId));
        try {
            tokenStr = EncryptUtils.pushTokenEncode((PushTokenConfig)config);
        }
        catch (Exception e) {
            log.error("[Token] Generate token exception.", (Throwable)e);
        }
        return tokenStr;
    }

    @Override
    public void bind(BindRequest request, long orgId, Integer subAccountId) {
        log.debug("[Push] Bind param:request {},orgId = {},cascadeId={}", new Object[]{request, orgId, subAccountId});
        Gson gson = new Gson();
        BindInfo bindInfo = this.buildBindInfo(request, orgId, subAccountId);
        List channelRequestList = (List)gson.fromJson(request.getChannels(), new TypeToken<List<ChannelRequest>>(){}.getType());
        bindInfo.setChannelList(this.buildChannels(channelRequestList, bindInfo.getDeviceType()));
        PushApi.bind(bindInfo);
    }

    public List<PushBindChannel> buildChannels(List<ChannelRequest> channelList, String deviceType) {
        ArrayList<PushBindChannel> channels = new ArrayList<PushBindChannel>();
        if (channelList != null) {
            for (ChannelRequest request : channelList) {
                PushBindChannel channel = new PushBindChannel();
                channel.setDeviceToken(request.getDeviceToken());
                channel.setChannelType(ChannelType.getName(request.getChannelType()));
                channel.setAppId("1234");
                channel.setDevelopStatus(request.getDevelopStatus());
                if (StringUtils.equals((CharSequence)deviceType, (CharSequence)PlatformType.IOS.getName())) {
                    channel.setDeployStatus(request.getDeployStatus());
                }
                channels.add(channel);
            }
        }
        return channels;
    }

    public BindInfo buildBindInfo(BindRequest request, long orgId, Integer cascadeId) {
        BindInfo info = new BindInfo();
        info.setUserType("TX_PUSH");
        if (cascadeId == null) {
            cascadeId = 0;
        }
        info.setUserId(ParamUtil.getUUID(orgId, cascadeId));
        info.setDeviceId(request.getDeviceId());
        info.setDeviceType(PlatformType.getName(request.getDeviceType()));
        return info;
    }

    @Override
    public void unbind(BindInfo bindInfo, long orgId, Integer cascadeId) {
        bindInfo.setUserType("TX_PUSH");
        if (cascadeId == null) {
            cascadeId = 0;
        }
        bindInfo.setUserId(ParamUtil.getUUID(orgId, cascadeId));
        PushApi.unBind(bindInfo);
    }
}

