package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by liuxp on 15/12/11.
 */
@Slf4j
@Service
public class UserServiceCacheImpl implements UserCacheService {
    @Autowired
    private OrgAccountDao accountDao;
    @Autowired
    private TxConsultUserDao userDao;
    @Autowired
    private AuthorizationInfoDao orgWechatDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentDao studentDao;

    private static Cache<Long, ConsultUserCacheDto> userCache = CacheBuilder
            .newBuilder()
            .maximumSize(10000)
            .expireAfterAccess(1, TimeUnit.HOURS)
            .build();

    private static Cache<Long, OrgCacheDto> orgCache = CacheBuilder
            .newBuilder()
            .maximumSize(1000)
            .expireAfterAccess(1, TimeUnit.DAYS)
            .build();

    private static Cache<Long, Integer> orgNumberCache = CacheBuilder
            .newBuilder()
            .maximumSize(1000)
            .expireAfterAccess(1, TimeUnit.DAYS)
            .build();

    private static Cache<Long, Integer> consultUserKefu = CacheBuilder
            .newBuilder()
            .maximumSize(1000)
            .expireAfterAccess(1, TimeUnit.MINUTES)
            .build();

    public ConsultUserCacheDto getConsultUser(Long consultUserId) {
        ConsultUserCacheDto user = userCache.getIfPresent(consultUserId);
        log.info("getConsultUser---------ConsultUserCacheDto user={}", user);
        if (user == null) {
            user = new ConsultUserCacheDto();
            TxConsultUser consultUser = userDao.getById(consultUserId);
            log.info("getConsultUser---------TxConsultUser consultUser={}", consultUser);
            if (consultUser != null) {
                if (consultUser.getUserNumber() != null) {
                    user.setNumber(consultUser.getUserNumber().intValue());
                }
                user.setWechatOpenId(consultUser.getWeixinOpenId());
                user.setUserId(consultUser.getUserId());
                OrgStudent orgStudent = orgStudentDao.getById(consultUser.getStudentId());
                log.info("[StudentId]" + orgStudent);
                if (orgStudent != null && orgStudent.getDelStatus()==0) {
                    user.setStudentId(orgStudent.getId());
                    user.setUserId(orgStudent.getUserId());
                    log.info("[StudentId]" + orgStudent.getId());
                }
                userCache.put(consultUserId, user);
            } else {
                log.warn("[ConsultUser] User is not exist.consultUserId = " + consultUserId);
            }
        }
        return user;
    }

    public OrgCacheDto getOrg(Long number) {
        OrgCacheDto org = orgCache.getIfPresent(number);
        if (org == null) {
            OrgAccount account = accountDao.getAccountByNumber(number.intValue(), "id");
            if (account != null) {
                org = new OrgCacheDto();
                org.setOrgId(account.getId().longValue());
                orgNumberCache.put(account.getId().longValue(), number.intValue());
                AuthorizationInfo auth = orgWechatDao.getByOrgId(account.getId());
                if (auth != null) {
                    org.setWechatAppId(auth.getAuthorizerAppId());
                    orgCache.put(number, org);
                } else {
                    log.warn("[Org] Authorization is invalidate.ID = " + account.getId());
                }
            } else {
                log.warn("[Org] Org is not exist.number = " + number);
            }
        }
        return org;
    }

    @Override
    public Integer getOrgNumber(Long orgId) {
        if (orgId == null) {
            log.warn("[Org] OrgId is null");
            return null;
        }
        Integer number = orgNumberCache.getIfPresent(orgId);
        if (number == null) {
            OrgAccount account = accountDao.getAccountById(orgId.intValue(), "number");
            if (account != null) {
                number = account.getNumber();
                orgNumberCache.put(orgId, number);
            } else {
                log.warn("[Org] Org is not exist.orgId = " + orgId);
            }
        }
        return number;
    }

    @Override
    public Long getUserIdFromDb(Long consultUserId) {
        TxConsultUser consultUser = userDao.getById(consultUserId);
        if (consultUser != null) {
            //设置缓存信息
            ConsultUserCacheDto user = getConsultUser(consultUserId);
            user.setUserId(consultUser.getUserId());
            if (consultUser.getUserNumber() != null) {
                user.setNumber(consultUser.getUserNumber().intValue());
            }
            consultUser.getUserId();
        }
        return null;
    }

    @Override
    public Long getStudentIdFromDb(Long consultUserId, Long orgId) {
        ConsultUserCacheDto user = getConsultUser(consultUserId);
        if (user.getUserId() == null) {
            Long userId = getUserIdFromDb(consultUserId);
            if (userId != null) {
                OrgStudent orgStudent = orgStudentDao.getStudent(orgId, userId, null);
                if (orgStudent != null) {
                    user.setStudentId(orgStudent.getId());
                    return orgStudent.getId();
                }
            }
        }
        return null;
    }

    public Integer getUserRole(TxConsultUser user) {
        log.info("[UserRole] param user="+user);
        MsgUserRole userType = null;
        if (user.getStudentId() != null && user.getStudentId() > 0) {
            userType = MsgUserRole.STUDENT;
        } else {
            if (user.getUserId() != null && user.getUserId() > 0) {
                OrgStudent student = studentDao.getStudent(user.getOrgId(),user.getUserId(),DeleteStatus.NORMAL.getValue());
                if (student != null) {
                    userType = MsgUserRole.STUDENT;
                    user.setStudentId(student.getId());
                    user.setUserId(student.getUserId());
                }
            }
        }

        if (userType == null) {
            if (user.getIsConsulter() == 1) {
                userType = MsgUserRole.CLUE;
            } else {
                userType = MsgUserRole.CONSULT;
            }
        }

        return userType.getValue();
    }

    @Override
    public Integer getKefuId(long consultUserId) {
        return consultUserKefu.getIfPresent(consultUserId);
    }

    @Override
    public void setKefuId(long consultUserId, Integer kefuId) {
        consultUserKefu.put(consultUserId,kefuId);
    }
}
