package com.baijia.tianxiao.sal.push.utils;

import com.baijia.tianxiao.constants.CommonConfig;
import com.baijia.tianxiao.sal.push.constant.MsgConstant;
import com.baijia.tianxiao.util.rest.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 15/12/3.
 */
public class ParamUtil {
    private static final Logger logger = LoggerFactory.getLogger(ParamUtil.class);

    public static Map<String, String> constructBatchAppPushParams(Map<String, String> entry, String token) {
        Map<String, String> params = null;
        try {
            params = getCommonParam(token);
            String appKey = CommonConfig.SERVICE_APP_KEY;
            params.put("message", entry.get("msg"));
            params.put("sendWay", MsgConstant.SEND_WAY);
            params.put("messageType", MsgConstant.MESSAGE_TYPE);
            params.put("bizMessageType", MsgConstant.BIZ_MESSAGE_TYPE);
            params.put("batchUserIds", entry.get("batchUserIds"));
            params.put("role", entry.get("role"));
            params.put("detail", entry.get("detail"));
            params.put("trace_code", MsgConstant.APP_PUSH_TRACE_CODE_PREFIX + entry.get("code"));

            String signData = RestUtils.createSignData("post", "message", "send", null, params);
            String sign = RestUtils.getSignature(signData.getBytes("UTF-8"), appKey.getBytes("UTF-8"));
            params.put("sign", sign);
            logger.info("<params>=" + params);
        } catch (Exception e) {
            logger.error("[Param] Param parse exception.", e);
        }
        return params;
    }

    private static Map<String, String> getCommonParam(String token) {
        Map<String, String> params = new HashMap<>();
        String appId = CommonConfig.SERVICE_APP_ID;
        params.put("app_id", appId);
        params.put("auth_token", token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("fast", "1");
        return params;
    }

    public static String getUUID(Long orgId, Integer subAccountId) {
        StringBuilder builder = new StringBuilder();
        builder.append(orgId).append("_");
        if (subAccountId != null) {
            builder.append(subAccountId);
        }

        return builder.toString();
    }
}
