package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.connect.route.api.model.TianxiaoConnectSession;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.push.api.PushApi;
import com.baijia.tianxiao.sal.push.constant.PushConstant;
import com.baijia.tianxiao.sal.push.dto.*;
import com.baijia.tianxiao.sal.push.enums.PlatformType;
import com.baijia.tianxiao.sal.push.service.MessageSendExecutor;
import com.baijia.tianxiao.sal.push.service.OrgService;
import com.baijia.tianxiao.sal.push.service.PushRedisService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sal.push.utils.MsgUserFactory;
import com.baijia.tianxiao.sal.push.utils.ParamUtil;
import com.baijia.tianxiao.util.ListUtil;
import com.google.gson.Gson;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/6/13.
 */
@Service
@Slf4j
public class MessageSendExecutorImpl implements MessageSendExecutor {

    private ExecutorService threadPool = Executors.newCachedThreadPool();
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private UserCacheService cacheService;
    @Autowired
    private PushRedisService redisService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    
    @Autowired
    private ConsulterAPIService consulterAPIService;

    private final static int MESSAGE_MAX_LENGTH = 1500;

    /**
     * 给机构发送信息，包括IM聊天信息和推送
     *
     * @param sender     发送方，学员（咨询、线索、正式学员）
     * @param receiver   接收方，机构
     * @param message    消息体
     * @param receiverId 指定接收人
     */
    @Override
    public void sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message, Integer receiverId) {

        if(message.getContent()!=null && message.getContent().length()>MESSAGE_MAX_LENGTH){
            log.warn("[Message] Content is too long.sender = {},receiver={},message={}", sender.getUserId(), receiver.getUserId(), message);
            return;
        }

        OrgCacheDto dto = cacheService.getOrg(receiver.getNumber());
        log.info("[Message] sender = {},receiver={},message={}", sender.getUserId(), receiver.getUserId(), message);
        TxConsultUser consultUser = consultUserDao.getById(sender.getUserId());
        int i = 1;
        while (consultUser==null && i<=10){
            try {
                Thread.sleep(i*5*1000);
                consultUser = consultUserDao.getById(sender.getUserId());
                i++;
                log.warn("[Message] Retry count={},consultUserId={}",i,sender.getUserId());
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String avatar = redisService.getAvatar(sender.getUserId());
        if(StringUtils.isBlank(avatar)){
            redisService.setAvatar(sender.getUserId());
        }

        Integer cascadeId = null;

        Integer role = cacheService.getUserRole(consultUser);

        cascadeId = consultUser.getKefuId().intValue();

        //如果是学员，分给班主任
        if (role == MsgUserRole.STUDENT.getValue()) {
            long userId = 0;
            ConsultUserCacheDto cacheDto = cacheService.getConsultUser(consultUser.getId());
            if(cacheDto!=null){
                userId = cacheDto.getUserId();
            }
            int headTeacher = getFirstHeadTeacher(dto.getOrgId(), userId, cascadeId);
            if (headTeacher > 0) {
                cascadeId = headTeacher;
            }
        } else if (role == MsgUserRole.CLUE.getValue() && consultUser.getCascadeId() >= 0) {//线索分给所属人
            cascadeId = consultUser.getCascadeId().intValue();
        }

        if (cascadeId > 0) {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getById(cascadeId);
            //如果账号已删除或停用，则重新制定客服
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Message] KefuId is invalid.CascadeId=" + cascadeId);
                cascadeId = -1;
            }
        }

        if (cascadeId == 0) {
            OrgSubAccount subAccount = orgService.getOrgAccountInfo(dto.getOrgId().intValue());
            if (subAccount != null) {
                if (subAccount.getIsdel() == 1 || subAccount.getStatus() == 1) {
                    log.warn("[Message] KefuId is invalid.OrgId =" + dto.getOrgId());
                    cascadeId = -1;
                }
            }
        }
        if (cascadeId < 0 && receiverId!=null && receiverId>=0) {
            cascadeId = receiverId;
            log.info("[Message] Given receiver,receiverId=" + receiverId);
        }

        List<TianxiaoConnectSession> userLinkDeviceInfoList = null;

        List<PushDeviceBindVo> userPushDeviceInfoList = null;
        //cascadeId>0 为子账号，=0为主账号，<0则说明没有人跟进
        if (cascadeId < 0) {
            log.info("[Message] No kefu.cascadeId=" + cascadeId);

            String uid = ParamUtil.getUUID(receiver.getUserId(), null);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            //没有可接收消息的设备
            if (pushDeviceInfo == null || pushDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line push device");
            } else {
                userPushDeviceInfoList = pushDeviceInfo.getData();
            }

            if (linkDeviceInfo == null || linkDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line socket device");

            } else {
                userLinkDeviceInfoList = linkDeviceInfo.getData();
            }

            Map<Integer, List<TianxiaoConnectSession>> linkSessionUserMap = getLinkSessionMap(userLinkDeviceInfoList);
            Map<Integer, List<PushDeviceBindVo>> pushBindUserMap = getPushBindUserMap(userPushDeviceInfoList);
            List<Integer> onlineCascadeIds = new ArrayList<>(linkSessionUserMap.keySet());
            onlineCascadeIds.addAll(pushBindUserMap.keySet());

            Integer nextId = cacheService.getKefuId(consultUser.getId());

            if (nextId == null || nextId < 0) {
                nextId = getNextKefuId(dto.getOrgId(), onlineCascadeIds);
                cacheService.setKefuId(consultUser.getId(), nextId);
            }

            if (nextId == 0) {
                message.setReceiverId(receiver.getNumber());
            } else {
                message.setReceiverId(nextId);
            }
            message.setReceiverRole(orgService.getOrgAccountType(dto.getOrgId(), nextId).getValue());
            userLinkDeviceInfoList = linkSessionUserMap.get(nextId);
            userPushDeviceInfoList = pushBindUserMap.get(nextId);
            consultUser.setKefuId(nextId.longValue());
            consultUserDao.update(consultUser, false);
            //consulterAPIService.updateKefuId(consultUser, nextId.longValue());
            redisService.addConsultUserCount(dto.getOrgId());
        } else {
            log.info("[Message] kefu cascadeId=" + cascadeId);
            String uid = ParamUtil.getUUID(dto.getOrgId(), cascadeId);
            //DeviceInfo deviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            //没有可接收消息的设备
            if (pushDeviceInfo == null || pushDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line push device");
            } else {
                userPushDeviceInfoList = pushDeviceInfo.getData();
            }

            if (linkDeviceInfo == null || linkDeviceInfo.getCode() != 1) {
                log.warn("[Message] No on line socket device");

            } else {
                userLinkDeviceInfoList = linkDeviceInfo.getData();
            }
            message.setReceiverRole(orgService.getOrgAccountType(dto.getOrgId(), cascadeId).getValue());
            if (cascadeId == 0) {
                message.setReceiverId(receiver.getNumber());
            } else {
                message.setReceiverId(cascadeId);
            }
            consultUser.setKefuId(cascadeId.longValue());
            consultUserDao.update(consultUser, false);
            //consulterAPIService.updateKefuId(consultUser, cascadeId.longValue());
        }

        message.setSenderRole(cacheService.getUserRole(consultUser));
        message.setSenderId(consultUser.getId());
        message.setSenderNumber(sender.getNumber() == null ? 0l : sender.getNumber());

        message.setOrgId(dto.getOrgId());
        log.info("插入的orgId param:{}", message.getOrgId());
        message.setCreateTime(new Date());
        Gson gson = new Gson();
        message.setContent(gson.toJson(MsgContentFactory.getContent(message)));
        messageDao.insertMessage(message);
        threadPool.execute(new ConsultMessageTask(sender, message, userLinkDeviceInfoList, userPushDeviceInfoList));
    }

    /**
     * 消息分配的客服
     *
     * @param orgId
     * @param onlineCascadeIds
     * @return
     */
    private int getNextKefuId(Long orgId, List<Integer> onlineCascadeIds) {

        List<Integer> uniqueCascadeIds = new ArrayList<>();

        for (Integer id:onlineCascadeIds){
            if (!uniqueCascadeIds.contains(id)){
                uniqueCascadeIds.add(id);
            }
        }

        List<Integer> orgCascadeIds = redisService.getCascadeIds(orgId);
        //orgCascadeIds.add(0, 0);
        Integer count = redisService.getConsultUserCount(orgId);
        if (count == null || count == 0) {
            count = 1;
        } else {
            count++;
        }
        //轮询分配在线用户信息
        Integer nextId = null;
        log.info("[Message] cascadeIds={},onlineCascadeIds={}", orgCascadeIds, onlineCascadeIds);

        //顺序分配给在线客服
        for (int i = 0; i < orgCascadeIds.size(); i++) {
            Integer index = (count + i) % orgCascadeIds.size();
            Integer tmpId = orgCascadeIds.get(index);
            log.info("[Message] index={},cascadeId={}", index, tmpId);
            if (orgCascadeIds.contains(tmpId)) {
                nextId = tmpId;
                break;
            }
        }

        //如果没有在线客服，则顺序分配给子账号
        if (nextId == null) {
            log.warn("[Message] No online device");
            if (orgCascadeIds.size() > 1) {
                Integer index = 1 + count % (orgCascadeIds.size() - 1);
                nextId = orgCascadeIds.get(index);
            } else {
                //没有子账号
                log.warn("[Message] No cascadeId");
                nextId = 0;
            }
        }
        log.info("[Message] Allocate to kefu =" + nextId);
        return nextId;
    }


    @Override
    public void sendStaffMsg(long orgId, Integer cascadeId, ConsultMessage message) {
        log.info("[StaffMsg] cascadeId={}，ConsultMessage={}", cascadeId, message);
        CommonMsgUser sender = new CommonMsgUser();
        MsgUserRole senderRole = orgService.getOrgAccountType(orgId, cascadeId == null ? 0 : cascadeId);
        log.info("[StaffMsg] senderType = " + senderRole);
        if (senderRole == MsgUserRole.BRANCH_HEADER || senderRole == MsgUserRole.HEADER) {
            Integer number = cacheService.getOrgNumber(orgId);
            message.setSenderId(number);
        } else {
            message.setSenderId(cascadeId);
        }
        message.setSenderRole(senderRole.getValue());

        long receiverId = message.getReceiverId();
        if (MsgUserRole.isHeader(message.getReceiverRole())) {
            receiverId = 0l;
        }

        MsgUserRole receiverRole = orgService.getOrgAccountType(orgId, receiverId);
        message.setReceiverRole(receiverRole.getValue());

        sender.setUserId(message.getSenderId());
        sender.setMsgUserRole(senderRole);

        message.setContent(message.getContent());
        if (!MsgUserRole.isOrg(message.getReceiverRole())) {
            throw new ParameterException();
        }
        message.setOrgId(orgId);
        log.info("插入的orgId param:{}", message.getOrgId());
        message.setCreateTime(new Date());
        messageDao.insertMessage(message);
        threadPool.execute(new StaffMessageTask(orgId, sender, message));
    }

    @Override
    public void sendNotice(Long orgId, Integer cascadeId, NoticeMsgContent message) {
        threadPool.execute(new NoticeTask(orgId, cascadeId, message));
    }

    private class ConsultMessageTask implements Runnable {

        private MsgUser sender;
        private ConsultMessage message;
        List<TianxiaoConnectSession> sessions;
        List<PushDeviceBindVo> pushDeviceBindList;

        public ConsultMessageTask(MsgUser sender, ConsultMessage message, List<TianxiaoConnectSession> sessions, List<PushDeviceBindVo> pushDeviceBindList) {
            this.sender = sender;
            this.message = message;
            this.sessions = sessions;
            this.pushDeviceBindList = pushDeviceBindList;
        }

        @Override
        public void run() {
            try {
                String tip = PushConfig.tipMap.get(message.getConsultType());
                if (StringUtils.isBlank(tip)) {
                    tip = "您有一条新消息";
                }
                PushConfig pushConfig = PushConfig.getMsgConfig(tip, message.getSenderId(), message.getSenderRole());
                if (sessions != null) {
                    for (TianxiaoConnectSession session : sessions) {
                        log.info("[Message] Send message,DeviceId={},userId={}", session.getDeviceId(), session.getUserId());
                        PushTokenConfig tokenConfig = buildConfig(session);
                        tokenConfig.setUser_id(session.getUserId());
                        PushApi.sendMsg(message, sender, tokenConfig);
                    }
                }
                if (pushDeviceBindList != null) {
                    for (PushDeviceBindVo bind : pushDeviceBindList) {
                        log.info("[Message] Send message,DeviceId={},userId={}", bind.getDeviceId(), bind.getUserId());
                        PushTokenConfig tokenConfig = buildConfig(bind);
                        tokenConfig.setUser_id(bind.getUserId());
                        PushApi.pushMsg(pushConfig, tokenConfig);
                    }
                }
            } catch (Exception e) {
                log.info("[Message] message = {}", message);
                log.error("[Message] Insert Exception.", e);
            }
        }
    }

    private class StaffMessageTask implements Runnable {
        private long orgId;
        private ConsultMessage message;
        private MsgUser sender;

        public StaffMessageTask(long orgId, MsgUser sender, ConsultMessage message) {
            this.orgId = orgId;
            this.message = message;
            this.sender = sender;
        }

        @Override
        public void run() {
            String uid = null;
            if (MsgUserRole.isHeader(message.getReceiverRole())) {
                uid = ParamUtil.getUUID(orgId, 0);
            } else {
                uid = ParamUtil.getUUID(orgId, (int) message.getReceiverId());
            }

            String tip = PushConfig.tipMap.get(message.getConsultType());
            if (StringUtils.isBlank(tip)) {
                tip = "您有一条新消息";
            }
            PushConfig pushConfig = PushConfig.getMsgConfig(tip, message.getSenderId(), message.getSenderRole());

            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            if (linkDeviceInfo != null && linkDeviceInfo.getCode() == 1 && linkDeviceInfo.getData() != null) {
                List<TianxiaoConnectSession> sessions = linkDeviceInfo.getData();
                for (TianxiaoConnectSession session : sessions) {
                    log.info("[Message] Staff message DeviceId={},userId={}", session.getDeviceId(), session.getUserId());
                    PushTokenConfig tokenConfig = buildConfig(session);
                    tokenConfig.setUser_id(uid);
                    PushApi.sendMsg(message, sender, tokenConfig);
                }
            }
            if (pushDeviceInfo != null && pushDeviceInfo.getCode() == 1 && pushDeviceInfo.getData() != null) {
                List<PushDeviceBindVo> bindList = pushDeviceInfo.getData();
                for (PushDeviceBindVo bindVo : bindList) {
                    log.info("[Message] Staff message DeviceId={},userId={}", bindVo.getDeviceId(), bindVo.getUserId());
                    PushTokenConfig tokenConfig = buildConfig(bindVo);
                    tokenConfig.setUser_id(uid);
                    PushApi.pushMsg(pushConfig, tokenConfig);
                }
            }
        }
    }

    private class NoticeTask implements Runnable {
        private Long orgId;
        private Integer cascadeId;
        private NoticeMsgContent content;

        public NoticeTask(Long orgId, Integer cascadeId, NoticeMsgContent content) {
            this.orgId = orgId;
            this.cascadeId = cascadeId;
            this.content = content;
        }

        @Override
        public void run() {
            log.info("[Notice] sendNotice,orgId={},cascadeId={},content = {}", orgId, cascadeId, ToStringBuilder.reflectionToString(content));
            Integer number = cacheService.getOrgNumber(orgId);
            OrgCacheDto dto = cacheService.getOrg(number.longValue());
            List<TianxiaoConnectSession> sessions = null;
            List<PushDeviceBindVo> pushBindList = null;
            String uid = orgId + "_";
            if (cascadeId >= 0) {
                uid = ParamUtil.getUUID(orgId, cascadeId);
            }

            MsgUser sender = MsgUserFactory.createSysUser();
            ConsultMessage message = getMessage(sender);

            // DeviceInfo deviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            PushConfig pushConfig = PushConfig.getNoticeConfig(content);
            PushDeviceInfo pushDeviceInfo = PushApi.getPushDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            LinkDeviceInfo linkDeviceInfo = PushApi.getLinkPlatformDeviceList(uid, PushConstant.PUSH_BIZ_TYPE);
            if (linkDeviceInfo == null || linkDeviceInfo.getCode() != 1 || pushDeviceInfo == null || pushDeviceInfo.getCode() != 1) {
                log.warn("[Notice] No on line device");
            } else {
                sessions = linkDeviceInfo.getData();
                pushBindList = pushDeviceInfo.getData();
                Map<Integer, List<TianxiaoConnectSession>> linkDeviceMap = getLinkSessionMap(sessions);
                Map<Integer, List<PushDeviceBindVo>> pushDeviceMap = getPushBindUserMap(pushBindList);
                log.info("[Notice] link device cascadeIds=" + linkDeviceMap.keySet());
                log.info("[Notice] push device cascadeIds=" + pushDeviceMap.keySet());
                Set<Integer> idset = new HashSet<Integer>();
                idset.addAll(linkDeviceMap.keySet());
                idset.addAll(pushDeviceMap.keySet());
                for (Iterator<Integer> iter = idset.iterator(); iter.hasNext(); ) {
                    Integer id = iter.next();
                    if (id == 0) {
                        message.setReceiverId(number);
                    } else {
                        message.setReceiverId(id);
                    }
                    message.setReceiverRole(orgService.getOrgAccountType(dto.getOrgId(), id).getValue());
                    sessions = linkDeviceMap.get(id);
                    if (sessions != null) {
                        for (TianxiaoConnectSession session : sessions) {
                            log.info("[Message] Notice;DeviceId={},userId={}", session.getDeviceId(), session.getUserId());
                            PushTokenConfig tokenConfig = buildConfig(session);
                            tokenConfig.setUser_id(session.getUserId());
                            PushApi.sendMsg(message, sender, tokenConfig);
                        }
                    }

                    pushBindList = pushDeviceMap.get(id);
                    if (pushBindList != null) {
                        for (PushDeviceBindVo bindVo : pushBindList) {
                            log.info("[Message] Notice;DeviceId={},userId={}", bindVo.getDeviceId(), bindVo.getUserId());
                            PushTokenConfig tokenConfig = buildConfig(bindVo);
                            tokenConfig.setUser_id(bindVo.getUserId());
                            PushApi.pushMsg(pushConfig, tokenConfig);
                        }
                    }
                    message.setOrgId(orgId);
                    log.info("插入的orgId param:{}", message.getOrgId());
                    messageDao.insertMessage(message);
                }
            }
        }

        private ConsultMessage getMessage(MsgUser sender) {
            ConsultMessage message = new ConsultMessage();
            message.setMsgType(MsgType.NOTICE.getValue());
            message.setConsultType(MessageSource.NOTICE.getValue());
            message.setCreateTime(new Date());
            Gson gson = new Gson();
            message.setContent(gson.toJson(content));
            message.setSenderRole(MsgUserRole.SYSTEM.getValue());
            message.setSenderId(sender.getUserId());
            message.setSenderNumber(sender.getNumber());
            return message;
        }
    }

    private Map<Integer, List<TianxiaoConnectSession>> getLinkSessionMap(List<TianxiaoConnectSession> sessions) {
        Map<Integer, List<TianxiaoConnectSession>> sessionMap = new HashMap();
        if (sessions == null || sessions.size() < 1) {
            return Collections.emptyMap();
        }
        for (TianxiaoConnectSession session : sessions) {
            String uuid = session.getUserId();
            String[] strs = uuid.split("_");
            Integer cascadeId = 0;
            if (strs.length >= 2) {
                String cascadeIdStr = uuid.split("_")[1];
                cascadeId = Integer.parseInt(cascadeIdStr);
            }
            if (sessionMap.get(cascadeId) == null) {
                List<TianxiaoConnectSession> sessionList = new ArrayList<>();
                sessionList.add(session);
                sessionMap.put(cascadeId, sessionList);
            } else {
                sessionMap.get(cascadeId).add(session);
            }
        }
        return sessionMap;
    }

    private Map<Integer, List<PushDeviceBindVo>> getPushBindUserMap(List<PushDeviceBindVo> bindList) {
        Map<Integer, List<PushDeviceBindVo>> userDeviceBindMap = new HashMap();
        if (bindList == null || bindList.size() < 1) {
            return Collections.emptyMap();
        }
        for (PushDeviceBindVo bindVo : bindList) {
            String uuid = bindVo.getUserId();
            String[] strs = uuid.split("_");
            Integer cascadeId = 0;
            if (strs.length >= 2) {
                String cascadeIdStr = uuid.split("_")[1];
                cascadeId = Integer.parseInt(cascadeIdStr);
            }
            if (userDeviceBindMap.get(cascadeId) == null) {
                List<PushDeviceBindVo> userBindList = new ArrayList<>();
                userBindList.add(bindVo);
                userDeviceBindMap.put(cascadeId, userBindList);
            } else {
                userDeviceBindMap.get(cascadeId).add(bindVo);
            }
        }
        return userDeviceBindMap;
    }

    private PushTokenConfig buildConfig(TianxiaoConnectSession session) {
        PushTokenConfig config = new PushTokenConfig();
        config.setDeviceId(session.getDeviceId());
        config.setBiz_type(PushConstant.PUSH_BIZ_TYPE);
        config.setDeviceType(PlatformType.getCode(session.getDeviceType()));
        return config;
    }

    private PushTokenConfig buildConfig(PushDeviceBindVo session) {
        PushTokenConfig config = new PushTokenConfig();
        config.setDeviceId(session.getDeviceId());
        config.setBiz_type(PushConstant.PUSH_BIZ_TYPE);
        config.setDeviceType(PlatformType.getCode(session.getDeviceType()));
        return config;
    }

    private Integer getFirstHeadTeacher(Long orgId, Long userId, int kefuId) {
        List<OrgStudentCourse> orgCourseIds =
                this.studentCourseDao.getOrgCourseIds(orgId, userId, null);
        List<Long> courseIds = ListUtil.toKeyList(orgCourseIds, "courseId", OrgStudentCourse.class);
        List<OrgCourse> courses = this.orgCourseDao.getByIds(courseIds, "cascadeId");
        int headTeacher = -1;
        if (courses != null || courses.size() > 1) {
            for (OrgCourse course : courses) {
                if (course.getCascadeId() != null && course.getCascadeId() >= 0) {
                    headTeacher = course.getCascadeId();
                    if (kefuId == headTeacher) {
                        break;
                    }
                }
            }
        }
        log.info("[Message] courses={},orgId={},userId={},kefuId={}",courses,orgId,userId,kefuId);
        return headTeacher;
    }
}
