/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;

import com.google.common.collect.Sets;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年6月3日
 * @desc
 */
@Slf4j
@Service
public class ConsultAvatarUrlServiceImpl implements ConsultAvatarUrlService {
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public ConsultAvatarUrlAndNameDto getConsultAvatarUrl(Long consultId) {
        String avatarUrl = null;
        String name = null;
        ConsultAvatarUrlAndNameDto consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
        TxConsultUser txConsultUser = txConsultUserDao.getOrgConsultUser(consultId);

        log.info("consultId param:{}", consultId);

        if (GenericsUtils.isNullOrEmpty(txConsultUser)) {
            log.info("该学员不存在");
            return consultAvatarUrlAndNameDto;
        }

        Long orgId = txConsultUser.getOrgId();

        Long studentId = txConsultUser.getStudentId();
        //根据studentId设置stuUserId
        OrgStudent orgStudent = null;
        if (studentId != null && studentId > 0) {
            orgStudent = orgStudentDao.getById(studentId);

            if (orgStudent != null) {
                name = orgStudent.getName();
                Long avatarId = orgStudent.getAvatar();
                String openId = orgStudent.getWeixin();
                log.info("orgAvatar param:{}", avatarId);
                // 优先获取学生自己上传头像
                if (avatarId != null && avatarId > 0) {
                    OrgStorage orgStorage = this.orgStorageDao.getById(avatarId);
                    if (orgStorage != null) {
                        avatarUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
                    }
                }

                // 其次获取学生微信头像
                if (StringUtils.isBlank(avatarUrl) && StringUtils.isNotBlank(openId)) {
                    Fans fans = this.fansDao.getByOpenId(openId);
                    log.info("fans param:{}", fans);
                    if (fans != null) {
                        avatarUrl = fans.getHeadImgUrl();
                        if (StringUtils.isBlank(name)) {
                            name = fans.getNick();
                        }
                    }
                }

                // 获取学生默认头像
                if (StringUtils.isBlank(avatarUrl)) {
                    Student student = this.studentDao.getByUserId(orgStudent.getUserId());
                    if (student != null) {
                        Integer stuAvatarId = student.getAvatar();
                        log.info("avatar param:{}", avatarId);
                        if (stuAvatarId != null && stuAvatarId > 0) {
                            Storage storage = this.storageDao.getStorageById(stuAvatarId.longValue());
                            if (storage != null) {
                                avatarUrl = StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                            }
                        }
                    }
                }
            }

        } else {
            // 不是学生时，首先获取意向学员自己上传的头像，如果为空，获取微信头像
            avatarUrl = txConsultUser.getPortrait();
            name = txConsultUser.getName();
            String openId = txConsultUser.getWeixinOpenId();
            if (GenericsUtils.isNullOrEmpty(avatarUrl) && GenericsUtils.notNullAndEmpty(openId)) {
                // 获取微信头像
                Fans fans = this.fansDao.getByOpenId(openId);
                log.info("fans param:{}", fans);
                if (GenericsUtils.notNullAndEmpty(fans)) {
                    avatarUrl = fans.getHeadImgUrl();
                    if (GenericsUtils.isNullOrEmpty(name)) {
                        name = fans.getNick();
                    }
                }
                log.info("avatarUrl param:{}", avatarUrl);
            }

        }

        // 如果头像为空，给予默认头像
        if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
            avatarUrl = AvatarConstants.CONSULT_AVATAR_URL;
        }

        consultAvatarUrlAndNameDto.setAvatarUrl(avatarUrl);
        consultAvatarUrlAndNameDto.setName(name);
        log.info("consultAvatarUrlAndNameDto param:{}", consultAvatarUrlAndNameDto);
        return consultAvatarUrlAndNameDto;
    }
    
    

    @Override
    public Map<Long, ConsultAvatarUrlAndNameDto> batchConsultAvatarUrlAndNameDtoMap(Collection<Long> consultIds,
                                                                                    Long orgId) {
        log.info(" 传来的参数 consultIds params:{}, orgId param:{}", consultIds, orgId);

        Map<Long, ConsultAvatarUrlAndNameDto> dtoMap = new HashMap<>();
        if(consultIds == null || consultIds.size()<1){
            return dtoMap;
        }

        if (consultIds == null || consultIds.size() < 1) {
            return dtoMap;
        }


        List<TxConsultUser> txConsultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultIds, null, null);
        log.info("txConsultUsers  parm:{}, size param:{}", txConsultUsers, txConsultUsers.size());

        //如果是学员在txConsultUser中设置studnetId,这样就可以区分学员和咨询用户了
        setStudentId(txConsultUsers, orgId);

        List<String> openIds = new ArrayList<>();

        List<Long> studentIds = new ArrayList<>();
        for (TxConsultUser txConsultUser : txConsultUsers) {
            Long studentId = txConsultUser.getStudentId();
            if (studentId != null && studentId > 0) {
                studentIds.add(studentId);
            }
            String openId = txConsultUser.getWeixinOpenId();
            if (!openId.equals("") && !openId.equals("0")) {
                openIds.add(openId);
            }
        }
        log.info("获取学员 studentIds param:{}", studentIds);

        // 批量查询用户微信详情
        Map<String, Fans> fansMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }

        //批量获取学员头像
        Map<Long, ConsultAvatarUrlAndNameDto> userIdConsultAvartarMap = new HashMap<>();
        Map<Long, Long> studentIdUserIdMap = new HashMap<>();
        if (GenericsUtils.notNullAndEmpty(studentIds)) {
            List<OrgStudent> orgStudents = this.orgStudentDao.getByIds(studentIds);
            for (OrgStudent orgStudent : orgStudents) {
                Long studentId = orgStudent.getId();
                Long userId = orgStudent.getUserId();
                studentIdUserIdMap.put(studentId, userId);
            }
            userIdConsultAvartarMap = this.batchStudentAvatarUrlAndNameDMap(studentIdUserIdMap.values(), orgId);
        }
        log.info("userIdConsultAvartarMap param:{}, size param:{}", userIdConsultAvartarMap, userIdConsultAvartarMap.size());

        for (TxConsultUser txConsultUser : txConsultUsers) {
            Long consultId = txConsultUser.getId();
            Long studentId = txConsultUser.getStudentId();
            ConsultAvatarUrlAndNameDto consultAvatarUrlAndNameDto = null;

            //是学员
            if (studentId != null && studentId > 0) {
                Long userId = studentIdUserIdMap.get(studentId);
                consultAvatarUrlAndNameDto = userIdConsultAvartarMap.get(userId);
                //测试环境会出现有studentId，但是没有对应的学员
                if (GenericsUtils.isNullOrEmpty(consultAvatarUrlAndNameDto)) {
                    consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
                    consultAvatarUrlAndNameDto.setAvatarUrl(AvatarConstants.CONSULT_AVATAR_URL);
                }

            } else {
                consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
                //咨询学员
                String name = txConsultUser.getName();
                String avatarUrl = txConsultUser.getPortrait();
                String mobile = txConsultUser.getMobile();
                String openId = txConsultUser.getWeixinOpenId();

                if (GenericsUtils.isNullOrEmpty(avatarUrl) && GenericsUtils.notNullAndEmpty(openId)) {
                    // 获取微信头像
                    Fans fan = fansMap.get(openId);
                    if (GenericsUtils.notNullAndEmpty(fan)) {
                        avatarUrl = fan.getHeadImgUrl();
                        if (GenericsUtils.isNullOrEmpty(name)) {
                            name = fan.getNick();
                        }
                    }
                }

                // 如果头像为空，给予默认头像
                if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
                    avatarUrl = AvatarConstants.CONSULT_AVATAR_URL;
                }
                consultAvatarUrlAndNameDto.setAvatarUrl(avatarUrl);
                consultAvatarUrlAndNameDto.setName(name == null ? "" : name);
                consultAvatarUrlAndNameDto.setMobile(mobile == null ? "" : mobile);
            }

            dtoMap.put(consultId, consultAvatarUrlAndNameDto);
        }
        log.info("dtoMap param:{}, size param:{}", dtoMap, dtoMap.size());
        return dtoMap;
    }


    @Override
    public Map<Long, ConsultAvatarUrlAndNameDto> batchStudentAvatarUrlAndNameDMap(Collection<Long> userIds, Long orgId) {
        if(userIds==null || userIds.size()<1){
            return Collections.EMPTY_MAP;
        }

        Map<Long, Integer> avatarIdMap = new HashMap<>(); // 学员默认头像存储id与userId映射关系
        Map<Long, OrgStorage> orgStorageMap = new HashMap<>(); // 机构学员上传头像存储与userId映射关系
        Map<Long, Storage> storageMap = new HashMap<>();
        Map<String, Fans> fansMap = new HashMap<>();
        Map<Long, OrgStudent> userIdOrgStudentMap = this.orgStudentDao.getStudentMap(userIds, orgId);
        Set<Long> orgAvatarIds = new HashSet<>();
        List<String> openIds = new ArrayList<>();
        for (Long userId : userIdOrgStudentMap.keySet()) {
            OrgStudent orgStudent = userIdOrgStudentMap.get(userId);
            String openId = orgStudent.getWeixin();
            if (!openId.equals("") && !openId.equals("0")) {
                openIds.add(openId);
            }
            Long avatarId = orgStudent.getAvatar();
            if (GenericsUtils.notNullAndEmpty(avatarId)) {
                orgAvatarIds.add(avatarId);
            }
        }

        if (GenericsUtils.notNullAndEmpty(orgAvatarIds)) {
            orgStorageMap = this.orgStorageDao.getOrgStorageMapByIds(orgAvatarIds);
        }

        avatarIdMap = studentDao.getAvatarsMap(userIds);
        Set<Long> avatarIds = Sets.newHashSet();
        if (GenericsUtils.notNullAndEmpty(avatarIdMap)) {
            for (Integer avatar : avatarIdMap.values()) {
                avatarIds.add(avatar.longValue());
            }
            if (GenericsUtils.notNullAndEmpty(avatarIds)) {
                storageMap = this.storageDao.getStorageMapByIds(avatarIds);
            }
        }

        // 批量查询用户微信详情
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }

        Map<Long, ConsultAvatarUrlAndNameDto> consultAvatarUrlAndNameDtoMap = new HashMap<>();
        for (Long userId : userIds) {
            OrgStudent orgStudent = userIdOrgStudentMap.get(userId);
            ConsultAvatarUrlAndNameDto dto = buildConsultAvatarUrlAndNameDto(orgStudent,orgStorageMap,fansMap,avatarIdMap,storageMap);
            consultAvatarUrlAndNameDtoMap.put(userId, dto);
        }
        return consultAvatarUrlAndNameDtoMap;
    }

    private ConsultAvatarUrlAndNameDto buildConsultAvatarUrlAndNameDto(OrgStudent orgStudent ,Map<Long, OrgStorage> orgStorageMap,Map<String, Fans> fansMap,Map<Long, Integer> avatarIdMap,Map<Long, Storage> storageMap){
        ConsultAvatarUrlAndNameDto dto = new ConsultAvatarUrlAndNameDto();
        String avatarUrl = null;
        String name = null;
        String mobile = null;
        if (GenericsUtils.notNullAndEmpty(orgStudent)) {
            name = orgStudent.getName();
            mobile = orgStudent.getMobile();
            Long avatarId = orgStudent.getAvatar();
            OrgStorage orgStorage = orgStorageMap.get(avatarId);
            if (GenericsUtils.notNullAndEmpty(orgStorage)) {
                avatarUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
            }

            // 获取微信头像
            String openId = orgStudent.getWeixin();
            if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
                // 获取微信头像
                if (GenericsUtils.notNullAndEmpty(openId)) {
                    Fans fan = fansMap.get(openId);
                    if (GenericsUtils.notNullAndEmpty(fan)) {
                        avatarUrl = fan.getHeadImgUrl();
                    }
                }
            }

            // 默认学员头像
            if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
                Integer aratarId =  avatarIdMap.get(orgStudent.getUserId());
                if (aratarId != null) {
                    Storage storage = storageMap.get(aratarId.longValue());
                    if (storage != null) {
                        avatarUrl =
                                StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                    }
                }
            }
        }

        // 如果头像为空，给予默认头像
        if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
            avatarUrl = AvatarConstants.CONSULT_AVATAR_URL;
        }

        dto.setAvatarUrl(avatarUrl);
        dto.setMobile(mobile);
        dto.setName(name);

        return dto;
    }



    private void setStudentId(List<TxConsultUser> users, Long orgId) {
        Map<Long, TxConsultUser> map = new HashMap<>();

        for (TxConsultUser user : users) {
            if (user.getStudentId() != null && user.getStudentId() > 0) {
                continue;
            }
            if (user.getUserId() != null && user.getUserId() > 0) {
                map.put(user.getUserId(), user);
            }
        }

        if (GenericsUtils.notNullAndEmpty(map.keySet())) {
            List<OrgStudent> orgStudents = orgStudentDao.getStudentByUserIds(orgId, map.keySet());

            if (GenericsUtils.notNullAndEmpty(orgStudents)) {
                for (OrgStudent stu : orgStudents) {
                    TxConsultUser user = map.get(stu.getUserId());
                    if (user != null) {
                        user.setStudentId(stu.getId());
                    }
                }
            }
        }
    }

}
