package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.push.api.AppPushApi;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.service.NeedRemindUserService;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/1/7.
 */
@Service
@Slf4j
public class NeedRemindUserServiceImpl implements NeedRemindUserService {

    private static final String CONSULT_USER_ACTION = "add_consult";
    private static final String STUDENT_ACTION = "student_info";

    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgStudentDao studentsDao;

    @Override
    public void pushConsultUser(Date startTime, Date endTime) {
        List<TxConsultUser> consultUserList = consultUserDao.getConsultUserByRemindTime(startTime, endTime);
        log.info("pushConsultUser.startTime:{}, endTime:{}", startTime, endTime);
        if (consultUserList != null && consultUserList.size() > 0) {
            for (TxConsultUser consultUser : consultUserList) {
                if (consultUser.getUserId() != null) {
                    OrgStudent stu = studentsDao.getStudent(consultUser.getOrgId(), consultUser.getUserId(), null);
                    if (stu != null) {
                        AppPushApi.pushMsg(getPushConfig(stu), stu.getOrgId());
                    }
                }
                AppPushApi.pushMsg(getPushConfig(consultUser), consultUser.getOrgId());
            }
        }
    }

    @Override
    public void pushOrgStudent(Date startTime, Date endTime) {
        List<OrgStudent> studentsList = studentsDao.getUserByRemindTime(startTime, endTime);
        log.info("pushOrgStudent.startTime:{}, endTime:{}", startTime, endTime);
        if (studentsList != null && studentsList.size() > 0) {
            for (OrgStudent stu : studentsList) {
                AppPushApi.pushMsg(getPushConfig(stu), stu.getOrgId());
            }
        }
    }

    private PushConfig getPushConfig(TxConsultUser consultUser) {
        PushConfig config = new PushConfig();
        String name = consultUser.getName();
        if (StringUtils.isBlank(name)) {
            name = consultUser.getMobile();
        }
        config.setTip(getConsultUserTip(name));
        String url = ActionUtil.getUrl(CONSULT_USER_ACTION);
        url = ActionUtil.addParam(url, "cid", consultUser.getId());
        config.setJumpUrl(url);

        return config;
    }

    private PushConfig getPushConfig(OrgStudent student) {
        PushConfig config = new PushConfig();
        String name = student.getName();
        if (StringUtils.isBlank(name)) {
            name = student.getMobile();
        }
        config.setTip(getStudentTip(name));
        String url = ActionUtil.getUrl(STUDENT_ACTION);
        url = ActionUtil.addParam(url, "sid", student.getId());
        config.setJumpUrl(url);
        return config;
    }

    private String getConsultUserTip(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("［跟进提醒］您该跟进客户");
        sb.append(name);
        sb.append("了，防止客户流失哦，赶快处理");
        return sb.toString();
    }

    private String getStudentTip(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("［回访提醒］学员");
        sb.append(name);
        sb.append("该回访了");
        return sb.toString();
    }
}

