package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 16/1/6.
 */
public class PushConfig {
    private String tip;//提示文案
    private String jumpUrl;//跳转URL
    private String title;

    public PushConfig() {

    }

    public String getTip() {
        return tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static PushConfig getNoticeConfig(NoticeMsgContent notice, String uuid){
        PushConfig config = new PushConfig();
        config.setTip(notice.getTip());
        config.setTitle(notice.getPushTitle());
        String url = notice.getAction();
        url = ActionUtil.addParam(url,"u",uuid);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getMsgConfig(String title,String tip,Long userId,int userRole,String uuid){
        PushConfig config = new PushConfig();
        Map<String,Object> map = new HashMap<>();
        map.put("userId",userId);
        map.put("userRole",userRole);
        map.put("userType", MsgUserType.getUserType(userRole).getValue());
        map.put("u", uuid);
        String url = ActionUtil.getAction(ActionUtil.MSG_ACTION,map);
        config.setJumpUrl(url);
        config.setTitle(title);
        config.setTip(tip);
        return config;
    }
}
