package com.baijia.tianxiao.sal.push.api;

import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.dto.*;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.gson.Gson;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by liuxp on 16/5/10.
 */
public class PushApi {

    private static final Logger logger = LoggerFactory.getLogger(PushApi.class);

    public static LinkDeviceInfo getLinkPlatformDeviceList(String uid, String bizType) {
        Map<String, String> params = new HashMap<>();
        params.put("uids", uid);
        params.put("bizType", bizType);
        logger.info("[Device] Query param = " + params);
        String str = HttpClientUtils.doPost(Config.LINK_PLATFORM_DEVICE_INFO_URL, params);
        logger.info("[Device] Query result = "+str);
        Gson gson = new Gson();
        return gson.fromJson(str, LinkDeviceInfo.class);
    }

    public static PushDeviceInfo getPushDeviceList(String uid, String bizType) {
        long start = System.currentTimeMillis();
        Map<String, String> params = new HashMap<>();
        params.put("userId", uid);
        params.put("bizType", bizType);
        logger.info("[Device] Query param = " + params);
        String str = HttpClientUtils.doPost(Config.PUSH_DEVICE_INFO_URL, params);
        logger.info("[Device] Get push DeviceList result="+str+";cost time="+(System.currentTimeMillis()-start));
        Gson gson = new Gson();
        return gson.fromJson(str, PushDeviceInfo.class);
    }
    public static void main(String[] args) {
        LinkDeviceInfo result = PushApi.getLinkPlatformDeviceList("3618_0","tx:cccr:TX_PUSH");
        
        System.out.println(result);
        
        PushDeviceInfo result2 = PushApi.getPushDeviceList("3618_0","tx:cccr:TX_PUSH");
        
        System.out.println(result2);
    }

    //发送聊天消息
    public static void sendMsg(ConsultMessage message, MsgUser msgUser, PushTokenConfig config) {
        Map<String, String> parameterMap = new LinkedHashMap<>();
        long start = System.currentTimeMillis();
        parameterMap.put("uid", config.getUser_id());
        parameterMap.put("bizType", config.getBiz_type());
        parameterMap.put("deviceId", config.getDeviceId());
        parameterMap.put("message", getMessage(message, msgUser));

        logger.info("[LinkPlatform] param= " + parameterMap);
        PushResult result = null;
        Gson gson = new Gson();
        try {
            String str = HttpClientUtils.doPost(Config.LINK_PLATFORM_SEND_MSG_URL, parameterMap);
            logger.info("[LinkPlatform] Link Platform result:{};cost time={}", str,System.currentTimeMillis()-start);
            result = gson.fromJson(str, PushResult.class);
        } catch (Exception e) {
            logger.info("[LinkPlatform] ParameterMap:{};cost time={}", parameterMap,System.currentTimeMillis()-start);
            logger.warn("[LinkPlatform] Exception:", e);
        }
        logger.info("[LinkPlatform] Result =" + ToStringBuilder.reflectionToString(result));
        int i = 1;

        if (result==null || result.getCode() != 1) {
            logger.warn("[LinkPlatform] :{}", parameterMap);
        }
    }

    private static String getMessage(ConsultMessage message, MsgUser msgUser) {
        Gson gson = new Gson();
        Map<String, Object> payloadMap = new HashMap<>();
        List<PushDto> list = new ArrayList<>();
        PushDto pushDto = PushDto.getInstance(message);
        pushDto.setUser(UserDto.getInstance(msgUser));
        pushDto.getMsg().setContent(MsgContentFactory.getContent(message));
        list.add(pushDto);
        payloadMap.put("list", list);
        Map<String, Object> messageMap = new HashMap<>();
        messageMap.put("action", "msg-message");
        messageMap.put("data", payloadMap);
        messageMap.put("type", "biz");
        return gson.toJson(messageMap);
    }

    //发送推送消息
    public static void pushMsg(PushConfig config, PushTokenConfig tokenConfig) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("uid", tokenConfig.getUser_id());
        parameterMap.put("bizType", tokenConfig.getBiz_type());
        parameterMap.put("deviceDomain", tokenConfig.getDevice_domain().toString());
        parameterMap.put("deviceId", tokenConfig.getDeviceId());
        parameterMap.put("message", getJsonMsg(config));
        logger.info("[NewPush]Param = " + parameterMap);
        try {
            String pushRetStr = HttpClientUtils.doPost(Config.PUSH_SEND_MSG_URL, parameterMap);
            logger.info("[NewPush] Push result:{}", pushRetStr);
        } catch (Exception e) {
            logger.error("[NewPush]parameterMap:{}", parameterMap);
            logger.error("[NewPush] Exception:", e);
            throw new RuntimeException("外部接口访问失败");
        }
    }

    public static void bind(BindInfo bindInfo) {
        Gson gson = new Gson();
        Map<String,String> param = new HashMap<>();
        param.put("pushBindRecordStr",gson.toJson(bindInfo));
        logger.info("[Push] Bind Param=" + param);
        String result = HttpClientUtils.doGet(Config.PUSH_BIND_URL,param);
        logger.info("[Push] Bind result=" + result);
    }

    public static void unBind(BindInfo bindInfo) {
        Gson gson = new Gson();
        Map<String,String> param = new HashMap<>();
        param.put("pushBindRecordStr",gson.toJson(bindInfo));
        logger.info("[Push] Un Bind Param=" + param);
        String result = HttpClientUtils.doGet(Config.PUSH_UN_BIND_URL,param);
        logger.info("[Push] Un Bind result=" + result);
    }

    public static Map<String,String> getMap(BindInfo bindInfo){
        Map<String,String> map = new HashMap<>();
        map.put("userId",bindInfo.getUserId());
        map.put("deviceId",bindInfo.getDeviceId());
        map.put("deviceType",bindInfo.getDeviceType());
        map.put("userType", bindInfo.getUserType());
        if(bindInfo.getChannelList()!=null && bindInfo.getChannelList().size()>0) {
            Gson gson = new Gson();
            map.put("channelList", gson.toJson(bindInfo.getChannelList()));
        }
        return map;
    }

    private static String getJsonMsg(PushConfig config) {
        Map<String, String> map = new HashMap<>();
        map.put("description", config.getTip());
        map.put("s", config.getJumpUrl());
        map.put("title", config.getTitle());
        Gson gson = new Gson();
        return gson.toJson(map);
    }
}
