package com.baijia.tianxiao.sal.push.utils;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.util.mobile.MaskUtil;

/**
 * Created by lxp on 2017/6/7.
 */
public class PushTipFactory {

    //推送标题
    public static final String STAFF_MSG_TITEL="同事消息";
    public static final String CLUE_TRANSFER_TITEL="线索分配";
    public static final String STUDENT_TRANSFER_TITEL="学员分配";
    public static final String CLUE_TO_GET_TITEL="线索待领";
    public static final String IMPORT_CLUE_TITEL="导入线索";
    public static final String APPOINTMENT_TITEL="预约试听";
    public static final String ACTIVITY_SIGN_TITEL="活动报名";
    public static final String ACTIVITY_DRAW_TITEL="抽奖活动";
    public static final String TODO_TITEL="待办提醒";
    public static final String WEICHAT_MSG_TITEL="微信消息";
    public static final String PHONE_400_TITEL="400电话";
    public static final String FOLLOW_TIP_TITLE="跟进通知";

    //推送文案
    private static final String STAFF_MSG = "%s：%s";
    private static final String CLUE_TRANSFER = "%s转给您一条新线索:%s,%s";
    private static final String STUDENT_TRANSFER = "%s转给您一名新学员：%s，%s";
    private static final String NEW_CLUE = "您有新的公共线索：%s，%s";
    private static final String NEW_APPOINTMENT = "您有新的在线留单：%s，%s";
    private static final String NEW_ACTIVITY_SIGN = "活动有新的学员报名：%s，%s";
    private static final String NEW_DRAW_WINNER = "抽奖活动有新的中奖信息";
    private static final String WEICHAT_MSG = "%s：%s";
    private static final String NEW_400_PHONE = "您有一条新的来电咨询";
    private static final String BATCH_IMPORT = "成功导入了%d条线索";
    private static final String FOLLOW_TIP = "您收到一条来自%s的跟进提醒";
    private static final String BATCH_PASS_TO = "%s 给你转了%d条线索";


    public static String getStaffMsgTip(String sender, String msg) {
        return String.format(STAFF_MSG, sender, msg);
    }

    public static String getClueTransferTip(String sender, String consultUser, String consultUserMobile) {
        return String.format(CLUE_TRANSFER, sender, consultUser, MaskUtil.maskMobile(consultUserMobile));
    }

    public static String getStudentTransferTip(String sender, String name, String mobile) {
        return String.format(STUDENT_TRANSFER, sender, name, MaskUtil.maskMobile(mobile));
    }

    public static String getNewClueTip(String name, String mobile) {
        return String.format(NEW_CLUE, name, MaskUtil.maskMobile(mobile));
    }

    public static String getNewAppointmentTep(String name, String mobile) {
        return String.format(NEW_APPOINTMENT, name, MaskUtil.maskMobile(mobile));
    }

    public static String getNewActivitySignTip(String name, String mobile) {
        return String.format(NEW_ACTIVITY_SIGN, name, MaskUtil.maskMobile(mobile));
    }

    public static String getNewDrawWinnerTip() {
        return NEW_DRAW_WINNER;
    }

    public static String getTodo(String msg) {
        return msg;
    }

    public static String getWeichatMsgTip(String msg, String sender) {
        return String.format(WEICHAT_MSG, sender, msg);
    }

    public static String get400PhoneTip() {
        return NEW_400_PHONE;
    }

    public static String getBatchImportTip(int number){
        return String.format(BATCH_IMPORT,number);
    }

    public static String getBatchPassToTip(String name,int number){
        return String.format(BATCH_PASS_TO,name,number);
    }

    public static String getFollowTip(String sender){
        return String.format(FOLLOW_TIP,sender);
    }

    public static void main(String[] args) {
        System.out.println(getClueTransferTip("bb","aa","19900010002"));
    }
}
