package com.baijia.tianxiao.sal.push.utils;

import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.MsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.TextMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;

import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by liuxp on 16/5/23.
 */
@Slf4j
public class MsgContentFactory {
    public static MsgContent getContent(ConsultMessage message){
        log.info("Message Type = "+message.getMsgType());
        MsgType msgType = MsgType.getTypeByValue(message.getMsgType());
        switch (msgType) {
            case TEXT:
                TextMsgContent txt = new TextMsgContent();
                txt.setText(message.getContent());
                return txt;
            case PICTURE:
                ImageMsgContent img = new ImageMsgContent();
                img.setHeight(message.getHeight());
                img.setWidth(message.getWidth());
                img.setUrl(message.getUrl());
                return img;
            case VOICE:
                AudioMsgContent audio = new AudioMsgContent();
                audio.setUrl(message.getUrl());
                audio.setCallId(message.getCallId());
                audio.setLen(message.getLength());
                return audio;
            case NOTICE:
                Gson gson = new Gson();
                NoticeMsgContent notice = gson.fromJson(message.getContent(),NoticeMsgContent.class);
                NoticeType noticeType = NoticeType.getByValue(notice.getType());
                notice.setText("[通知]"+notice.getText());
                notice.setTitle(noticeType.getTitle());
                return notice;
            case CARD:
                Gson cardGson = new Gson();
                CardMsgContent msgContent = cardGson.fromJson(message.getContent(),CardMsgContent.class);
                return msgContent;
            }
        log.warn("[Message] message type is error.type="+message.getMsgType());
        return null;
    }


    public static MsgContent jsonToContent(ConsultMessage message){
        log.info("Message Type = "+message.getMsgType()+";content="+message.getContent());
        Gson gson = new Gson();
        MsgType msgType = MsgType.getTypeByValue(message.getMsgType());
        switch (msgType) {
            case TEXT:
                TextMsgContent txt = gson.fromJson(message.getContent(),TextMsgContent.class);
                return txt;
            case PICTURE:
                ImageMsgContent img = gson.fromJson(message.getContent(), ImageMsgContent.class);
                return img;
            case VOICE:
                AudioMsgContent audio = gson.fromJson(message.getContent(), AudioMsgContent.class);
                return audio;
            case NOTICE:
                NoticeMsgContent notice = gson.fromJson(message.getContent(), NoticeMsgContent.class);
                notice.setText(notice.getText());
                notice.setTitle(notice.getTitle());
                return notice;
            case CARD:
                CardMsgContent msgContent = gson.fromJson(message.getContent(),CardMsgContent.class);
                return msgContent;
        }
        log.warn("[Message] message type is error.type="+message.getMsgType());
        return null;
    }

    public static String jsonToStr(ConsultMessage message){
        log.info("Message Type = "+message.getMsgType()+";content="+message.getContent());
        Gson gson = new Gson();
        MsgType msgType = MsgType.getTypeByValue(message.getMsgType());
        switch (msgType) {
            case TEXT:
                TextMsgContent txt = gson.fromJson(message.getContent(),TextMsgContent.class);
                return txt.getText();
            case PICTURE:
                return "[图片]";
            case VOICE:
                return "[语音]";
            case NOTICE:
                NoticeMsgContent notice = gson.fromJson(message.getContent(),NoticeMsgContent.class);
                return notice.getText();
            case CARD:
                CardMsgContent msgContent = gson.fromJson(message.getContent(),CardMsgContent.class);
                String text = msgContent.getText();
                if(msgContent.getImages()!=null && msgContent.getImages().size()>0){
                    text +="[图片]";
                }
                if(msgContent.getAudios()!=null && msgContent.getAudios().size()>0){
                    text +="[语音]";
                }
                return text;
        }
        log.warn("[Message] message type is error.type="+message.getMsgType());
        return null;
    }
    
    public static String getContentByConsultMessageDto(ConsultMessageDto message){
        log.info("Message Type = "+message.getMsgType());
        MsgType msgType = MsgType.getTypeByValue(message.getMsgType());
        String text = null;
        Gson gson = new Gson();
        switch (msgType) {
            case TEXT:
                TextMsgContent txt = gson.fromJson(message.getText(),TextMsgContent.class);
                text = txt.getText();
                return text;
            case PICTURE:
                text = "[图片]";
                return text;
            case VOICE:
                text = "[语音]";
                return text;
            case NOTICE:
                NoticeMsgContent notice = gson.fromJson(message.getText(),NoticeMsgContent.class);
                text = notice.getText();
                return text;
            case CARD:
                CardMsgContent msgContent = gson.fromJson(message.getText(),CardMsgContent.class);
                text = msgContent.getText();
                return text;
            }
        log.warn("[Message] message type is error.type="+message.getMsgType());
        return null;
    }

    public static String maskMobile(String text) {
        Pattern pattern = Pattern.compile("电话：([0-9]+)");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String mobile = matcher.group(1);
            String maskMobile = MaskUtil.maskMobile(mobile);
            text = text.replaceAll("电话：[0-9]+", "电话：" + maskMobile);
        }
        return text;
    }

    public static String maskActionMobile(String text) {
        Pattern pattern = Pattern.compile("mobile\\\\u003d([0-9]+)");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String mobile = matcher.group(1);
            String maskMobile = MaskUtil.maskMobile(mobile);
            text = text.replaceAll("mobile\\\\u003d[0-9]+", "mobile\\\\u003d" + maskMobile);
        }
        return text;
    }

}
