package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.push.api.PushApi;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.constant.PushConstant;
import com.baijia.tianxiao.sal.push.dto.*;
import com.baijia.tianxiao.sal.push.enums.ChannelType;
import com.baijia.tianxiao.sal.push.enums.PlatformType;
import com.baijia.tianxiao.sal.push.service.PushAuthorityService;
import com.baijia.tianxiao.sal.push.utils.ParamUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liuxp on 16/5/10.
 */
@Service
@Slf4j
public class PushAuthorityServiceImpl implements PushAuthorityService {
    @Override
    public String getToken(String deviceId, int deviceType, int deviceDomain, Long orgId, Integer cascadeId) {
        PushTokenConfig config = new PushTokenConfig();
        String tokenStr = null;
        config.setDeviceType(deviceType);
        config.setDeviceId(deviceId);
        config.setDevice_domain(deviceDomain);
        config.setBiz_type(PushConstant.PUSH_BIZ_TYPE);
        if (cascadeId == null) {
            cascadeId = 0;
        }
        config.setUser_id(ParamUtil.getUUID(orgId, cascadeId));
        try {
            tokenStr = EncryptUtils.pushTokenEncode(config);
        } catch (Exception e) {
            log.error("[Token] Generate token exception.", e);
        }
        return tokenStr;
    }

    @Override
    public void bind(BindRequest request, long orgId, Integer subAccountId) {
        log.debug("[Push] Bind param:request1 {},orgId = {},cascadeId={}", request, orgId, subAccountId);
        Gson gson = new Gson();
        BindInfo bindInfo = buildBindInfo(request, orgId, subAccountId);
        List<ChannelRequest> channelRequestList = gson.fromJson(request.getChannels(),
                new TypeToken<List<ChannelRequest>>() {
                }.getType());
        bindInfo.setChannelList(buildChannels(channelRequestList,bindInfo.getDeviceType()));
        PushApi.bind(bindInfo);
    }

    public List<PushBindChannel> buildChannels(List<ChannelRequest> channelList,String deviceType) {
        List<PushBindChannel> channels = new ArrayList<>();
        if (channelList != null) {
            for (ChannelRequest request : channelList) {
                PushBindChannel channel = new PushBindChannel();
                channel.setDeviceToken(request.getDeviceToken());
                channel.setChannelType(ChannelType.getName(request.getChannelType()));
                if(StringUtils.isBlank(request.getAppId())){
                    channel.setAppId(Config.NEW_APP_ID);
                }else {
                    channel.setAppId(request.getAppId());
                }

                channel.setDevelopStatus(request.getDevelopStatus());
                //ios 才设置这个属性
                if(StringUtils.equals(deviceType, PlatformType.IOS.getName())){
                    channel.setDeployStatus(request.getDeployStatus());
                }
                channels.add(channel);
                
            }
        }
        return channels;
    }

    public BindInfo buildBindInfo(BindRequest request, long orgId, Integer cascadeId) {
        BindInfo info = new BindInfo();
        info.setUserType(PushConstant.PUSH_BIZ_TYPE);
        if (cascadeId == null) {
            cascadeId = 0;
        }
        info.setUserId(ParamUtil.getUUID(orgId, cascadeId));
        info.setDeviceId(request.getDeviceId());
        info.setDeviceType(PlatformType.getName(request.getDeviceType()));
        info.setSystemChannel(ChannelType.getName(request.getSystemChannel()));
        info.setPhoneBrand(request.getPhoneBrand());
        return info;
    }

    @Override
    public void unbind(BindInfo bindInfo, long orgId, Integer cascadeId) {
        bindInfo.setUserType(PushConstant.PUSH_BIZ_TYPE);
        if (cascadeId == null) {
            cascadeId = 0;
        }
        bindInfo.setUserId(ParamUtil.getUUID(orgId, cascadeId));
        PushApi.unBind(bindInfo);
    }
}
