package com.baijia.tianxiao.sal.push.service.impl;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dao.MsgPulledRecordDao;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.MsgPulledRecord;
import com.baijia.tianxiao.dal.push.po.UserIdentify;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.push.constant.MsgConstant;
import com.baijia.tianxiao.sal.push.dto.CommonMsgUser;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.newpush.MsgResponse;
import com.baijia.tianxiao.sal.push.dto.newpush.UserResponse;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.MessageSendExecutor;
import com.baijia.tianxiao.sal.push.service.OrgService;
import com.baijia.tianxiao.sal.push.service.PushRedisService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sal.push.utils.MsgUserFactory;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 15/12/4.
 */
@Service
@Slf4j
public class ConsultMessageServiceImpl implements ConsultMessageService {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private MessageDao messageDao;
    @Autowired
    private MsgPulledRecordDao pulledRecordDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private UserCacheService cacheService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private TXCascadeCredentialDao cascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired(required = false)
    private MessageSendExecutor messageSendExecutor;
    @Autowired
    private OrgService orgService;
    @Autowired
    private PushRedisService redisService;

    private ConcurrentHashMap<Integer, String> orgLogoMap = new ConcurrentHashMap<>();

    /**
     * 机构接收到的信息
     *
     * @param sender
     * @param receiver
     * @param message
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message) {
        messageSendExecutor.sendConsultMessage(sender, receiver, message, null);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message,
        Integer givenReceiverId) {
        messageSendExecutor.sendConsultMessage(sender, receiver, message, givenReceiverId);
        return true;
    }

    @Override
    public boolean sendNotice(Long orgId, Integer cascadeId, NoticeMsgContent content) {
        messageSendExecutor.sendNotice(orgId, cascadeId, content);
        return true;
    }

    @Override
    public boolean sendStaffMsg(long orgId, Integer cascadeId, ConsultMessage message) {
        messageSendExecutor.sendStaffMsg(orgId, cascadeId, message);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean addMessage(ConsultMessage message) {
        try {
            messageDao.insertMessage(message);
            return true;
        } catch (Exception e) {
            logger.info("[ConsultMessage] message = "
                + ToStringBuilder.reflectionToString(message, ToStringStyle.SHORT_PREFIX_STYLE));
            logger.error("[ConsultMessage] Insert Exception.", e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    public List<PushDto> getNewMessageList(long userId, Long msgId) {
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<MsgResponse> pullMessageList(long orgId, Integer cascadeId, String deviceId, Long msgId) {
        logger.info("userId={}，cascadeId={}，msgId={};deviceId={}", orgId, cascadeId, msgId, deviceId);
        Integer number = cacheService.getOrgNumber(orgId);
        if (number == null) {
            logger.warn("[PullMsg] orgId is not exist.id = " + orgId);
            return Collections.emptyList();
        }

        if (cascadeId == null) {
            cascadeId = 0;
        }

        boolean isNull = false;
        MsgPulledRecord pulledRecord = null;

        // app端不传值的时候以服务器端为准
        if (msgId == null || msgId < 1) {
            pulledRecord = pulledRecordDao.selectPulledRecordByUserId(number.longValue(), cascadeId, deviceId);
            // 兼容
            if (pulledRecord == null) {
                isNull = true;
                pulledRecord = pulledRecordDao.selectPulledRecordByUserId(number.longValue(), cascadeId, "");
            }

            if (msgId == null) {
                msgId = 0L;
            }

            if (pulledRecord != null) {
                msgId = pulledRecord.getMsgId();
            }
            msgId = 0L;
        }

        List<ConsultMessage> msgList =
            messageDao.selectNewOrgRecordList(number.longValue(), cascadeId, msgId, MsgConstant.PULL_MESSAGE_LIMIT);

        //主从延迟处理
        Set<Long> msgIds = new HashSet<>();
        for (ConsultMessage msg:msgList){
            msgIds.add(msg.getId());
        }
        List<ConsultMessage> cacheList = redisService.getMessageList(orgId,cascadeId.longValue());
        for (ConsultMessage msg:cacheList) {
            if (msg.getId() >= msgId && !msgIds.contains(msg.getId())) {
                msgList.add(msg);
            }
        }

            Collections.sort(msgList, new Comparator<ConsultMessage>() {
            @Override
            public int compare(ConsultMessage o1, ConsultMessage o2) {
                return (int) (o1.getId() - o2.getId());
            }
        });

        logger.info("[ConsultMessage] result list=" + msgList.size());
        List<MsgResponse> retList = new ArrayList<>();
        if (msgList.size() > 0) {
            if (!isNull) {
                pulledRecordDao.updatePulledRecord(number.longValue(), cascadeId, deviceId,
                    msgList.get(msgList.size() - 1).getId());
            } else {
                pulledRecord = new MsgPulledRecord();
                pulledRecord.setMsgId(msgList.get(msgList.size() - 1).getId());
                pulledRecord.setCascadeId(cascadeId);
                pulledRecord.setUserId(number.longValue());
                pulledRecord.setUpdateTime(new Date());
                pulledRecord.setDeviceId(deviceId);
                pulledRecordDao.insertPulledRecord(pulledRecord);
            }
            boolean isShow = orgService.isShowMobile(orgId, cascadeId);
            retList = toMsgResponseList(msgList, orgId, cascadeId, isShow);

        }

        return retList;
    }

    private List<MsgResponse> toMsgResponseList(List<ConsultMessage> msgList, long orgId, int cascadeId,
        boolean isShow) {
        OrgInfo orgInfo = orgInfoDao.getOrgInfo((int) orgId, "name", "contacts");
        Integer number = cacheService.getOrgNumber(orgId);
        List<MsgResponse> retList = new ArrayList<>();
        List<Long> consultUserIds = new ArrayList<>();
        Set<Integer> cascadeIds = new HashSet<>();

        for (ConsultMessage msg : msgList) {
            MsgResponse dto = MsgResponse.getInstance(msg);
            UserResponse userDto = new UserResponse();

            if (MessageSource.NOTICE.getValue() == msg.getConsultType()) {
                CommonMsgUser commonMsgUser = MsgUserFactory.createSysUser();
                userDto.setUserRole(commonMsgUser.getMsgUserRole().getValue());
                userDto.setUserId(commonMsgUser.getUserId());
                userDto.setName(commonMsgUser.getName());
                dto.setUser(userDto);
            } else {
                userDto = getUserResponse(msg, number, cascadeId);
                if (userDto == null) {
                    continue;
                }
                if (MsgUserRole.isStu(userDto.getUserRole())) {
                    consultUserIds.add(userDto.getUserId());
                } else if (MsgUserRole.isSubOrg(userDto.getUserRole())) {
                    cascadeIds.add((int) userDto.getUserId());
                }
                dto.setUser(userDto);

                // 卡片消息电话打码
                if (msg.getMsgType() == MsgType.CARD.getValue() && MsgUserRole.isSubOrg(msg.getReceiverRole())) {
                    if (!isShow) {
                        String content = MsgContentFactory.maskMobile(msg.getContent());
                        content = MsgContentFactory.maskActionMobile(content);
                        msg.setContent(content);
                    }
                }
            }

            dto.getMsg().setContent(MsgContentFactory.jsonToContent(msg));
            retList.add(dto);
        }

        List<TxConsultUser> consultUsers = consultUserDao.getByIds(consultUserIds);

        Map<Long, TxConsultUser> consultUserMap =
            CollectionUtils.extractMap(consultUsers, new CollectionUtils.Extracter<Long, TxConsultUser>() {
                @Override
                public Long extract(TxConsultUser consultUser) {
                    return consultUser.getId();
                }
            });

        Map<Integer, TXCascadeCredential> nameMap = cascadeCredentialDao.getTxCascadeNameAndAvatar(cascadeIds);
        List<TXCascadeAccount> byIds = this.cascadeAccountDao.getByIds(cascadeIds, "id", "title");
        final Map<Integer, String> idWithTitle = Maps.newHashMap();
        CollectionUtils.extractMap(byIds, new CollectionUtils.Extracter<Integer, TXCascadeAccount>() {

            @Override
            public Integer extract(TXCascadeAccount arg0) {
                idWithTitle.put(arg0.getId(), arg0.getTitle());
                return null;
            }
        });

        String logo = getLogo(orgId);

        for (Iterator<MsgResponse> iterator = retList.iterator(); iterator.hasNext();) {
            MsgResponse dto = iterator.next();
            try {
                if (dto.getUser() == null) {
                    continue;
                }
                if (dto.getType() == MessageSource.NOTICE.getValue()) {
                    logger.info("[Message] pull message System user");
                } else {
                    UserResponse response = dto.getUser();
                    MsgUserRole msgUserRole = MsgUserRole.getByCode(response.getUserRole());
                    if (MsgUserRole.getOrgUsers().contains(msgUserRole)) {
                        if (MsgUserRole.isHeader(dto.getUser().getUserRole())) {
                            OrgCacheDto orgCacheDto = cacheService.getOrg(response.getUserId());
                            if (orgCacheDto == null) {
                                iterator.remove();
                                continue;
                            }
                            response.setName(orgInfo.getContacts());
                            response.setUserId(number);
                            response.setUserType(msgUserRole.getValue());
                            response.setUserTypeString(msgUserRole.getDesc());
                            response.setAvatarUrl(logo);
                            dto.setUser(response);
                        } else {
                            TXCascadeCredential credential = nameMap.get((int) dto.getUser().getUserId());
                            String roleTypeString = idWithTitle.get((int) dto.getUser().getUserId());
                            response.setUserTypeString(
                                GenericsUtils.isNullOrEmpty(roleTypeString) ? msgUserRole.getDesc() : roleTypeString);
                            logger.info("[Message] cascade name=" + credential.getName());
                            response.setName(credential.getName());
                            if (StringUtils.isNotBlank(credential.getAvatar())) {
                                response.setAvatarUrl(credential.getAvatar());
                            } else {
                                response.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
                            }
                            dto.setUser(response);
                        }
                    } else {
                        TxConsultUser consultUser = consultUserMap.get(dto.getUser().getUserId());
                        if (consultUser != null) {
                            response = UserResponse.getInstance(consultUser);
                            String url = redisService.getAvatar(consultUser.getId());
                            if (StringUtils.isNotBlank(url)) {
                                response.setAvatarUrl(url);
                            } else {
                                String avatarUrl = consulterAPIService.getConsultAvatarUrl(consultUser.getId());
                                response.setAvatarUrl(avatarUrl);
                                redisService.setAvatar(consultUser.getUserId(), avatarUrl);
                            }
                            response
                                .setUserRole(cacheService.getUserRole(consultUserMap.get(dto.getUser().getUserId())));
                            if (StringUtils.isBlank(response.getName())) {
                                response.setName(TianXiaoConstant.ANONYMOUS_CONSULT_USER);
                            }
                            if (!isShow) {
                                response.setMobile(MaskUtil.maskMobile(response.getMobile()));
                            }
                            dto.setUser(response);
                        } else {
                            iterator.remove();
                            log.warn("[Message] userId is not exist." + dto.getUser().getUserId());
                        }

                    }
                }
            } catch (Exception e) {
                logger.error("[Message] pull message Exception,", e);
                iterator.remove();
            }
        }
        return retList;
    }

    private UserResponse getUserResponse(ConsultMessage msg, long number, int cascadeId) {
        UserResponse user = new UserResponse();
        long oppositeUserId;
        MsgUserRole oppositeRole;
        MsgUserRole senderRole = MsgUserRole.getByCode(msg.getSenderRole());
        MsgUserRole receiverRole = MsgUserRole.getByCode(msg.getReceiverRole());
        logger.info("[ConsultMessage] senderRole=" + senderRole + ";receiverRole=" + receiverRole);
        logger.info("[ConsultMessage] senderRole=" + msg.getSenderRole() + ";receiverRole=" + msg.getReceiverRole());
        if (senderRole == null || receiverRole == null) {
            return null;
        }
        if (isLoginUserSendMsg(number, cascadeId, msg)) {
            // 发送人是当前用户，对方为接收方
            oppositeUserId = msg.getReceiverId();
            oppositeRole = receiverRole;
        } else {
            // 接收人是当前用户，发送人是对方
            oppositeUserId = msg.getSenderId();
            oppositeRole = senderRole;
        }
        user.setUserId(oppositeUserId);
        user.setUserRole(oppositeRole.getValue());
        return user;
    }

    private boolean isLoginUserSendMsg(Long orgNumber, int cascadeId, ConsultMessage msg) {
        log.info("cascadeId=" + cascadeId + ";orgNumber=" + orgNumber + ";senderId=" + msg.getSenderId());
        MsgUserRole msgUserRole = MsgUserRole.getByCode(msg.getSenderRole());
        if (msgUserRole == MsgUserRole.BRANCH_HEADER || msgUserRole == MsgUserRole.HEADER) {
            return (cascadeId == 0) && (orgNumber.longValue() == msg.getSenderId());
        } else {
            return (cascadeId != 0) && (cascadeId == msg.getSenderId());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void receiveWechatMsg(ConsultMessage message) {
        try {
            messageDao.insertMessage(message);
        } catch (Exception e) {
            logger.info("[ConsultMessage] message = "
                + ToStringBuilder.reflectionToString(message, ToStringStyle.SHORT_PREFIX_STYLE));
            logger.error("[ConsultMessage] Insert Exception.", e);
        }
    }

    @Override
    public List<ConsultMessage> listDialogMessage(Long orgId, Integer cascadeId, UserIdentify user1, UserIdentify user2,
        Long lastMsgId, Integer limit, boolean gtLastMsgId) {
        List<ConsultMessage> messageList = messageDao.selectDialogMsg(user1, user2, lastMsgId, limit, gtLastMsgId);
        if (messageList != null) {
            Collections.sort(messageList,(o1,o2)->(int)(o1.getId()-o2.getId()));

            for (ConsultMessage msg : messageList) {
                if (msg.getMsgType() == MsgType.CARD.getValue() && MsgUserRole.isSubOrg(msg.getReceiverRole())) {
                    boolean isShow = orgService.isShowMobile(orgId, cascadeId);
                    if (!isShow) {
                        msg.setContent(MsgContentFactory.maskMobile(msg.getContent()));
                    }
                }
            }
        }
        return messageList;
    }

    @Override
    public UserResponse getUserInfo(long orgId, long userId, int userRole) {
        logger.info("[Message] Get user info.orgId={},userId={},userRole={}", orgId, userId, userRole);
        boolean isShow = orgService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (MsgUserRole.isOrg(userRole)) {
            long cascadeId = userId;
            if (MsgUserRole.isHeader(userRole)) {
                cascadeId = 0;
            }
            int role = orgService.getOrgAccountType(orgId, cascadeId).getValue();
            if (MsgUserRole.isHeader(role)) {
                UserResponse response = new UserResponse();
                OrgCacheDto orgCacheDto = cacheService.getOrg(userId);
                if (orgCacheDto == null) {
                    logger.warn("[Message] param error.");
                    return null;
                }
                OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgCacheDto.getOrgId().intValue());
                response.setName(orgInfo.getContacts());
                response.setUserId(userId);
                response.setUserRole(role);
                response.setAvatarUrl(getLogo(orgId));
                return response;
            } else {
                UserResponse response = new UserResponse();
                TXCascadeCredential cascadeCredential = null;
                TXCascadeAccount cascadeAccount = null;
                cascadeAccount = cascadeAccountDao.getById(userId);
                if (cascadeAccount == null) {
                    logger.warn("[Message] param error.");
                    return null;
                }
                cascadeCredential = cascadeCredentialDao.getById(cascadeAccount.getCredentialId());
                response.setName(cascadeCredential.getName());
                response.setUserId(userId);
                response.setUserRole(role);
                if (StringUtils.isNotBlank(cascadeCredential.getAvatar())) {
                    response.setAvatarUrl(cascadeCredential.getAvatar());
                } else {
                    response.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
                }
                return response;
            }
        } else if (MsgUserRole.isStu(userRole)) {
            TxConsultUser user = consultUserDao.getById(userId);
            int role = cacheService.getUserRole(user);
            consulterAPIService.batchSetConsultAvatarUrl(Arrays.asList(user));
            UserResponse response = UserResponse.getInstance(user);
            response.setName(user.getName());
            response.setAvatarUrl(user.getPortrait());
            response.setUserRole(role);
            if (StringUtils.isBlank(response.getName())) {
                response.setName(TianXiaoConstant.ANONYMOUS_CONSULT_USER);
            }
            if (!isShow) {
                response.setMobile(MaskUtil.maskMobile(response.getMobile()));
            }
            redisService.setAvatar(userId, response.getAvatarUrl());
            return response;
        }
        return null;
    }

    /**
     * 获取机构LOGO地址
     *
     * @param orgId
     * @return
     */
    private String getLogo(long orgId) {
        String logo = OrgImgType.ORG_LOGO.getDefaultUrl();
        try {
            List<OrgPhoto> photos = orgPhotoDao.getByOrgIdAndCategory((int) orgId, OrgImgType.ORG_LOGO.getValue());
            if (photos != null && !photos.isEmpty()) {
                OrgPhoto photo = photos.get(0);
                Integer storageId = photo.getOrgStorageId();
                if (storageId != null) {
                    OrgStorage storage = this.orgStorageDao.getById(storageId.longValue());
                    if (storage != null) {
                        logo = this.constructUrl(storage);
                    }
                }
            }
        } catch (Exception e) {
            log.error("get org logo failed, e:{}", e);
        }
        return logo;
    }

    private String constructUrl(OrgStorage storage) {
        String imgServer = PropertiesReader.getValue("upload", "img.server");
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = ((MIMEType.values())[storage.getMimeType() - 1]).getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int syncData(PageDto pageDto, int maxId, int minId) {
        return 0;
    }
}