/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.api;

import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.dto.BindInfo;
import com.baijia.tianxiao.sal.push.dto.LinkDeviceInfo;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.dto.PushDeviceInfo;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.PushResult;
import com.baijia.tianxiao.sal.push.dto.UserDto;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushApi {
    private static final Logger logger = LoggerFactory.getLogger(PushApi.class);

    public static LinkDeviceInfo getLinkPlatformDeviceList(String uid, String bizType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uids", uid);
        params.put("bizType", bizType);
        logger.info("[Device] Query param = " + params);
        String str = HttpClientUtils.doPost((String)Config.LINK_PLATFORM_DEVICE_INFO_URL, params);
        logger.info("[Device] Query result = " + str);
        Gson gson = new Gson();
        return (LinkDeviceInfo)gson.fromJson(str, LinkDeviceInfo.class);
    }

    public static PushDeviceInfo getPushDeviceList(String uid, String bizType) {
        long start = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", uid);
        params.put("bizType", bizType);
        logger.info("[Device] Query param = " + params);
        String str = HttpClientUtils.doPost((String)Config.PUSH_DEVICE_INFO_URL, params);
        logger.info("[Device] Get push DeviceList result=" + str + ";cost time=" + (System.currentTimeMillis() - start));
        Gson gson = new Gson();
        return (PushDeviceInfo)gson.fromJson(str, PushDeviceInfo.class);
    }

    public static void main(String[] args) {
        LinkDeviceInfo result = PushApi.getLinkPlatformDeviceList("3618_0", "tx:cccr:TX_PUSH");
        System.out.println(result);
        PushDeviceInfo result2 = PushApi.getPushDeviceList("3618_0", "tx:cccr:TX_PUSH");
        System.out.println(result2);
    }

    public static void sendMsg(ConsultMessage message, MsgUser msgUser, PushTokenConfig config) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        long start = System.currentTimeMillis();
        parameterMap.put("uid", config.getUser_id());
        parameterMap.put("bizType", config.getBiz_type());
        parameterMap.put("deviceId", config.getDeviceId());
        parameterMap.put("message", PushApi.getMessage(message, msgUser));
        logger.info("[LinkPlatform] param= " + parameterMap);
        PushResult result = null;
        Gson gson = new Gson();
        try {
            String str = HttpClientUtils.doPost((String)Config.LINK_PLATFORM_SEND_MSG_URL, parameterMap);
            logger.info("[LinkPlatform] Link Platform result:{};cost time={}", (Object)str, (Object)(System.currentTimeMillis() - start));
            result = (PushResult)gson.fromJson(str, PushResult.class);
        }
        catch (Exception e) {
            logger.info("[LinkPlatform] ParameterMap:{};cost time={}", parameterMap, (Object)(System.currentTimeMillis() - start));
            logger.warn("[LinkPlatform] Exception:", (Throwable)e);
        }
        logger.info("[LinkPlatform] Result =" + ToStringBuilder.reflectionToString((Object)result));
        boolean i = true;
        if (result == null || result.getCode() != 1) {
            logger.warn("[LinkPlatform] :{}", parameterMap);
        }
    }

    private static String getMessage(ConsultMessage message, MsgUser msgUser) {
        Gson gson = new Gson();
        HashMap payloadMap = new HashMap();
        ArrayList<PushDto> list = new ArrayList<PushDto>();
        PushDto pushDto = PushDto.getInstance(message);
        pushDto.setUser(UserDto.getInstance(msgUser));
        pushDto.getMsg().setContent(MsgContentFactory.getContent(message));
        list.add(pushDto);
        payloadMap.put("list", list);
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", "msg-message");
        messageMap.put("data", payloadMap);
        messageMap.put("type", "biz");
        return gson.toJson(messageMap);
    }

    public static void pushMsg(PushConfig config, PushTokenConfig tokenConfig) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("uid", tokenConfig.getUser_id());
        parameterMap.put("bizType", tokenConfig.getBiz_type());
        parameterMap.put("deviceDomain", tokenConfig.getDevice_domain().toString());
        parameterMap.put("deviceId", tokenConfig.getDeviceId());
        parameterMap.put("message", PushApi.getJsonMsg(config));
        logger.info("[NewPush]Param = " + parameterMap);
        try {
            String pushRetStr = HttpClientUtils.doPost((String)Config.PUSH_SEND_MSG_URL, parameterMap);
            logger.info("[NewPush] Push result:{}", (Object)pushRetStr);
        }
        catch (Exception e) {
            logger.error("[NewPush]parameterMap:{}", parameterMap);
            logger.error("[NewPush] Exception:", (Throwable)e);
            throw new RuntimeException("\u5916\u90e8\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25");
        }
    }

    public static void bind(BindInfo bindInfo) {
        Gson gson = new Gson();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pushBindRecordStr", gson.toJson((Object)bindInfo));
        logger.info("[Push] Bind Param=" + param);
        String result = HttpClientUtils.doGet((String)Config.PUSH_BIND_URL, param);
        logger.info("[Push] Bind result=" + result);
    }

    public static void unBind(BindInfo bindInfo) {
        Gson gson = new Gson();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pushBindRecordStr", gson.toJson((Object)bindInfo));
        logger.info("[Push] Un Bind Param=" + param);
        String result = HttpClientUtils.doGet((String)Config.PUSH_UN_BIND_URL, param);
        logger.info("[Push] Un Bind result=" + result);
    }

    public static Map<String, String> getMap(BindInfo bindInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", bindInfo.getUserId());
        map.put("deviceId", bindInfo.getDeviceId());
        map.put("deviceType", bindInfo.getDeviceType());
        map.put("userType", bindInfo.getUserType());
        if (bindInfo.getChannelList() != null && bindInfo.getChannelList().size() > 0) {
            Gson gson = new Gson();
            map.put("channelList", gson.toJson(bindInfo.getChannelList()));
        }
        return map;
    }

    private static String getJsonMsg(PushConfig config) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", config.getTip());
        map.put("s", config.getJumpUrl());
        map.put("title", config.getTitle());
        Gson gson = new Gson();
        return gson.toJson(map);
    }
}

