/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCommonRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.sal.push.service.OrgService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushOrgCommonSerive")
public class OrgServiceImpl
implements OrgService {
    private static final Logger log = LoggerFactory.getLogger(OrgServiceImpl.class);
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private TXCommonRuleDao commonRuleDao;

    @Override
    public boolean isShowMobile(Long orgId, Integer cascadeId) {
        MsgUserRole userType = this.getOrgAccountType(orgId, cascadeId == null ? 0L : cascadeId.longValue());
        if (MsgUserRole.isHeader((int)userType.getValue())) {
            return true;
        }
        TXCommonRule commonRule = this.commonRuleDao.getByOrgId(Integer.valueOf(orgId.intValue()));
        if (commonRule != null) {
            return commonRule.getStudentMobileRule() == 0;
        }
        return true;
    }

    @Override
    public MsgUserRole getOrgAccountType(long orgId, long cascadeId) {
        log.info("OrgId=" + orgId + ";cascadeId=" + cascadeId);
        if (cascadeId == 0L) {
            OrgSubAccount subAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf((int)orgId));
            if (subAccount != null) {
                return MsgUserRole.HEADER;
            }
            return MsgUserRole.BRANCH_HEADER;
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Long.valueOf(cascadeId), new String[0]);
        if (cascadeAccount.getAccountType() == 3) {
            return MsgUserRole.MANAGER;
        }
        return MsgUserRole.STAFF;
    }

    @Override
    public OrgSubAccount getOrgAccountInfo(int orgId) {
        return this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId), new String[0]);
    }
}

