package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dto.content.MsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * Created by liuxp on 15/12/4.
 */
@Data
public class MsgInfoDto {
    private int msgType;// 0-文本 1-图片 2-语音 3-位置 5-卡片
    private long msgId;
    private long sender;//发送人id
    private Integer senderType;
    private Integer senderRole;
    private long receiver;//接收人id
    private Integer receiverRole;
    private Integer receiverType;
    private long time;
    private MsgContent content;

    public static MsgInfoDto getInstance(ConsultMessage message) {
        MsgInfoDto msg = new MsgInfoDto();
        msg.setMsgType(message.getMsgType());
        msg.setMsgId(message.getId());
        msg.setSenderRole(message.getSenderRole());
        msg.setContent(ContentDto.getInstance(message));
        msg.setSender(message.getSenderId());
        msg.setReceiver(message.getReceiverId());
        msg.setReceiverRole(message.getReceiverRole());
        msg.setTime(message.getCreateTime().getTime());
        msg.setReceiverType(MsgUserType.getUserType(msg.getReceiverRole()).getValue());
        msg.setSenderType(MsgUserType.getUserType(msg.getSenderRole()).getValue());
        return msg;
    }

}
