package com.baijia.tianxiao.sal.push.constant;

import com.baijia.commons.lang.utils.PropertiesReader;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 15/12/5.
 */
@Slf4j
public class Config {

    public static final String SERVICE_URL;
    public static final String APP_ID;
    public static final String APP_KEY;
    public static final String CR_DOMAIN;//长链接平台
    public static final String PUSH_DOMAIN;//推送平台
    public static final String LINK_PLATFORM_DEVICE_INFO_URL;
    public static final String LINK_PLATFORM_SEND_MSG_URL;

    public static final String PUSH_SEND_MSG_URL;
    public static final String PUSH_BIND_URL;
    public static final String PUSH_UN_BIND_URL;
    public static final String PUSH_DEVICE_INFO_URL;


    public static final String NEW_APP_ID = "1234";

    static {
        Properties prop = PropertiesReader.fillProperties("config.properties");
        SERVICE_URL = prop.getProperty("GLOBAL_SERVICE_URL");
        APP_ID = prop.getProperty("SERVICE_APP_ID");
        APP_KEY = prop.getProperty("SERVICE_APP_KEY");
        CR_DOMAIN = prop.getProperty("cr.domain");
        PUSH_DOMAIN = prop.getProperty("push.domain");

        PUSH_SEND_MSG_URL = PUSH_DOMAIN+"pushMessage/single";
        PUSH_BIND_URL = PUSH_DOMAIN+"pushBind/bind";
        PUSH_UN_BIND_URL = PUSH_DOMAIN+"pushBind/unbind";
        PUSH_DEVICE_INFO_URL = PUSH_DOMAIN+"pushBind/queryBindStatusByPrefix";

        LINK_PLATFORM_DEVICE_INFO_URL = CR_DOMAIN+"connectStatus/findUsersSessionByPrefix";
        LINK_PLATFORM_SEND_MSG_URL = CR_DOMAIN+"messageRoute/txSendSingle";

        log.info("load push config SERVICE_URL:{}, APP_ID:{}, APP_KEY:{}",SERVICE_URL, APP_ID, APP_KEY);

    }
}
