/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.utils;

import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.MsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.TextMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.sal.push.enums.NoticeType;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgContentFactory {
    private static final Logger log = LoggerFactory.getLogger(MsgContentFactory.class);

    public static MsgContent getContent(ConsultMessage message) {
        log.info("Message Type = " + message.getMsgType());
        MsgType msgType = MsgType.getTypeByValue((int)message.getMsgType());
        switch (msgType) {
            case TEXT: {
                TextMsgContent txt = new TextMsgContent();
                txt.setText(message.getContent());
                return txt;
            }
            case PICTURE: {
                ImageMsgContent img = new ImageMsgContent();
                img.setHeight(message.getHeight());
                img.setWidth(message.getWidth());
                img.setUrl(message.getUrl());
                return img;
            }
            case VOICE: {
                AudioMsgContent audio = new AudioMsgContent();
                audio.setUrl(message.getUrl());
                audio.setCallId(message.getCallId().longValue());
                audio.setLen(message.getLength());
                return audio;
            }
            case NOTICE: {
                Gson gson = new Gson();
                NoticeMsgContent notice = (NoticeMsgContent)gson.fromJson(message.getContent(), NoticeMsgContent.class);
                NoticeType noticeType = NoticeType.getByValue(notice.getType());
                notice.setText(noticeType.getContent());
                notice.setTitle(noticeType.getTitle());
                return notice;
            }
            case CARD: {
                Gson cardGson = new Gson();
                CardMsgContent msgContent = (CardMsgContent)cardGson.fromJson(message.getContent(), CardMsgContent.class);
                return msgContent;
            }
        }
        log.warn("[Message] message type is error.type=" + message.getMsgType());
        return null;
    }

    public static MsgContent jsonToContent(ConsultMessage message) {
        log.info("Message Type = " + message.getMsgType() + ";content=" + message.getContent());
        Gson gson = new Gson();
        MsgType msgType = MsgType.getTypeByValue((int)message.getMsgType());
        switch (msgType) {
            case TEXT: {
                TextMsgContent txt = (TextMsgContent)gson.fromJson(message.getContent(), TextMsgContent.class);
                return txt;
            }
            case PICTURE: {
                ImageMsgContent img = (ImageMsgContent)gson.fromJson(message.getContent(), ImageMsgContent.class);
                return img;
            }
            case VOICE: {
                AudioMsgContent audio = (AudioMsgContent)gson.fromJson(message.getContent(), AudioMsgContent.class);
                return audio;
            }
            case NOTICE: {
                NoticeMsgContent notice = (NoticeMsgContent)gson.fromJson(message.getContent(), NoticeMsgContent.class);
                NoticeType noticeType = NoticeType.getByValue(notice.getType());
                notice.setText(noticeType.getContent());
                notice.setTitle(noticeType.getTitle());
                return notice;
            }
            case CARD: {
                CardMsgContent msgContent = (CardMsgContent)gson.fromJson(message.getContent(), CardMsgContent.class);
                return msgContent;
            }
        }
        log.warn("[Message] message type is error.type=" + message.getMsgType());
        return null;
    }

    public static String getContentByConsultMessageDto(ConsultMessageDto message) {
        log.info("Message Type = " + message.getMsgType());
        MsgType msgType = MsgType.getTypeByValue((int)message.getMsgType());
        String text = null;
        Gson gson = new Gson();
        switch (msgType) {
            case TEXT: {
                TextMsgContent txt = (TextMsgContent)gson.fromJson(message.getText(), TextMsgContent.class);
                text = txt.getText();
                return text;
            }
            case PICTURE: {
                text = "[\u56fe\u7247]";
                return text;
            }
            case VOICE: {
                text = "[\u8bed\u97f3]";
                return text;
            }
            case NOTICE: {
                NoticeMsgContent notice = (NoticeMsgContent)gson.fromJson(message.getText(), NoticeMsgContent.class);
                NoticeType noticeType = NoticeType.getByValue(notice.getType());
                notice.setText(noticeType.getContent());
                notice.setTitle(noticeType.getTitle());
                text = notice.getText();
                return text;
            }
            case CARD: {
                CardMsgContent msgContent = (CardMsgContent)gson.fromJson(message.getText(), CardMsgContent.class);
                text = msgContent.getText();
                return text;
            }
        }
        log.warn("[Message] message type is error.type=" + message.getMsgType());
        return null;
    }
}

