/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.push.constant.MsgSettingStatus;
import com.baijia.tianxiao.dal.push.dao.AccountMsgSettingDao;
import com.baijia.tianxiao.dal.push.po.AccountMsgSetting;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.push.service.PushSettingService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushSettingServiceImpl
implements PushSettingService {
    private static final Logger log = LoggerFactory.getLogger(PushSettingServiceImpl.class);
    @Autowired
    private AccountMsgSettingDao settingDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public void setMsgSwitch(Long orgId, Integer cascadeId, int status) {
        boolean flag = false;
        if (status == MsgSettingStatus.OPEN.getValue()) {
            flag = true;
        } else {
            List existSettings;
            if (cascadeId == null) {
                cascadeId = 0;
            }
            if (GenericsUtils.notNullAndEmpty((Object)(existSettings = this.settingDao.getAccountMsgSettingExceptItSelf(orgId, cascadeId)))) {
                flag = true;
            }
        }
        if (flag) {
            AccountMsgSetting setting = this.settingDao.selectAccountMsgSetting(orgId, cascadeId);
            if (setting == null) {
                setting = new AccountMsgSetting();
                setting.setOrgId(orgId.longValue());
                setting.setCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId));
                setting.setMsgSwitch(status);
                setting.setCreateTime(new Date());
                setting.setUpdateTime(new Date());
                this.settingDao.insertAccountMsgSetting(setting);
            } else {
                setting.setMsgSwitch(status);
                setting.setUpdateTime(new Date());
                this.settingDao.updateAccountMsgSetting(setting);
            }
        } else {
            log.warn("[Message] Not allow close.orgId=" + orgId + ";cascadeId=" + cascadeId);
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_ALLOW_CLOSE);
        }
    }

    @Override
    public int getMsgSwitch(Long orgId, Integer cascadeId) {
        AccountMsgSetting setting = this.settingDao.selectAccountMsgSetting(orgId, cascadeId);
        if (setting == null) {
            return MsgSettingStatus.OPEN.getValue();
        }
        return setting.getMsgSwitch();
    }
}

