/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.push.dto.MsgUser;

public class UserDto {
    private long consultUserId;
    private int intentLevel;
    private String mobile;
    private String name;
    private Long userNumber;
    private int userRole;

    public long getConsultUserId() {
        return this.consultUserId;
    }

    public void setConsultUserId(long consultUserId) {
        this.consultUserId = consultUserId;
    }

    public int getIntentLevel() {
        return this.intentLevel;
    }

    public void setIntentLevel(int intentLevel) {
        this.intentLevel = intentLevel;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(Long userNumber) {
        this.userNumber = userNumber;
    }

    public int getUserRole() {
        return this.userRole;
    }

    public void setUserRole(int userRole) {
        this.userRole = userRole;
    }

    public static UserDto getInstance(MsgUser msgUser) {
        if (msgUser == null) {
            return null;
        }
        UserDto userDto = new UserDto();
        userDto.setConsultUserId(msgUser.getUserId());
        userDto.setIntentLevel(msgUser.getIntentLevel());
        userDto.setMobile(msgUser.getMobile());
        userDto.setName(msgUser.getName());
        userDto.setUserNumber(msgUser.getNumber());
        userDto.setUserRole(msgUser.getRole().getCode());
        return userDto;
    }

    public static UserDto getInstance(TxConsultUser user) {
        if (user == null) {
            return null;
        }
        UserDto userDto = new UserDto();
        userDto.setConsultUserId(user.getId());
        userDto.setIntentLevel(user.getIntensionLevel());
        userDto.setMobile(user.getMobile());
        userDto.setName(user.getName());
        userDto.setUserNumber(user.getUserNumber());
        userDto.setUserRole(UserRoleEnum.STUDENT.getCode());
        return userDto;
    }

    public static UserDto getInstance(User user, Long consultUserId) {
        if (user == null) {
            return null;
        }
        UserDto userDto = new UserDto();
        userDto.setConsultUserId(consultUserId);
        userDto.setIntentLevel(0);
        userDto.setMobile(user.getMobile());
        userDto.setName(user.getName());
        userDto.setUserNumber(user.getNumber());
        userDto.setUserRole(UserRoleEnum.STUDENT.getCode());
        return userDto;
    }
}

