/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceCacheImpl
implements UserCacheService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceCacheImpl.class);
    @Autowired
    private OrgAccountDao accountDao;
    @Autowired
    private TxConsultUserDao userDao;
    @Autowired
    private AuthorizationInfoDao orgWechatDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    private static Cache<Long, ConsultUserCacheDto> userCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static Cache<Long, OrgCacheDto> orgCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build();

    @Override
    public ConsultUserCacheDto getConsultUser(Long consultUserId) {
        ConsultUserCacheDto user = (ConsultUserCacheDto)userCache.getIfPresent((Object)consultUserId);
        log.info("getConsultUser---------ConsultUserCacheDto user={}", (Object)user);
        if (user == null) {
            user = new ConsultUserCacheDto();
            TxConsultUser consultUser = (TxConsultUser)this.userDao.getById((Serializable)consultUserId, new String[0]);
            log.info("getConsultUser---------TxConsultUser consultUser={}", (Object)consultUser);
            if (consultUser != null) {
                if (consultUser.getUserNumber() != null) {
                    user.setNumber(consultUser.getUserNumber().intValue());
                }
                user.setWechatOpenId(consultUser.getWeixinOpenId());
                user.setUserId(consultUser.getUserId());
                OrgStudent orgStudent = this.orgStudentDao.getStudent(consultUser.getOrgId(), consultUser.getUserId(), null, new String[0]);
                log.info("[StudentId]" + ToStringBuilder.reflectionToString((Object)orgStudent));
                if (orgStudent != null) {
                    user.setStudentId(orgStudent.getId());
                    log.info("[StudentId]" + orgStudent.getId());
                }
                userCache.put((Object)consultUserId, (Object)user);
            } else {
                log.warn("[ConsultUser] User is not exist.consultUserId = " + consultUserId);
            }
        }
        return user;
    }

    @Override
    public OrgCacheDto getOrg(Long number) {
        OrgCacheDto org = (OrgCacheDto)orgCache.getIfPresent((Object)number);
        if (org == null) {
            OrgAccount account = this.accountDao.getAccountByNumber(Integer.valueOf(number.intValue()), new String[]{"id"});
            if (account != null) {
                org = new OrgCacheDto();
                org.setOrgId(account.getId().longValue());
                AuthorizationInfo auth = this.orgWechatDao.getByOrgId(account.getId());
                if (auth != null) {
                    org.setWechatAppId(auth.getAuthorizerAppId());
                    orgCache.put((Object)number, (Object)org);
                } else {
                    log.warn("[Org] Authorization is invalidate.ID = " + account.getId());
                }
            } else {
                log.warn("[Org] Org is not exist.number = " + number);
            }
        }
        return org;
    }

    @Override
    public Long getUserIdFromDb(Long consultUserId) {
        TxConsultUser consultUser = (TxConsultUser)this.userDao.getById((Serializable)consultUserId, new String[0]);
        if (consultUser != null) {
            ConsultUserCacheDto user = this.getConsultUser(consultUserId);
            user.setUserId(consultUser.getUserId());
            if (consultUser.getUserNumber() != null) {
                user.setNumber(consultUser.getUserNumber().intValue());
            }
            consultUser.getUserId();
        }
        return null;
    }

    @Override
    public Long getStudentIdFromDb(Long consultUserId, Long orgId) {
        OrgStudent orgStudent;
        Long userId;
        ConsultUserCacheDto user = this.getConsultUser(consultUserId);
        if (user.getUserId() == null && (userId = this.getUserIdFromDb(consultUserId)) != null && (orgStudent = this.orgStudentDao.getStudent(orgId, userId, null, new String[0])) != null) {
            user.setStudentId(orgStudent.getId());
            return orgStudent.getId();
        }
        return null;
    }
}

