/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PushConfig {
    private static String WECHAT_ACTION = "consult_wx";
    private static String APPOINTMENT_ACTION = "consult_reserve";
    private static String TELEPHONE_ACTION = "consult_call";
    private static final Map<ConsultType, String> tipMap = new HashMap<ConsultType, String>();
    private String tip;
    private String jumpUrl;

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public static PushConfig getWechatConfig(long consultId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(ConsultType.WECHAT));
        String url = NativeUrlUtil.getUrl(WECHAT_ACTION);
        url = NativeUrlUtil.addParam(url, "id", consultId);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getAppointmentConfig(Long consultId, Long userId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(ConsultType.APPOINTMENT));
        String url = NativeUrlUtil.getUrl(APPOINTMENT_ACTION);
        url = userId != null ? NativeUrlUtil.addParam(url, "sid", userId) : NativeUrlUtil.addParam(url, "cid", consultId);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getTelConfig(long consultId, String mobile, long callId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(ConsultType.TELEPHONE));
        String url = NativeUrlUtil.getUrl(TELEPHONE_ACTION);
        url = NativeUrlUtil.addParam(url, "cid", consultId);
        url = NativeUrlUtil.addParam(url, "m", mobile);
        url = NativeUrlUtil.addParam(url, "id", callId);
        config.setJumpUrl(url);
        return config;
    }

    public static void main(String[] args) {
        System.out.println(ToStringBuilder.reflectionToString((Object)PushConfig.getTelConfig(10L, "1111", 11L)));
    }

    static {
        tipMap.put(ConsultType.WECHAT, "\u60a8\u6709\u4e00\u6761\u5fae\u4fe1\u5546\u673a\uff0c\u5feb\u53bb\u7262\u7262\u6293\u4f4f");
        tipMap.put(ConsultType.APPOINTMENT, "\u6709\u4e2a\u9884\u7ea6\u7559\u5355\uff0c\u8d76\u7d27\u53bb\u67e5\u770b\u5427\u3002");
        tipMap.put(ConsultType.TELEPHONE, "\u60a8\u6709\u6765\u7535\u54a8\u8be2\u672a\u63a5\u542c\uff0c\u4e0d\u8981\u64e6\u80a9\u800c\u8fc7\u3001\u8d76\u7d27\u56de\u62e8\u7535\u8bdd\u5427");
    }
}

