/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.push.constant.MsgSettingStatus;
import com.baijia.tianxiao.dal.push.dao.AccountMsgSettingDao;
import com.baijia.tianxiao.dal.push.po.AccountMsgSetting;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.push.service.PushSettingService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushSettingServiceImpl
implements PushSettingService {
    private static final Logger log = LoggerFactory.getLogger(PushSettingServiceImpl.class);
    @Autowired
    private AccountMsgSettingDao settingDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public void setMsgSwitch(Long orgId, Integer cascadeId, int status) {
        AccountMsgSetting setting;
        if (status == MsgSettingStatus.CLOSE.getValue()) {
            if (cascadeId == null) {
                cascadeId = 0;
            }
            List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
            List cascadeIds = ListUtil.toKeyList((Collection)txCascadeAccounts, (String)"id", TXCascadeAccount.class);
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (orgSubAccount != null) {
                cascadeIds.add(0);
            }
            log.info("cascadeIds param:{}, cascadeId param:{}, orgId param:{}", new Object[]{cascadeIds, cascadeId, orgId});
            List offSettings = this.settingDao.selectSettingByOrgId(orgId, Integer.valueOf(MsgSettingStatus.CLOSE.getValue()));
            List offCascadeIds = ListUtil.toKeyList((Collection)offSettings, (String)"cascadeId", AccountMsgSetting.class);
            log.info("offCascadeIds param:{}, cascadeId param:{}, orgId param:{}", new Object[]{offCascadeIds, cascadeId, orgId});
            cascadeIds.removeAll(offCascadeIds);
            cascadeIds.remove(cascadeId);
            if (GenericsUtils.isNullOrEmpty((Object)cascadeIds)) {
                log.warn("[Message] Not allow close.orgId=" + orgId + ";cascadeId=" + cascadeId);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_ALLOW_CLOSE);
            }
        }
        if ((setting = this.settingDao.selectAccountMsgSetting(orgId, cascadeId)) == null) {
            setting = new AccountMsgSetting();
            setting.setOrgId(orgId.longValue());
            setting.setCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId));
            setting.setMsgSwitch(status);
            setting.setCreateTime(new Date());
            setting.setUpdateTime(new Date());
            this.settingDao.insertAccountMsgSetting(setting);
        } else {
            setting.setMsgSwitch(status);
            setting.setUpdateTime(new Date());
            this.settingDao.updateAccountMsgSetting(setting);
        }
    }

    @Override
    public int getMsgSwitch(Long orgId, Integer cascadeId) {
        AccountMsgSetting setting = this.settingDao.selectAccountMsgSetting(orgId, cascadeId);
        if (setting == null) {
            return MsgSettingStatus.OPEN.getValue();
        }
        return setting.getMsgSwitch();
    }
}

