/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dao.MsgPulledRecordDao;
import com.baijia.tianxiao.dal.push.dto.content.MsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.MsgPulledRecord;
import com.baijia.tianxiao.dal.push.po.UserIdentify;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.push.dto.CommonMsgUser;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.newpush.MsgResponse;
import com.baijia.tianxiao.sal.push.dto.newpush.UserResponse;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.MessageSendExecutor;
import com.baijia.tianxiao.sal.push.service.OrgService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.push.service.impl.ConsultAvatarUrlServiceImpl;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sal.push.utils.MsgUserFactory;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultMessageServiceImpl
implements ConsultMessageService {
    private static final Logger log = LoggerFactory.getLogger(ConsultMessageServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private MsgPulledRecordDao pulledRecordDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private UserCacheService cacheService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private TXCascadeCredentialDao cascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private ConsultAvatarUrlServiceImpl consultAvatarUrlService;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private MessageSendExecutor messageSendExecutor;
    @Autowired
    private OrgService orgService;
    private ConcurrentHashMap<Integer, String> orgLogoMap = new ConcurrentHashMap();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message) {
        this.messageSendExecutor.sendConsultMessage(sender, receiver, message, null);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message, Integer givenReceiverId) {
        this.messageSendExecutor.sendConsultMessage(sender, receiver, message, givenReceiverId);
        return true;
    }

    @Override
    public boolean sendNotice(Long orgId, Integer cascadeId, NoticeMsgContent content) {
        this.messageSendExecutor.sendNotice(orgId, cascadeId, content);
        return true;
    }

    @Override
    public boolean sendStaffMsg(long orgId, Integer cascadeId, ConsultMessage message) {
        this.messageSendExecutor.sendStaffMsg(orgId, cascadeId, message);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addMessage(ConsultMessage message) {
        try {
            this.messageDao.insertMessage(message);
            return true;
        }
        catch (Exception e) {
            this.logger.info("[ConsultMessage] message = " + ToStringBuilder.reflectionToString((Object)message, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            this.logger.error("[ConsultMessage] Insert Exception.", (Throwable)e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public List<PushDto> getNewMessageList(long userId, Long msgId) {
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<MsgResponse> pullMessageList(long orgId, Integer cascadeId, String deviceId, Long msgId) {
        this.logger.info("userId={}\uff0ccascadeId={}\uff0cmsgId={};deviceId={}", new Object[]{orgId, cascadeId, msgId, deviceId});
        Integer number = this.cacheService.getOrgNumber(orgId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf((int)orgId), new String[]{"name", "contacts"});
        if (number == null) {
            this.logger.warn("[PullMsg] orgId is not exist.id = " + orgId);
            return Collections.emptyList();
        }
        if (cascadeId == null) {
            cascadeId = 0;
        }
        boolean isNull = false;
        MsgPulledRecord pulledRecord = null;
        if (msgId == null || msgId < 1L) {
            pulledRecord = this.pulledRecordDao.selectPulledRecordByUserId(number.longValue(), cascadeId, deviceId);
            if (pulledRecord == null) {
                isNull = true;
                pulledRecord = this.pulledRecordDao.selectPulledRecordByUserId(number.longValue(), cascadeId, "");
            }
            if (msgId == null) {
                msgId = 0L;
            }
            if (pulledRecord != null) {
                msgId = pulledRecord.getMsgId();
            }
        }
        List msgList = this.messageDao.selectNewOrgRecordList(number.longValue(), cascadeId, msgId.longValue(), 100);
        Collections.sort(msgList, new Comparator<ConsultMessage>(){

            @Override
            public int compare(ConsultMessage o1, ConsultMessage o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        this.logger.info("[ConsultMessage] result list=" + msgList.size());
        ArrayList<MsgResponse> retList = new ArrayList<MsgResponse>();
        if (msgList != null && msgList.size() > 0) {
            if (!isNull) {
                this.pulledRecordDao.updatePulledRecord(number.longValue(), cascadeId, deviceId, ((ConsultMessage)msgList.get(msgList.size() - 1)).getId());
            } else {
                pulledRecord = new MsgPulledRecord();
                pulledRecord.setMsgId(((ConsultMessage)msgList.get(msgList.size() - 1)).getId());
                pulledRecord.setCascadeId(cascadeId);
                pulledRecord.setUserId(number.longValue());
                pulledRecord.setUpdateTime(new Date());
                pulledRecord.setDeviceId(deviceId);
                this.pulledRecordDao.insertPulledRecord(pulledRecord);
            }
            ArrayList<Long> userNumbers = new ArrayList<Long>();
            ArrayList<Long> consultUserIds = new ArrayList<Long>();
            HashSet<Integer> cascadeIds = new HashSet<Integer>();
            boolean isShow = this.orgService.isShowMobile(orgId, cascadeId);
            for (ConsultMessage msg : msgList) {
                MsgResponse dto = MsgResponse.getInstance(msg);
                if (MessageSource.MARKING.getValue() == msg.getConsultType()) {
                    if (msg.getSenderNumber() != -1L) {
                        userNumbers.add(msg.getSenderNumber());
                        UserResponse userDto = new UserResponse();
                        userDto.setNumber(msg.getSenderNumber());
                        dto.setUser(userDto);
                    }
                } else if (MessageSource.NOTICE.getValue() == msg.getConsultType()) {
                    CommonMsgUser commonMsgUser = MsgUserFactory.createSysUser();
                    UserResponse userDto = new UserResponse();
                    userDto.setUserRole(commonMsgUser.getMsgUserRole().getValue());
                    userDto.setUserId(commonMsgUser.getUserId());
                    userDto.setName(commonMsgUser.getName());
                    dto.setUser(userDto);
                } else {
                    MsgUserRole oppositeRole;
                    long oppositeUserId;
                    MsgUserRole senderRole = MsgUserRole.getByCode((Integer)msg.getSenderRole());
                    MsgUserRole receiverRole = MsgUserRole.getByCode((Integer)msg.getReceiverRole());
                    this.logger.info("[Debug] senderRole=" + msg.getSenderRole() + ";receiverRole=" + msg.getReceiverRole());
                    this.logger.info("[Debug] senderRole=" + senderRole + ";receiverRole=" + receiverRole);
                    if (this.isLoginUserSendMsg(number.longValue(), cascadeId, msg)) {
                        oppositeUserId = msg.getReceiverId();
                        oppositeRole = receiverRole;
                    } else {
                        oppositeUserId = msg.getSenderId();
                        oppositeRole = senderRole;
                    }
                    if (MsgUserRole.getStuUsers().contains(oppositeRole)) {
                        consultUserIds.add(oppositeUserId);
                    } else if (MsgUserRole.isSubOrg((int)oppositeRole.getValue())) {
                        cascadeIds.add((int)oppositeUserId);
                    }
                    UserResponse userDto = new UserResponse();
                    userDto.setUserId(oppositeUserId);
                    userDto.setUserRole(oppositeRole.getValue());
                    dto.setUser(userDto);
                    if (msg.getMsgType() == MsgType.CARD.getValue() && MsgUserRole.isSubOrg((int)receiverRole.getValue()) && !isShow) {
                        String content = MsgContentFactory.maskMobile(msg.getContent());
                        content = MsgContentFactory.maskActionMobile(content);
                        msg.setContent(content);
                    }
                }
                dto.getMsg().setContent(MsgContentFactory.jsonToContent(msg));
                retList.add(dto);
            }
            List users = this.userDao.getByNumbers(userNumbers, new String[0]);
            Map userMap = CollectionUtils.extractMap((Collection)users, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, User>(){

                public Long extract(User user) {
                    return user.getNumber();
                }
            });
            List consultUsers = this.consultUserDao.getByIds(consultUserIds, new String[0]);
            Map consultUserMap = CollectionUtils.extractMap((Collection)consultUsers, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, TxConsultUser>(){

                public Long extract(TxConsultUser consultUser) {
                    return consultUser.getId();
                }
            });
            Map nameMap = this.cascadeCredentialDao.getTxCascadCredentialNameByCascdeIds(cascadeIds);
            Map<Long, ConsultAvatarUrlAndNameDto> urlAndNameDtoMap = this.consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultUserIds, orgId);
            Iterator iterator = retList.iterator();
            while (iterator.hasNext()) {
                MsgResponse dto = (MsgResponse)iterator.next();
                try {
                    if (dto.getUser() == null) continue;
                    if (dto.getType() == MessageSource.MARKING.getValue()) {
                        dto.setUser(UserResponse.getInstance((User)userMap.get(dto.getUser().getNumber()), dto.getUser().getUserId()));
                        continue;
                    }
                    if (dto.getType() == MessageSource.NOTICE.getValue()) {
                        this.logger.info("[Message] pull message System user");
                        continue;
                    }
                    MsgUserRole msgUserRole = MsgUserRole.getByCode((Integer)dto.getUser().getUserRole());
                    log.info("[Debug] User=" + ToStringBuilder.reflectionToString((Object)dto.getUser()));
                    if (MsgUserRole.getOrgUsers().contains(msgUserRole)) {
                        UserResponse response;
                        if (MsgUserRole.isHeader((int)dto.getUser().getUserRole())) {
                            response = dto.getUser();
                            OrgCacheDto orgCacheDto = this.cacheService.getOrg(response.getUserId());
                            if (orgCacheDto == null) {
                                iterator.remove();
                                continue;
                            }
                            response.setName(orgInfo.getContacts());
                            response.setUserId(number.intValue());
                            response.setUserType(msgUserRole.getValue());
                            response.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
                            dto.setUser(response);
                            continue;
                        }
                        response = dto.getUser();
                        String name = (String)nameMap.get(dto.getUser().getUserId());
                        this.logger.info("[Message] cascade name=" + name);
                        response.setName(name);
                        response.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
                        dto.setUser(response);
                        continue;
                    }
                    TxConsultUser consultUser = (TxConsultUser)consultUserMap.get(dto.getUser().getUserId());
                    if (consultUser != null) {
                        UserResponse response = UserResponse.getInstance(consultUser);
                        ConsultAvatarUrlAndNameDto urlAndNameDto = urlAndNameDtoMap.get(dto.getUser().getUserId());
                        if (urlAndNameDto == null) {
                            log.info("[Message] urlAndNameDto is null.id=" + response.getUserId());
                            continue;
                        }
                        response.setAvatarUrl(urlAndNameDto.getAvatarUrl());
                        response.setUserRole(this.cacheService.getUserRole((TxConsultUser)consultUserMap.get(dto.getUser().getUserId())));
                        response.setName(urlAndNameDto.getName());
                        if (StringUtils.isBlank((CharSequence)response.getName())) {
                            response.setName("\u8bbf\u5ba2");
                        }
                        if (!isShow) {
                            response.setMobile(MaskUtil.maskMobile((String)response.getMobile()));
                        }
                        dto.setUser(response);
                        continue;
                    }
                    iterator.remove();
                    log.warn("[Message] userId is not exist." + dto.getUser().getUserId());
                }
                catch (Exception e) {
                    this.logger.error("[Message] pull message Exception,", (Throwable)e);
                    iterator.remove();
                }
            }
        }
        return retList;
    }

    private boolean isLoginUserSendMsg(Long orgNumber, int cascadeId, ConsultMessage msg) {
        log.info("cascadeId=" + cascadeId + ";orgNumber=" + orgNumber + ";senderId=" + msg.getSenderId());
        MsgUserRole msgUserRole = MsgUserRole.getByCode((Integer)msg.getSenderRole());
        if (msgUserRole == MsgUserRole.BRANCH_HEADER || msgUserRole == MsgUserRole.HEADER) {
            return cascadeId == 0 && orgNumber.longValue() == msg.getSenderId();
        }
        return cascadeId != 0 && (long)cascadeId == msg.getSenderId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveWechatMsg(ConsultMessage message) {
        try {
            this.messageDao.insertMessage(message);
        }
        catch (Exception e) {
            this.logger.info("[ConsultMessage] message = " + ToStringBuilder.reflectionToString((Object)message, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            this.logger.error("[ConsultMessage] Insert Exception.", (Throwable)e);
        }
    }

    @Override
    public List<ConsultMessage> listDialogMessage(Long orgId, Integer cascadeId, UserIdentify user1, UserIdentify user2, Long lastMsgId, int limit) {
        List messageList = this.messageDao.selectDialogMsg(user1, user2, lastMsgId, limit);
        if (messageList != null) {
            for (ConsultMessage msg : messageList) {
                boolean isShow;
                if (msg.getMsgType() != MsgType.CARD.getValue() || !MsgUserRole.isSubOrg((int)msg.getReceiverRole()) || (isShow = this.orgService.isShowMobile(orgId, cascadeId))) continue;
                msg.setContent(MsgContentFactory.maskMobile(msg.getContent()));
            }
        }
        return messageList;
    }

    @Override
    public UserResponse getUserInfo(long orgId, long userId, int userRole) {
        this.logger.info("[Message] Get user info.orgId={},userId={},userRole={}", new Object[]{orgId, userId, userRole});
        boolean isShow = this.orgService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (MsgUserRole.isOrg((int)userRole)) {
            int role;
            long cascadeId = userId;
            if (MsgUserRole.isHeader((int)userRole)) {
                cascadeId = 0L;
            }
            if (MsgUserRole.isHeader((int)(role = this.orgService.getOrgAccountType(orgId, cascadeId).getValue()))) {
                UserResponse response = new UserResponse();
                OrgCacheDto orgCacheDto = this.cacheService.getOrg(userId);
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgCacheDto.getOrgId().intValue()), new String[0]);
                response.setName(orgInfo.getContacts());
                response.setUserId(userId);
                response.setUserRole(role);
                response.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
                return response;
            }
            UserResponse response = new UserResponse();
            TXCascadeCredential cascadeCredential = null;
            TXCascadeAccount cascadeAccount = null;
            cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Long.valueOf(userId), new String[0]);
            this.logger.info("[Debug] getCredentialId = " + cascadeAccount.getCredentialId());
            cascadeCredential = (TXCascadeCredential)this.cascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
            response.setName(cascadeCredential.getName());
            response.setUserId(userId);
            response.setUserRole(role);
            response.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
            return response;
        }
        if (MsgUserRole.isStu((int)userRole)) {
            TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)Long.valueOf(userId), new String[0]);
            int role = this.cacheService.getUserRole(user);
            ConsultAvatarUrlAndNameDto dto = this.consultAvatarUrlService.getConsultAvatarUrl(userId);
            log.info("ConsultAvatarUrlAndNameDto dto param:{}, userId param:{}, userRole param:{}", new Object[]{dto, userId, role});
            UserResponse response = UserResponse.getInstance(user);
            response.setName(dto.getName());
            response.setAvatarUrl(dto.getAvatarUrl());
            response.setUserRole(role);
            if (StringUtils.isBlank((CharSequence)response.getName())) {
                response.setName("\u8bbf\u5ba2");
            }
            if (!isShow) {
                response.setMobile(MaskUtil.maskMobile((String)response.getMobile()));
            }
            return response;
        }
        return null;
    }

    private String getLogo(int orgId) {
        if (this.orgLogoMap.get(orgId) != null) {
            return this.orgLogoMap.get(orgId);
        }
        String logo = OrgImgType.ORG_LOGO.getDefaultUrl();
        try {
            OrgStorage storage;
            OrgPhoto photo;
            Integer storageId;
            List photos = this.orgPhotoDao.getByOrgIdAndCategory(orgId, OrgImgType.ORG_LOGO.getValue());
            if (photos != null && !photos.isEmpty() && (storageId = (photo = (OrgPhoto)photos.get(0)).getOrgStorageId()) != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)Long.valueOf(storageId.longValue()), new String[0])) != null) {
                logo = this.constructUrl(storage);
            }
            this.orgLogoMap.put(orgId, logo);
        }
        catch (Exception e) {
            log.error("get org logo failed, e:{}", (Throwable)e);
        }
        return logo;
    }

    private String constructUrl(OrgStorage storage) {
        String imgServer = PropertiesReader.getValue((String)"upload", (String)"img.server");
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int syncData(PageDto pageDto, int maxId, int minId) {
        log.info("############## start");
        List messages = this.messageDao.selectMsgByPageDto(pageDto, maxId, minId);
        if (messages != null) {
            log.info("############## page start===");
            for (ConsultMessage message : messages) {
                MsgUserRole msgUserRole;
                OrgCacheDto cacheDto;
                TxConsultUser consultUser;
                if (message.getReceiverRole() == UserRoleEnum.STUDENT.getCode() && (consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)Long.valueOf(message.getReceiverId()), new String[0])) != null) {
                    message.setReceiverRole(this.cacheService.getUserRole(consultUser).intValue());
                }
                if (message.getReceiverRole() == UserRoleEnum.ORG.getCode() && (cacheDto = this.cacheService.getOrg(message.getReceiverId())) != null) {
                    msgUserRole = this.orgService.getOrgAccountType(cacheDto.getOrgId(), 0L);
                    message.setReceiverRole(msgUserRole.getValue());
                }
                if (message.getSenderRole() == UserRoleEnum.STUDENT.getCode() && (consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)Long.valueOf(message.getSenderId()), new String[0])) != null) {
                    message.setSenderRole(this.cacheService.getUserRole(consultUser).intValue());
                }
                if (message.getReceiverRole() == UserRoleEnum.ORG.getCode() && (cacheDto = this.cacheService.getOrg(message.getSenderId())) != null) {
                    msgUserRole = this.orgService.getOrgAccountType(cacheDto.getOrgId(), 0L);
                    message.setSenderRole(msgUserRole.getValue());
                }
                MsgContent content = MsgContentFactory.getContent(message);
                Gson gson = new Gson();
                message.setContent(gson.toJson((Object)content));
                this.messageDao.update(message);
            }
            log.info("######=success");
            return messages.size();
        }
        return 0;
    }
}

