package com.baijia.tianxiao.sal.organization.todo.dto;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.properties.UploadProperties;
import com.google.common.collect.Lists;

import lombok.Data;

@Data
public class HeadTeacherRespDto {

	//纪录id
	private Integer id;
	
	//班主任名称
	private String name;
	
	//班主任手机号
	private String mobile;
	
	//班主任头像url
	private String avatarUrl;
	
	public static List<HeadTeacherRespDto> converToDto(List<TXCascadeCredential> txCascadeCredentials, Map<Integer, Integer> map) {
		List<HeadTeacherRespDto> dtos = Lists.newArrayList();
        
		for(TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
			HeadTeacherRespDto dto = new HeadTeacherRespDto();
			if(map == null || !map.containsKey(txCascadeCredential.getId())) {
				dto.setId(0);
			} else {
				dto.setId(map.get(txCascadeCredential.getId()));
			}
			dto.setName(txCascadeCredential.getName());
			dto.setMobile(txCascadeCredential.getMobile());
			if(StringUtils.isNotBlank(txCascadeCredential.getAvatar())) {
				dto.setAvatarUrl(txCascadeCredential.getAvatar());
			}else {
				dto.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
			}
			dtos.add(dto);
		}
		return dtos;
	}
}
