package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/2
 * Time: 下午5:21
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class OrgTxtMsgServiceImpl implements OrgTxtMsgService {

    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;

    @Override
    public OrgTxtMsg getOrgTxtByIdAndType(int orgId, int type) {
        return orgTxtMsgDao.getOrgTxtByIdAndType(orgId, type);
    }

    @Override
    public OrgTxtMsg queryOrgTxtByType(int type, String value) {
        return orgTxtMsgDao.queryOrgTxtByType(type, value);
    }

    @Override
    public void saveOrUpdateTxtByType(int orgId, int type, String value) {
        OrgTxtMsg orgTxtMsg = orgTxtMsg = orgTxtMsgDao.getOrgTxtByIdAndType(orgId, type);

        if (orgTxtMsg == null) {
            orgTxtMsg = new OrgTxtMsg();
            orgTxtMsg.setOrgId(orgId);
            orgTxtMsg.setAuditstatus(AuditStatus.PASS.getValue());
            orgTxtMsg.setType(type);
            orgTxtMsg.setValue(value);
            orgTxtMsg.setCreateTime(DateUtil.getToday());
            orgTxtMsg.setUpdateTime(DateUtil.getToday());
        } else {
            orgTxtMsg.setValue(value);
            orgTxtMsg.setUpdateTime(DateUtil.getToday());
        }
        log.debug("save or update txt by type =={}", orgTxtMsg);
        orgTxtMsgDao.saveOrUpdate(orgTxtMsg);
    }
}
