package com.baijia.tianxiao.sal.organization.finance.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/7
 * Time: 下午7:32
 * To change this template use File | Settings | File Templates.
 */
public enum FinanceOpType {

    ORDER(1, "支付订单", 1, "支付"),

    JIANGLI(2, "邀请奖励", 2, "奖励"),

    TIXIAN(3, "申请提现", 3, "提现"),

    TIXIAN_CHENGGONG(4, "提现成功", 3, "提现"),

    TIXIAN_SHIBAI(5, "提现失败", 4, "提现退回"),

    TIXIAN_SHOUXUFEI(6, "提现手续费", 8, "手续费"),

    RUZHU_JIANGLI(7, "老师入驻平台奖励", 2, "奖励"),

    HONGBAO_ZHIFU(8, "红包支付", 1, "支付"),

    SHOUDAN_JIANGLI(12, "首单奖励", 2, "奖励"),

    TUIGUANG_FEIYONG(20, "推广费用", 9, "推广费用"),
    
    KOUCHU_JIANGLI(21, "奖励扣除", 2, "奖励"),

    TUIGUANG_CHONGZHI(22, "推广充值", 7, "充值"),

    HUODONG_JIANGLI(24, "排行榜活动奖励", 2, "奖励"),

    FANXIAN_JIANGLI(25, "首单返现活动奖励", 2, "奖励"),

    SHUANG12_BUTIE(26, "双十二活动补贴", 2, "奖励"),

    YIYUAN_BUTIE(27, "一元班课补贴", 2, "奖励"),

    XINYI_ZENGYIN(40, "心意赠饮", 1, "支付"),

    KECHOU(61, "确认课酬", 1, "支付"),

    CHONGZHI(62, "机构充值", 7, "充值"),

    BAOMING(63, "机构报名", 1, "支付"),

    SETTLEMENT(64, "支付订单", 1, "支付"),

    FAKUAN(65, "违规罚款", 10, "其他"),

    SHOUXUFEI(68, "支付手续费", 8, "手续费"),

    TUIFEI_SHOUXUFEI(69, "推广账户退费手续费", 8, "手续费"),

    FUWUFEI(70, "技术服务费", 9, "推广费用"),

    DUANXIN_GOUMAI(73, "短信购买", 10, "其他"),

    JIAONA_YONGJIN(74, "缴纳佣金", 9, "推广费用"),

    PAY_ORDER(77, "支付订单", 1, "支付"),

    TUIGUANGFEI(78, "渠道推广费", 9, "推广费用"),

    DRAWBACK(81, "退款", 5, "退款"),

    ZHIFU(101, "支付订单", 1, "支付"),

    JIAOYI_WANCHENG(102, "交易完成", 1, "支付"),

    BUFEN_TUIKUAN(103, "部分退款", 5, "退款"),

    QUANBU_TUIKUAN(104, "全额退款", 5, "退款"),

    ZHUANZHANG_CHENGGONG(105, "转账成功", 6, "转账"),;

    private Integer code;
    private String name;
    private Integer opType;
    private String opTypeName;

    private static Map<Integer, FinanceOpType> map = Maps.newHashMap();
    private static Map<Integer, List<Integer>> opTypeMap = Maps.newHashMap();


    static {
        for (FinanceOpType opType : FinanceOpType.values()) {
            map.put(opType.code, opType);
        }
    }

    static {
        for (FinanceOpType opType : FinanceOpType.values()) {
            List<Integer> opTypeList = Lists.newArrayList();
            if (opTypeMap.get(opType.getOpType()) == null) {
                opTypeList = Lists.newArrayList();
            } else {
                opTypeList = opTypeMap.get(opType.getOpType());
            }
            opTypeList.add(opType.getCode());
            opTypeMap.put(opType.getOpType(), opTypeList);
        }
    }

    FinanceOpType(int code, String name, Integer opType, String opTypeName) {
        this.code = code;
        this.name = name;
        this.opType = opType;
        this.opTypeName = opTypeName;
    }


    public static String getByCode(int code) {
        FinanceOpType o = map.get(code);
        if (o == null) {
            return "未知" + code;
        }
        return o.getOpTypeName();
    }

    public static List<Integer> getByOpType(List<Integer> opType) {
        List<Integer> result = Lists.newArrayList();
        for (Integer id : opType) {
            result.addAll(opTypeMap.get(id));
        }
        return result;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOpType() {
        return opType;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public String getOpTypeName() {
        return opTypeName;
    }

    public void setOpTypeName(String opTypeName) {
        this.opTypeName = opTypeName;
    }
}
