package com.baijia.tianxiao.sal.organization.dto;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppBaseRequest extends BaseDto {

    private static final Logger logger = LoggerFactory.getLogger(AppBaseRequest.class);

    private static final long serialVersionUID = 6380413937640585921L;

    // 当前软件的版本号
    private String current_version;

    // 写在manifest里面，服务器api的版本号
    private String api_version;

    // 设备的名称
    private String platform;

    // 设备的软件版本号
    private String platform_os;

    // 自己生成的uuid
    private String device_uuid;

    // 设备的唯一标识
    private String device_imei;

    // 设备的网卡信息
    private String device_mac;

    // 渠道号
    private String app_channel;

    // app登录后分配的token
    private String auth_token;

    // 数字签名
    private String signature;

    // 时间戳
    private String timestamp;

    // 机构id
    private Long orgId;

    // 参数校验
    private String errorMsg;

    public boolean validate() {
        boolean result = true;
        if (StringUtils.isBlank(auth_token)) {
            this.errorMsg = "AUTH_TOKEN不能为空";
            return false;
        }
        String json = EncryptUtils.strDecode(auth_token);

        logger.debug("AppBaseRequest.validate: token:{}", json);
        try {
            AppAuthToken token = JacksonUtil.str2Obj(json, AppAuthToken.class);
            this.orgId = token.getUser_id();
        } catch (Exception e) {
            this.errorMsg = "解析AUTH_TOKEN失败";
            result = false;
            logger.error("AppBaseRequest.validate: token:{}, e:{}", json, e);
        }
        return result;
    }

    public String getCurrent_version() {
        return current_version;
    }

    public void setCurrent_version(String current_version) {
        this.current_version = current_version;
    }

    public String getApi_version() {
        return api_version;
    }

    public void setApi_version(String api_version) {
        this.api_version = api_version;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform_os() {
        return platform_os;
    }

    public void setPlatform_os(String platform_os) {
        this.platform_os = platform_os;
    }

    public String getDevice_uuid() {
        return device_uuid;
    }

    public void setDevice_uuid(String device_uuid) {
        this.device_uuid = device_uuid;
    }

    public String getDevice_imei() {
        return device_imei;
    }

    public void setDevice_imei(String device_imei) {
        this.device_imei = device_imei;
    }

    public String getDevice_mac() {
        return device_mac;
    }

    public void setDevice_mac(String device_mac) {
        this.device_mac = device_mac;
    }

    public String getApp_channel() {
        return app_channel;
    }

    public void setApp_channel(String app_channel) {
        this.app_channel = app_channel;
    }

    public String getAuth_token() {
        return auth_token;
    }

    public void setAuth_token(String auth_token) {
        this.auth_token = auth_token;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public static void main(String[] args) {
        String json = EncryptUtils.strDecode("B4IpfHpseWZxbCpCOz05OzUrbH0rQzs-PjpBPkA8PkM3LX5seIAuRi59hmRuQ1ZOPy-L");

        logger.debug("AppBaseRequest.validate: token:{}", json);
        try {
            AppAuthToken token = JacksonUtil.str2Obj(json, AppAuthToken.class);
            System.out.println(token);
        } catch (Exception e) {
            logger.error("AppBaseRequest.validate: token:{}, e:{}", json, e);
        }
    }
}
